package com.kidoz.events;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

public class EventLogDatabaseManager extends SQLiteOpenHelper
{
	private static final String DATABASE_NAME = "KIDOZ_SDK_EVENT_DATABASE";

	private EventsTable mEventsTable;
	private final static int DATABASE_VERSION = 1;
	
	private int mOpenCounter;
	private SQLiteDatabase mDatabase;


	public EventLogDatabaseManager(Context context)
	{
		super(context, DATABASE_NAME, null, DATABASE_VERSION);
		initDatabase();
	}

	private void initDatabase()
	{
		mEventsTable = new EventsTable(this);
	}

	@Override
	public void onCreate(SQLiteDatabase db)
	{
		EventsTable.onCreate(db);
	}

	@Override
	public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion)
	{
		EventsTable.onUpgrade(db, oldVersion, newVersion);
	}

	public EventsTable getEventsTable()
	{
		return mEventsTable;
	}
	
	
	public synchronized SQLiteDatabase openDatabase()
	{
		mOpenCounter++;
		if (mOpenCounter == 1)
		{
			// Opening new database
			mDatabase = getWritableDatabase();
		}
		return mDatabase;
	}

	public synchronized void closeDatabase()
	{
		mOpenCounter--;
		if (mOpenCounter == 0)
		{
			// Closing database
			mDatabase.close();
		}
	}
}
