package com.kidoz.sdk.api.ui_views.one_item_view;

import android.animation.Animator;
import android.os.Looper;
import android.os.Message;
import android.support.v4.view.PagerAdapter;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;

import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.assets_handling.SoundAssetsUtils;
import com.kidoz.sdk.api.general.utils.SdkAnimationsUtils;
import com.kidoz.sdk.api.general.utils.SdkSoundManager;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;
import com.kidoz.sdk.api.ui_views.panel_view.PanelContentItem;

import java.util.ArrayList;

/**
 * Created by roni on 11/18/2015.
 */
public class ItemViewPagerAdapter extends PagerAdapter
{
    private PANEL_TYPE mPanelType;
    private ArrayList<ContentItem> mContent;
    private ViewPagerItemClickListener mViewPagerItemClickListener;
    private boolean mIsCanClick;

    public ItemViewPagerAdapter()
    {
        mContent = new ArrayList<>();
        mPanelType = PANEL_TYPE.LEFT;
        mIsCanClick = true;
    }

    public void setViewPagerItemClickListener(ViewPagerItemClickListener viewPagerItemClickListener)
    {
        mViewPagerItemClickListener = viewPagerItemClickListener;
    }

    @Override public int getCount()
    {
        int result = 0;
        if (mContent != null)
        {
            result = mContent.size();
        }
        return result;
    }

    public void setContent(ArrayList<ContentItem> content, PANEL_TYPE panelType)
    {
        mContent = content;
        mPanelType = panelType;
        notifyDataSetChanged();
    }

    @Override public Object instantiateItem(ViewGroup container, final int position)
    {
        PanelContentItem panelContentItem = new PanelContentItem(container.getContext(), mPanelType);
        final ContentItem contentItem = mContent.get(position);
        panelContentItem.setOnClickListener(new View.OnClickListener()
        {
            @Override public void onClick(View view)
            {
                if (mIsCanClick == true)
                {
                    SdkSoundManager.playSound(view.getContext(), SoundAssetsUtils.getSoundAssetFile(view.getContext(), SoundAssetsUtils.SOUND_ASSET_TYPE.ITEM_CLICK).getAbsolutePath());
                    mIsCanClick = false;
                    SdkAnimationsUtils.animateClick(view, new Animator.AnimatorListener()
                    {
                        @Override public void onAnimationStart(Animator animation)
                        {
                        }

                        @Override public void onAnimationEnd(Animator animation)
                        {
                            mViewPagerItemClickListener.onClickEnd(contentItem, position);
                            mIsCanClick = true;
                        }

                        @Override public void onAnimationCancel(Animator animation)
                        {

                        }

                        @Override public void onAnimationRepeat(Animator animation)
                        {

                        }
                    }, 50, 100);
                }
            }
        });
        if (contentItem != null)
        {
            panelContentItem.setData(contentItem);
        }
        container.addView(panelContentItem);
        return panelContentItem;
    }

    @Override public boolean isViewFromObject(View view, Object object)
    {
        return view == object;
    }

    @Override public void destroyItem(ViewGroup container, int position, Object object)
    {
        container.removeView((PanelContentItem) object);
    }

    public interface ViewPagerItemClickListener
    {
        public void onClickEnd(ContentItem contentItem, int position);
    }

    public ContentItem getContentItem(int position)
    {
        ContentItem result = null;
        if (mContent != null && mContent.size() > position)
        {
            result = mContent.get(position);
        }
        return result;
    }
}
