package com.kidoz.sdk.api.ui_views.loading_progress_view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;

import com.kidoz.sdk.api.general.utils.Utils;

public class LoadingProgressView extends View
{
    private CircularProgressDrawable mDrawable;

    public LoadingProgressView(Context context)
    {
        this(context, null);
    }

    public LoadingProgressView(Context context, AttributeSet attrs)
    {
        this(context, attrs, 0);
    }

    public LoadingProgressView(Context context, AttributeSet attrs, int defStyleAttr)
    {
        super(context, attrs, defStyleAttr);
        int screenWidth = Utils.getScreenSize(context, true);
        float LINE_WIDTH = 20f / 1080f;
        mDrawable = new CircularProgressDrawable(Color.parseColor("#f57900"), screenWidth * LINE_WIDTH);
        mDrawable.setCallback(this);
    }

    public void setCircleColor(int color)
    {
        mDrawable.setPaintColor(color);
    }

    public void setCircleWidth(float width)
    {
        mDrawable.setStrokeWidth(width);
    }

    public void startLoadingAnimation()
    {
        setVisibility(View.VISIBLE);
        mDrawable.start();
    }

    public void stopLoadingAnimation()
    {
        mDrawable.stop();
        setVisibility(View.GONE);
    }

    @Override protected void onSizeChanged(int w, int h, int oldw, int oldh)
    {
        super.onSizeChanged(w, h, oldw, oldh);
        mDrawable.setBounds(0, 0, w, h);
    }

    @Override public void draw(Canvas canvas)
    {
        super.draw(canvas);
        mDrawable.draw(canvas);
    }

    @Override protected boolean verifyDrawable(Drawable who)
    {
        return who == mDrawable || super.verifyDrawable(who);
    }
}
