package com.kidoz.sdk.api.platforms;

import java.util.HashMap;
import java.util.Map;

import android.content.Context;
import android.util.Log;

import com.adobe.fre.FREContext;
import com.adobe.fre.FREExtension;
import com.adobe.fre.FREFunction;
import com.adobe.fre.FREInvalidObjectException;
import com.adobe.fre.FREObject;
import com.adobe.fre.FRETypeMismatchException;
import com.adobe.fre.FREWrongThreadException;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.utils.SDKLogger;

public class KidozAirBridgeExtension implements FREExtension {
	public static final String TAG = "KidozAdobeAirBridge";

	public static FREContext extensionContext;
	public static Context appContext;
	public static AdobeAirUiManager mAdobeAirUiManager;

	@Override
	public FREContext createContext(String arg0) {
		// TODO Auto-generated method stub
		return new KidozAdobeAirBridgeContext();
	}

	@Override
	public void dispose() {
		appContext = null;
		extensionContext = null;
	}

	@Override
	public void initialize() {
		SDKLogger.printDebbugLog(TAG, "Extension initialized.");
	}

}

class KidozAdobeAirBridgeContext extends FREContext {
	public static final String TAG = "VolumeExtensionContext";

	@Override
	public void dispose() {
		SDKLogger.printDebbugLog(TAG, "Context disposed.");
	}

	@Override
	public Map<String, FREFunction> getFunctions() {
		Map<String, FREFunction> functions = new HashMap<String, FREFunction>();

		functions.put("initSdk", new initSdk());
		functions.put("addFeedButton", new addFeedButton());

		return functions;
	}
}

class initSdk implements FREFunction {
	public static final String TAG = "initSdk";

	@Override
	public FREObject call(FREContext context, FREObject[] arg1) {

		// Assign extension context
		KidozAirBridgeExtension.extensionContext = context;
		// Assign main application context
		Context appContext = context.getActivity();// .getApplicationContext();
		KidozAirBridgeExtension.appContext = appContext;
		// Initiate UI manager
		KidozAirBridgeExtension.mAdobeAirUiManager = new AdobeAirUiManager(
				appContext);

		try {
			KidozSDK.initialize(appContext, arg1[0].getAsString(),
					arg1[1].getAsString());
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		SDKLogger.printInfoLog(TAG, "in init");

		// Tell AIR what the volume is right now.
		// VolumeExtension.notifyVolumeChange();
		return null;
	}
}

class addFeedButton implements FREFunction {
	public static final String TAG = "addFeedButton";

	@Override
	public FREObject call(FREContext context, FREObject[] arg1) {

		try {
			KidozAirBridgeExtension.mAdobeAirUiManager.addFeedButton(
					arg1[0].getAsInt(), arg1[1].getAsInt());
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}
}
