package com.kidoz.sdk.api.platforms;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

import com.kidoz.sdk.api.FeedButton;
import com.kidoz.sdk.api.FeedView;
import com.kidoz.sdk.api.PanelView;
import com.kidoz.sdk.api.interfaces.IOnFeedViewEventListener;
import com.kidoz.sdk.api.interfaces.IOnPanelViewEventListener;
import com.kidoz.sdk.api.ui_views.panel_view.HANDLE_POSITION;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;
import com.unity3d.player.UnityPlayer;

public class AdobeAirUiManager {

	public static final int HANDLE_POSITION_START = 0;
	public static final int HANDLE_POSITION_CENTER = 1;
	public static final int HANDLE_POSITION_END = 2;

	public static final int PANEL_TYPE_BOTTOM = 0;
	public static final int PANEL_TYPE_TOP = 1;
	public static final int PANEL_TYPE_LEFT = 2;
	public static final int PANEL_TYPE_RIGHT = 3;

	private static KidozUnityBridge mKidozUnity;

	private Context mContext;
	private FeedView mFeedView;
	private PanelView mPanelView;
	private FeedButton mFeedButton;

	private FrameLayout mContainer;
	private boolean isContianerAdded = false;

	private String mGameObject;
	private String mShowMethodName;
	private String mDismissMethodName;

	private String mExpandMethodName;
	private String mCollapseMethodName;

    

	public AdobeAirUiManager(Context context) {
		mContainer = new FrameLayout(mContext);
	}

	/**
	 * Add Feed Button to view (The button will be added with default size)
	 *
	 * @param x
	 *            the x coordinate of the button
	 * @param y
	 *            the y coordinate of the button
	 */
	public void addFeedButton(final int x, final int y) {
		addFeedButton(x, y, -1);
	}

	/**
	 * Add Feed Button to view
	 *
	 * @param x
	 *            the x coordinate of the button
	 * @param y
	 *            the y coordinate of the button
	 * @param size
	 *            button size
	 */
	public void addFeedButton(final int x, final int y, final int size) {
		addContainerIfNeeded();

		if (mFeedButton == null) {
			if (mContext instanceof Activity) {
				((Activity) mContext).runOnUiThread(new Runnable() {
					@Override
					public void run() {

						if (size == -1) {
							mFeedButton = new FeedButton(mContext);
						} else {
							mFeedButton = new FeedButton(mContext, size);
						}

						mFeedButton.getFeedView().setOnFeedViewEventListener(
								new IOnFeedViewEventListener() {
									@Override
									public void onDismissView() {
										if (mGameObject != null
												&& mDismissMethodName != null) {
											UnityPlayer.UnitySendMessage(
													mGameObject,
													mDismissMethodName, "Show");
										}
									}

									@Override
									public void onReadyToShow() {
										if (mGameObject != null
												&& mShowMethodName != null) {
											UnityPlayer.UnitySendMessage(
													mGameObject,
													mShowMethodName, "Dismiss");
										}
									}
								});

						if (isChildViewExistsInContainer(mFeedButton) == false) {
							FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(
									FrameLayout.LayoutParams.WRAP_CONTENT,
									FrameLayout.LayoutParams.WRAP_CONTENT);
							params.setMargins(x, y, 0, 0);
							mContainer.addView(mFeedButton, params);
						}
					}
				});
			}
		}
	}

	/**
	 * Change feed button visibility state
	 */
	public void changeFeedButtonVisibility(final boolean visible) {
		if (mContext instanceof Activity) {
			((Activity) mContext).runOnUiThread(new Runnable() {
				@Override
				public void run() {
					if (mFeedButton != null) {
						if (visible) {
							mFeedButton.setVisibility(View.VISIBLE);
						} else {
							mFeedButton.setVisibility(View.INVISIBLE);
						}
					}
				}
			});
		}
	}

	/**
	 * Check if main container has this view as a child
	 */
	private boolean isChildViewExistsInContainer(View view) {
		boolean exists = false;
		if (mContainer != null && mContainer.getChildCount() > 0) {
			for (int i = 0; i < mContainer.getChildCount(); i++) {
				if (mContainer.getChildAt(i) == view) {
					exists = true;
					break;
				}
			}
		}
		return exists;
	}

	/**
	 * Adds views holder container to a main activity view
	 */
	private void addContainerIfNeeded() {
		if (mContext instanceof Activity) {
			((Activity) mContext).runOnUiThread(new Runnable() {
				@Override
				public void run() {
					if (isContianerAdded == false) {
						if (mContext instanceof Activity) {
							((Activity) mContext)
									.addContentView(
											mContainer,
											new ViewGroup.LayoutParams(
													ViewGroup.LayoutParams.MATCH_PARENT,
													ViewGroup.LayoutParams.MATCH_PARENT));
							isContianerAdded = true;
						}
					}
				}
			});
		}
	}

	/**
	 * Show feed view
	 */
	public void showFeedView() {
		if (mContext instanceof Activity) {
			((Activity) mContext).runOnUiThread(new Runnable() {
				@Override
				public void run() {
					if (mFeedView != null) {
						mFeedView.showView();
					}
				}
			});
		}
	}

	/**
	 * Dismiss feed view
	 */
	public void dismissFeedView() {
		if (mContext instanceof Activity) {
			((Activity) mContext).runOnUiThread(new Runnable() {
				@Override
				public void run() {

					if (mFeedView == null) {
						mFeedView = new FeedView.Builder(mContext).build();
						mFeedView
								.setOnFeedViewEventListener(new IOnFeedViewEventListener() {
									@Override
									public void onDismissView() {
										if (mGameObject != null
												&& mDismissMethodName != null) {
											UnityPlayer.UnitySendMessage(
													mGameObject,
													mDismissMethodName,
													"Dismiss");
										}
									}

									@Override
									public void onReadyToShow() {
										if (mGameObject != null
												&& mShowMethodName != null) {
											UnityPlayer.UnitySendMessage(
													mGameObject,
													mShowMethodName, "Show");
										}
									}
								});
					}

					if (mFeedView != null) {
						mFeedView.dismissView();
					}
				}
			});
		}
	}

	/**
	 * Set callback for listening feed view dismiss and show events
	 */
	public void setFeedViewEventListeners(String gameObject,
			String showMethodName, String dismissMethodName) {
		mGameObject = gameObject;
		mShowMethodName = showMethodName;
		mDismissMethodName = dismissMethodName;
	}

	/**
	 * Add PanelView to view
	 *
	 * @param panel_type
	 *            panel view type
	 * @param handle_position
	 *            panel handle position
	 */
	public void addPanelToView(final int panel_type, final int handle_position) {

		addPanelToView(panel_type, handle_position, null);
	}

	/**
	 * Add PanelView to view
	 *
	 * @param panel_type
	 *            panel view type
	 * @param handle_position
	 *            panel handle position
	 * @param customHandle
	 *            user defined custom handle
	 */
	public void addPanelToView(final int panel_type, final int handle_position,
			final View customHandle) {

		addContainerIfNeeded();

		if (mPanelView == null) {
			if (mContext instanceof Activity) {
				((Activity) mContext).runOnUiThread(new Runnable() {
					@Override
					public void run() {

						PANEL_TYPE mPanelType = PANEL_TYPE.BOTTOM;
						HANDLE_POSITION mHandlePos = HANDLE_POSITION.START;

						switch (panel_type) {
						case PANEL_TYPE_BOTTOM: {
							mPanelType = PANEL_TYPE.BOTTOM;
							break;
						}
						case PANEL_TYPE_LEFT: {
							mPanelType = PANEL_TYPE.LEFT;
							break;
						}
						case PANEL_TYPE_RIGHT: {
							mPanelType = PANEL_TYPE.RIGHT;
							break;
						}
						case PANEL_TYPE_TOP: {
							mPanelType = PANEL_TYPE.TOP;
							break;
						}
						}

						switch (handle_position) {
						case HANDLE_POSITION_START: {
							mHandlePos = HANDLE_POSITION.START;
							break;
						}
						case HANDLE_POSITION_CENTER: {
							mHandlePos = HANDLE_POSITION.CENTER;
							break;
						}
						case HANDLE_POSITION_END: {
							mHandlePos = HANDLE_POSITION.END;
							break;
						}

						}

						mPanelView = new PanelView(mContext);
						mPanelView.setPanelConfiguration(mPanelType,
								mHandlePos, customHandle);
						mPanelView
								.setOnPanelViewEventListener(new IOnPanelViewEventListener() {
									@Override
									public void onPanelViewCollapsed() {
										if (mGameObject != null
												&& mCollapseMethodName != null) {
											UnityPlayer.UnitySendMessage(
													mGameObject,
													mCollapseMethodName,
													"Collapse");
										}
									}

									@Override
									public void onPanelViewExpanded() {
										if (mGameObject != null
												&& mExpandMethodName != null) {
											UnityPlayer
													.UnitySendMessage(
															mGameObject,
															mExpandMethodName,
															"Expand");
										}
									}
								});

						if (isChildViewExistsInContainer(mPanelView) == false) {
							FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(
									FrameLayout.LayoutParams.MATCH_PARENT,
									FrameLayout.LayoutParams.MATCH_PARENT);
							mContainer.addView(mPanelView, params);
						}
					}
				});
			}
		}
	}

	/**
	 * Change feed button visibility state
	 */
	public void changePanelVisibility(final boolean visible) {
		if (mContext instanceof Activity) {
			((Activity) mContext).runOnUiThread(new Runnable() {
				@Override
				public void run() {
					if (mPanelView != null) {
						if (visible) {
							mPanelView.setVisibility(View.VISIBLE);
						} else {
							mPanelView.setVisibility(View.INVISIBLE);
						}
					}
				}
			});
		}

	}

	/**
	 * Expand panel view
	 */
	public void expandPanelView() {
		if (mContext instanceof Activity) {
			((Activity) mContext).runOnUiThread(new Runnable() {
				@Override
				public void run() {
					if (mPanelView.getIsPanelViewExpanded() == false) {
						mPanelView.expandPanelView();
					}
				}
			});
		}
	}

	/**
	 * Collapse panel view
	 */
	public void collapsePanelView() {
		if (mContext instanceof Activity) {
			((Activity) mContext).runOnUiThread(new Runnable() {
				@Override
				public void run() {
					if (mPanelView.getIsPanelViewExpanded()) {
						mPanelView.collapsePanelView();
					}
				}
			});
		}
	}

	/**
	 * Set callback for listening for panel open/close events
	 *
	 * @param gameObject
	 */
	public void setPanelViewEventListeners(String gameObject,
			String expandMethodName, String collapseMethodName) {
		mGameObject = gameObject;
		mExpandMethodName = expandMethodName;
		mCollapseMethodName = collapseMethodName;
	}

	/**
	 * Get feed button default size
	 *
	 * @return default button size in pixels
	 */
	public int getFeedButtonDefaultSize(Context context) {
		return FeedButton.getDefaultButtonSize(context);
	}
}
