package com.kidoz.sdk.api.general.utils;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by Eugine on 9/30/2015.
 */
public class PropertiesObj {

    private static final String CONFIG_VERSION = "configuration_version";
    private static final String IS_PARENTAL_LOCK = "is_parental_lock_activated";
    private static final String FEED_BUTTON_VIEW_URL = "btnUrl";
    private static final String FEED_BUTTON_ANIMATION_TYPE = "btnAnimation";
    private static final String PANEL_BUTTON_URL = "panelBtn";
    private static final String PANEL_BUTTON_CLOSE_URL = "panelBtnClose";
    private static final String PANEL_BUTTON_ANIMATION_TYPE = "panelBtnAnimation";
    private static final String PANEL_BACKGROUND_COLOR = "panelBgClr";
    private static final String SDK_STYLE_VERSION = "style";
    private static final String PANEL_BUTTON_SCALE_PERCENTAGE = "panelBtnScale";

    JSONObject mProperties = new JSONObject();

    public PropertiesObj(JSONObject data) {
        mProperties = data;
    }

    public JSONObject getData() {
        return mProperties;
    }

    public int getConfigVersion() {
        return mProperties.optInt(CONFIG_VERSION, 1);
    }

    public boolean isParentalLockActive() {
        return mProperties.optBoolean(IS_PARENTAL_LOCK, false);
    }

    public String getFeedButtonUrl() {
        return mProperties.optString(FEED_BUTTON_VIEW_URL);
    }

    public String getPanelButtonUrl() {
        return mProperties.optString(PANEL_BUTTON_URL);
    }

    public String getPanelButtonCloseUrl() {
        return mProperties.optString(PANEL_BUTTON_CLOSE_URL);
    }

    public int getFeedButtonAnimationType() {
        return mProperties.optInt(FEED_BUTTON_ANIMATION_TYPE, 0);
    }

    public int getPanelButtonAnimationType() {
        return mProperties.optInt(PANEL_BUTTON_ANIMATION_TYPE, 0);
    }

    public String getPanelBackGroundColor() {
        return mProperties.optString(PANEL_BACKGROUND_COLOR, "#ffffff");
    }

    public double getPanelButtonScaleValue() {
        return mProperties.optDouble(PANEL_BUTTON_SCALE_PERCENTAGE, 0.15f);
    }

    public int getSdkStyleVersion() {
        return mProperties.optInt(SDK_STYLE_VERSION, 0);
    }

    public JSONObject getProperties() {
        return mProperties;
    }

    public void setConfigVersion(int version) {
        try {
            mProperties.put(CONFIG_VERSION, version);
        } catch (JSONException e) {
        }
    }

    // Update Configuration properties from other properties object (Updates all except the Configuration Version field)
    public void updateConfigFromData(PropertiesObj data) {
        try {
            if (data != null) {
                mProperties.put(FEED_BUTTON_ANIMATION_TYPE, data.getFeedButtonAnimationType());
                mProperties.put(FEED_BUTTON_VIEW_URL, data.getFeedButtonUrl());
                mProperties.put(IS_PARENTAL_LOCK, data.isParentalLockActive());
                mProperties.put(PANEL_BUTTON_ANIMATION_TYPE, data.getPanelButtonAnimationType());
                mProperties.put(PANEL_BUTTON_URL, data.getPanelButtonUrl());
                mProperties.put(PANEL_BUTTON_CLOSE_URL, data.getPanelButtonCloseUrl());
                mProperties.put(PANEL_BACKGROUND_COLOR, data.getPanelBackGroundColor());
                mProperties.put(SDK_STYLE_VERSION, data.getSdkStyleVersion());
                mProperties.put(PANEL_BUTTON_SCALE_PERCENTAGE, data.getPanelButtonScaleValue());
            }

        } catch (JSONException e) {
        }
    }
}
