package com.kidoz.sdk.api;


import android.app.Activity;
import android.content.Context;
import android.view.View;

import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.interfaces.IOnFeedViewEventListener;
import com.kidoz.sdk.api.structure.ContentData;

public class FeedView
{

    private static final int SYNC_MIN_TIME_FRAME = 12 * 60 * 60 * 1000; //12 hours

    private static final String TAG = FeedView.class.getSimpleName();

    private Builder mBuilder;

    private FeedViewDialog mFeedViewDialog;
    protected ContentLogicLoader mContentLogicLoader;

    private IOnFeedViewEventListener mOnInterstitialViewEventListener;
    /**
     * Flag used to check ,is Pre load or Post load the content data
     */
    private boolean mIsPostLoadData = false;

    private FeedView(Builder builder)
    {
        mBuilder = builder;
        initContentLogicLoader();
    }


    /**
     * Initiate  content loader logic ,that handles all the logic for loading content
     **/
    private void initContentLogicLoader()
    {
        mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback()
        {
            @Override public void onDataReady(ContentData contentData)
            {
                mFeedViewDialog.setContentData(contentData);

                if (mIsPostLoadData == false)
                {
                    if (mOnInterstitialViewEventListener != null)
                    {
                        mOnInterstitialViewEventListener.onReadyToShow();
                    }

                    openSimpleDialog();
                }
            }
        });
    }

    /**
     * Show feed interstitial view (Will be shown <b>After</b> content data is ready)
     **/
   /* public void showView() {
        mIsPostLoadData = false;
        mContentLogicLoader.loadContent(mBuilder.mContext, WidgetType.WIDGET_TYPE_FEED);
    }*/

    /**
     * Show feed interstitial view (Will be shown <b>Before</b> content data is ready)
     **/
    public void showView()
    {
        mIsPostLoadData = true;

        if (mOnInterstitialViewEventListener != null)
        {
            mOnInterstitialViewEventListener.onReadyToShow();
        }

        openSimpleDialog();

        mContentLogicLoader.loadContent(mBuilder.mContext, WidgetType.WIDGET_TYPE_FEED);
    }

    /**
     * Create and open simple (Not fragment based) Dialog view
     */
    private void openSimpleDialog()
    {
        if (mBuilder.mContext != null && mBuilder.mContext instanceof Activity)
        {
            mFeedViewDialog = new FeedViewDialog(mBuilder.mContext,mOnInterstitialViewEventListener);
            asingCloseButtonCliclListener();
            mFeedViewDialog.openDialog();
        }
    }

    private void asingCloseButtonCliclListener() {
        mFeedViewDialog.setOnCloseButtonClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dismissView();
                EventManager.getInstance(mBuilder.mContext).clearAllTempStoredEvents();
            }
        });
    }

    /**
     * Dismiss view
     **/
    public void dismissView()
    {
        if (mFeedViewDialog != null)
        {
            mFeedViewDialog.closeDialog();
        }

        if (mOnInterstitialViewEventListener != null)
        {
            mOnInterstitialViewEventListener.onDismissView();
        }
    }

    /**
     * Set on view event listener
     *
     * @param listener
     **/
    public void setOnFeedViewEventListener(IOnFeedViewEventListener listener)
    {
        mOnInterstitialViewEventListener = listener;
        if (mFeedViewDialog != null)
        {
            mFeedViewDialog.setOnInterstitialViewEventListener(mOnInterstitialViewEventListener);
        }
    }

    /**
     * Builder class that handles view initiation
     **/
    public static class Builder
    {
        private Context mContext;

        public Builder(Context context)
        {
            mContext = context;
        }

        public FeedView build()
        {
            return new FeedView(this);
        }
    }

    /**
     * On configuration change for correct flow of orientation change on open view
     **/
    public void onConfigurationChange()
    {
        if (mFeedViewDialog != null)
        {
            asingCloseButtonCliclListener();
        }
    }
}
