package com.kidoz.sdk.api;

import android.animation.Animator;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.dialogs.AboutKidozDialog;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.interfaces.IOnPanelViewEventListener;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.custom_drawables.DefaultPanelDrawable;
import com.kidoz.sdk.api.ui_views.one_item_view.ItemViewPagerAdapter;
import com.kidoz.sdk.api.ui_views.one_item_view.OneItemView;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;
import com.kidoz.sdk.api.ui_views.panel_view.PanelButton;
import com.kidoz.sdk.api.ui_views.panel_view.PanelStyleableButtonView;


public class FamilyPanelView extends RelativeLayout
{

    private static final int BUTTON_STYLE_RESOURCE_NOT_READY_REPEAT_COUNT = 7;
    private static final int DEFAULT_PANEL_BG_COLOR = Color.WHITE;
    private static final int DEFAULT_SHADOW_LINE_SIZE = 10;

    private final String TAG = FamilyPanelView.class.getSimpleName();

    private PANEL_TYPE mPanelType;
    private com.kidoz.sdk.api.ui_views.panel_view.HANDLE_POSITION mHandlePosition;

    private RelativeLayout mRootView;
    private RelativeLayout mContainer;
    private RelativeLayout mInnerContainer;
    private ContentLogicLoader mContentLogicLoader;
    private PanelStyleableButtonView mHandleButton;
    private PanelButton mParentalLockButton;
    private PanelButton mAboutKidozButton;
    private RelativeLayout mCustomUserHandleButton;
    private TextView mPoweredByTextView;
    private View mShadowView;
    private RelativeLayout mBottomBarContainer;
    private OneItemView mOneItemView;
    private IOnPanelViewEventListener mIOnPanelViewEventListener;
    private boolean mIsOpen;
    private boolean mIsAnimationRunning;
    private boolean mIsClicksBlocked;
    private boolean mAllowClickHandle = true;
    private boolean mIsCustomHandleSet = false;

    private int mPanelBgColor = DEFAULT_PANEL_BG_COLOR;

    private Utils.StaticHandler mStaticHandler;
    private Utils.StaticHandler mUiLoaderStaticHandler;

    private int mNotReadyRepeatCount = 0;

    public FamilyPanelView(Context context)
    {
        super(context);
        initView();
    }

    public FamilyPanelView(Context context, AttributeSet attrs)
    {
        super(context, attrs);
        initView();
    }

    public FamilyPanelView(Context context, AttributeSet attrs, int defStyleAttr)
    {
        super(context, attrs, defStyleAttr);
        initView();
    }

    private void initView()
    {
        initPanelTypeAndHandlePosition();
        initRootView();
        initContainer();
        initShadowLineView();
        initHandleButton();
        initOneItemView();
        initParentalLockButton();
        initAboutKidozkButton();
        initBottomTitleBar();
        initPanelViewsRules();
        initContentLogicLoader();
        preparePanel();
    }

    private void initRootView()
    {
        mRootView = new RelativeLayout(getContext());
        mRootView.setBackgroundColor(Color.TRANSPARENT);
        LayoutParams params = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
        addView(mRootView, params);
    }

    private void initContainer()
    {
        mContainer = new RelativeLayout(getContext());
        mContainer.setBackgroundColor(Color.TRANSPARENT);
        mContainer.setId(Utils.generateViewId());
        LayoutParams params = new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        mRootView.addView(mContainer, params);

        mInnerContainer = new RelativeLayout(getContext());
        mInnerContainer.setId(Utils.generateViewId());
        mInnerContainer.setBackgroundColor(Color.WHITE);

        params = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
        mContainer.addView(mInnerContainer, params);
    }

    private void initHandleButton()
    {
        mHandleButton = new PanelStyleableButtonView(getContext(), mPanelType, new PanelStyleableButtonView.PanelButtonListener()
        {
            @Override
            public void onClickStarted()
            {

            }

            @Override
            public void onClickEnd()
            {
                toggleAnimation();
            }
        });

        // Default handle button
        mHandleButton.setId(Utils.generateViewId());
        LayoutParams params = new LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        mContainer.addView(mHandleButton, params);

        // User defined custom handle button
        mCustomUserHandleButton = new RelativeLayout(getContext());
        mCustomUserHandleButton.setId(Utils.generateViewId());
        params = new LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        mContainer.addView(mCustomUserHandleButton, params);
        mCustomUserHandleButton.setVisibility(View.INVISIBLE);

        loadButtonStyleView();
    }

    private void initBottomTitleBar()
    {

        mBottomBarContainer = new RelativeLayout(getContext());
        mBottomBarContainer.setBackgroundColor(mPanelBgColor);
        mBottomBarContainer.setId(Utils.generateViewId());
        LayoutParams params = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
        mInnerContainer.addView(mBottomBarContainer, params);

        mPoweredByTextView = new TextView(getContext());
        mPoweredByTextView.setText("Recommended Content by KIDOZ");
        mPoweredByTextView.setTextColor(Color.WHITE);
        mPoweredByTextView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 12);
        mPoweredByTextView.setLines(1);
        mPoweredByTextView.setEllipsize(TextUtils.TruncateAt.END);
        mPoweredByTextView.setGravity(Gravity.CENTER);

        params = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
        params.setMargins(Utils.dpTOpx(getContext(), 4), Utils.dpTOpx(getContext(), 5), Utils.dpTOpx(getContext(), 4), Utils.dpTOpx(getContext(), 5));
        params.addRule(RelativeLayout.LEFT_OF, mParentalLockButton.getId());
        params.addRule(RelativeLayout.RIGHT_OF, mAboutKidozButton.getId());
        mBottomBarContainer.addView(mPoweredByTextView, params);
    }

    private void initParentalLockButton()
    {
        mParentalLockButton = new PanelButton(getContext(), PANEL_TYPE.BOTTOM, com.kidoz.sdk.api.ui_views.panel_view.PANEL_BUTTON_TYPE.PARENTAL_LOCK, new PanelButton.PanelButtonListener()
        {
            @Override
            public void onClickStarted()
            {

            }

            @Override
            public void onClickEnd()
            {
                if (mIsClicksBlocked == false)
                {
                    mIsClicksBlocked = true;
                    if (ParentalLockDialog.getIsCanShowDialog(getContext()) == true)
                    {
                        int[] popLocation = new int[2];
                        popLocation[0] = (int) (ScreenUtils.getScreenSize(getContext(), true) * 0.5f);
                        popLocation[1] = (int) (ScreenUtils.getScreenSize(getContext(), false) * 0.5f);
                        ParentalLockDialog parentalLockDialog = new ParentalLockDialog(getContext(), false, popLocation);
                        parentalLockDialog.setOnDismissListener(new DialogInterface.OnDismissListener()
                        {
                            @Override
                            public void onDismiss(DialogInterface dialog)
                            {
                                //Refresh the parental lock icon
                                boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
                                mParentalLockButton.setIsLockActive(isLockActive);
                                mIsClicksBlocked = false;
                            }
                        });
                        parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener()
                        {
                            @Override
                            public void onPasswordEntered(boolean isPasswordCorrect)
                            {
                                boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
                                mParentalLockButton.setIsLockActive(isLockActive);
                            }
                        });
                        parentalLockDialog.show();
                    }
                    else
                    {
                        mIsClicksBlocked = false;
                    }
                }
            }
        });
        mParentalLockButton.setId(Utils.generateViewId());
        LayoutParams params = new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        mParentalLockButton.setRoundedCornerDirection(PanelButton.RoundedCornerDirection.LEFT);
        mInnerContainer.addView(mParentalLockButton, params);
        boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
        mParentalLockButton.setIsLockActive(isLockActive);
    }

    private void initAboutKidozkButton()
    {
        mAboutKidozButton = new PanelButton(getContext(), PANEL_TYPE.BOTTOM, com.kidoz.sdk.api.ui_views.panel_view.PANEL_BUTTON_TYPE.ABOUT_KIDOZ, new PanelButton.PanelButtonListener()
        {
            @Override
            public void onClickStarted()
            {

            }

            @Override
            public void onClickEnd()
            {
                int[] popLocation = new int[2];
                popLocation[0] = (int) (ScreenUtils.getScreenSize(getContext(), true) * 0.5f);
                popLocation[1] = (int) (ScreenUtils.getScreenSize(getContext(), false) * 0.5f);
                AboutKidozDialog aboutKidozDialog = new AboutKidozDialog(getContext(), popLocation);
                aboutKidozDialog.openDialog();
            }
        });
        mAboutKidozButton.setId(Utils.generateViewId());
        mAboutKidozButton.setRoundedCornerDirection(PanelButton.RoundedCornerDirection.RIGHT);
        LayoutParams params = new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        mInnerContainer.addView(mAboutKidozButton, params);

    }

    private void initShadowLineView()
    {
        mShadowView = new View(getContext());
        mShadowView.setAlpha(0.8f);
        LayoutParams params = new LayoutParams(LayoutParams.MATCH_PARENT, Utils.dpTOpx(getContext(), DEFAULT_SHADOW_LINE_SIZE));
        mContainer.addView(mShadowView, params);
    }

    private void createShadowLineBg()
    {
        int[] colors = new int[2];
        colors[0] = Color.parseColor("#dd000000");
        colors[1] = Color.TRANSPARENT;

        GradientDrawable shadow = null;

        switch (mPanelType)
        {
            case BOTTOM:
            {
                shadow = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, colors);
                break;
            }
            case TOP:
            {
                shadow = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, colors);
                break;
            }
            case LEFT:
            {
                shadow = new GradientDrawable(GradientDrawable.Orientation.LEFT_RIGHT, colors);
                break;
            }
            case RIGHT:
            {
                shadow = new GradientDrawable(GradientDrawable.Orientation.RIGHT_LEFT, colors);
                break;
            }
        }

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN)
        {
            mShadowView.setBackground(shadow);
        }
        else
        {
            mShadowView.setBackgroundDrawable(shadow);
        }
    }

    private void initOneItemView()
    {
        mOneItemView = new OneItemView(getContext());
        mOneItemView.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mInnerContainer.addView(mOneItemView, params);

        mOneItemView.setViewPagerItemClickListener(new ItemViewPagerAdapter.ViewPagerItemClickListener()
        {
            @Override
            public void onClickEnd(ContentItem contentItem, int position)
            {
                if (contentItem.isPromoted() && mAllowClickHandle)
                {
                    ContentExecutionHandler.handleContentItemClick(getContext(), contentItem, WidgetType.WIDGET_TYPE_FAMILY_PANEL, position, true, true);
                    mAllowClickHandle = false;

                    getMyHandlerInstance().removeCallbacksAndMessages(null);
                    getMyHandlerInstance().postDelayed(new Runnable()
                    {
                        @Override
                        public void run()
                        {
                            try
                            {
                                mAllowClickHandle = true;
                                EventManager.getInstance(getContext()).clearAllTempStoredEvents();
                            } catch (Exception e)
                            {
                            }
                        }
                    }, 3000);
                }
                else
                {
                    ContentExecutionHandler.handleContentItemClick(getContext(), contentItem, WidgetType.WIDGET_TYPE_FAMILY_PANEL, position, true, false);
                }
            }
        });
    }

    private void preparePanel()
    {
        mIsOpen = true;
        mIsAnimationRunning = true;
        Utils.setOnGlobalLayoutFinishListener(mRootView, new Utils.OnGlobalLayoutFinishedListener()
        {
            @Override
            public void onLayoutFinished()
            {
                GenAnimator.playShrinkAnimation(mHandleButton, 0, null);
                GenAnimator.closePanelView(mContainer, 0, mInnerContainer, mPanelType, new Animator.AnimatorListener()
                {
                    @Override
                    public void onAnimationStart(Animator animation)
                    {
                        GenAnimator.animateHandleClose(mHandleButton, null);
                    }

                    @Override
                    public void onAnimationEnd(Animator animation)
                    {
                        mHandleButton.setPanelButtonState(PanelStyleableButtonView.PANEL_BUTTON_STATE.CLOSED);
                        GenAnimator.playGrowAnimation(mHandleButton, 350, 500, new Animator.AnimatorListener()
                        {
                            @Override
                            public void onAnimationStart(Animator animation)
                            {
                            }

                            @Override
                            public void onAnimationEnd(Animator animation)
                            {
                                mIsOpen = false;
                                mIsAnimationRunning = false;
                            }

                            @Override
                            public void onAnimationCancel(Animator animation)
                            {

                            }

                            @Override
                            public void onAnimationRepeat(Animator animation)
                            {

                            }
                        });
                    }

                    @Override
                    public void onAnimationCancel(Animator animation)
                    {

                    }

                    @Override
                    public void onAnimationRepeat(Animator animation)
                    {

                    }
                });
            }
        });
        applyPanelMainBgColor();
    }

    private void initPanelTypeAndHandlePosition()
    {
        mPanelType = PANEL_TYPE.BOTTOM;
        mHandlePosition = com.kidoz.sdk.api.ui_views.panel_view.HANDLE_POSITION.START;
        if (Build.VERSION.SDK_INT >= 16)
        {
            int gravity = getGravity();
            switch (gravity)
            {
                case Gravity.LEFT:
                {
                    mPanelType = PANEL_TYPE.LEFT;
                    break;
                }
                case Gravity.TOP:
                {
                    mPanelType = PANEL_TYPE.TOP;
                    break;
                }
                case Gravity.RIGHT:
                {
                    mPanelType = PANEL_TYPE.RIGHT;
                    break;
                }
                case Gravity.BOTTOM:
                {
                    mPanelType = PANEL_TYPE.BOTTOM;
                    break;
                }
            }
        }
    }

    private void initPanelViewsRules()
    {
        createShadowLineBg();

        RelativeLayout.LayoutParams containerParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mContainer.setLayoutParams(containerParams);

        RelativeLayout.LayoutParams innerContainerParams = new RelativeLayout.LayoutParams(LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mInnerContainer.setLayoutParams(innerContainerParams);

        RelativeLayout.LayoutParams sliderParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);

        RelativeLayout.LayoutParams bottomBarParams = new RelativeLayout.LayoutParams(LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mBottomBarContainer.setLayoutParams(bottomBarParams);

        RelativeLayout.LayoutParams handleParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mHandleButton.setLayoutParams(handleParams);

        RelativeLayout.LayoutParams customHandleParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mCustomUserHandleButton.setLayoutParams(customHandleParams);

        RelativeLayout.LayoutParams shadowParams = new RelativeLayout.LayoutParams(LayoutParams.MATCH_PARENT, Utils.dpTOpx(getContext(), DEFAULT_SHADOW_LINE_SIZE));
        mShadowView.setLayoutParams(shadowParams);

        RelativeLayout.LayoutParams parentalLockParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mParentalLockButton.setLayoutParams(parentalLockParams);

        RelativeLayout.LayoutParams aboutKidozParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mAboutKidozButton.setLayoutParams(aboutKidozParams);

        int margin = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(getContext(), 6);
        switch (mPanelType)
        {
            case LEFT:
            {
                sliderParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                mOneItemView.setLayoutParams(sliderParams);
                mOneItemView.fixParams(com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE.LEFT);
                innerContainerParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                innerContainerParams.width = LayoutParams.WRAP_CONTENT;
                innerContainerParams.height = LayoutParams.MATCH_PARENT;

                handleParams.addRule(RelativeLayout.RIGHT_OF, mInnerContainer.getId());
                customHandleParams.addRule(RelativeLayout.RIGHT_OF, mInnerContainer.getId());

                aboutKidozParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                parentalLockParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                parentalLockParams.addRule(RelativeLayout.ALIGN_RIGHT, mOneItemView.getId());

                bottomBarParams.width = LayoutParams.WRAP_CONTENT;
                bottomBarParams.height = LayoutParams.WRAP_CONTENT;

                bottomBarParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                bottomBarParams.addRule(RelativeLayout.RIGHT_OF, mAboutKidozButton.getId());
                bottomBarParams.addRule(RelativeLayout.LEFT_OF, mParentalLockButton.getId());

                sliderParams.addRule(RelativeLayout.ABOVE, mBottomBarContainer.getId());

                shadowParams.addRule(RelativeLayout.RIGHT_OF, mInnerContainer.getId());
                shadowParams.width = Utils.dpTOpx(getContext(), DEFAULT_SHADOW_LINE_SIZE);
                shadowParams.height = LayoutParams.MATCH_PARENT;

                mPoweredByTextView.setVisibility(View.INVISIBLE);

                switch (mHandlePosition)
                {
                    case START:
                    {
                        handleParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                        customHandleParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                        handleParams.topMargin = margin;
                        break;
                    }
                    case CENTER:
                    {
                        handleParams.addRule(RelativeLayout.CENTER_VERTICAL);
                        customHandleParams.addRule(RelativeLayout.CENTER_VERTICAL);
                        break;
                    }
                    case END:
                    {
                        handleParams.addRule(RelativeLayout.ALIGN_BOTTOM, mInnerContainer.getId());
                        customHandleParams.addRule(RelativeLayout.ALIGN_BOTTOM, mInnerContainer.getId());
                        handleParams.bottomMargin = margin;
                        break;
                    }
                }
                containerParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                break;
            }
            case TOP:
            {
                sliderParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                mOneItemView.setLayoutParams(sliderParams);
                mOneItemView.fixParams(com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE.TOP);
                innerContainerParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                innerContainerParams.width = LayoutParams.MATCH_PARENT;
                innerContainerParams.height = LayoutParams.WRAP_CONTENT;

                bottomBarParams.addRule(RelativeLayout.BELOW, mOneItemView.getId());
                aboutKidozParams.addRule(RelativeLayout.ALIGN_BOTTOM, mBottomBarContainer.getId());
                parentalLockParams.addRule(RelativeLayout.ALIGN_BOTTOM, mBottomBarContainer.getId());
                parentalLockParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT, mBottomBarContainer.getId());

                bottomBarParams.addRule(RelativeLayout.RIGHT_OF, mAboutKidozButton.getId());
                bottomBarParams.addRule(RelativeLayout.LEFT_OF, mParentalLockButton.getId());

                handleParams.addRule(RelativeLayout.BELOW, mInnerContainer.getId());
                customHandleParams.addRule(RelativeLayout.BELOW, mInnerContainer.getId());

                shadowParams.addRule(RelativeLayout.BELOW, mInnerContainer.getId());
                shadowParams.width = LayoutParams.MATCH_PARENT;
                shadowParams.height = Utils.dpTOpx(getContext(), DEFAULT_SHADOW_LINE_SIZE);

                mPoweredByTextView.setVisibility(View.VISIBLE);

                switch (mHandlePosition)
                {
                    case START:
                    {
                        handleParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                        customHandleParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                        handleParams.leftMargin = margin;
                        break;
                    }
                    case CENTER:
                    {
                        handleParams.addRule(RelativeLayout.CENTER_HORIZONTAL);
                        customHandleParams.addRule(RelativeLayout.CENTER_HORIZONTAL);
                        break;
                    }
                    case END:
                    {
                        handleParams.addRule(RelativeLayout.ALIGN_RIGHT, mInnerContainer.getId());
                        customHandleParams.addRule(RelativeLayout.ALIGN_RIGHT, mInnerContainer.getId());
                        handleParams.rightMargin = margin;
                        break;
                    }
                }

                containerParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                break;
            }
            case RIGHT:
            {
                sliderParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                mOneItemView.setLayoutParams(sliderParams);
                mOneItemView.fixParams(com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE.RIGHT);
                innerContainerParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                innerContainerParams.width = LayoutParams.WRAP_CONTENT;
                innerContainerParams.height = LayoutParams.MATCH_PARENT;

                aboutKidozParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                parentalLockParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                parentalLockParams.addRule(RelativeLayout.ALIGN_RIGHT, mOneItemView.getId());

                bottomBarParams.width = LayoutParams.WRAP_CONTENT;
                bottomBarParams.height = LayoutParams.WRAP_CONTENT;

                bottomBarParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                bottomBarParams.addRule(RelativeLayout.RIGHT_OF, mAboutKidozButton.getId());
                bottomBarParams.addRule(RelativeLayout.LEFT_OF, mParentalLockButton.getId());

                sliderParams.addRule(RelativeLayout.ABOVE, mBottomBarContainer.getId());

                shadowParams.addRule(RelativeLayout.LEFT_OF, mInnerContainer.getId());
                shadowParams.width = Utils.dpTOpx(getContext(), DEFAULT_SHADOW_LINE_SIZE);
                shadowParams.height = LayoutParams.MATCH_PARENT;

                handleParams.addRule(RelativeLayout.LEFT_OF, mInnerContainer.getId());
                customHandleParams.addRule(RelativeLayout.LEFT_OF, mInnerContainer.getId());

                mPoweredByTextView.setVisibility(View.INVISIBLE);

                switch (mHandlePosition)
                {
                    case START:
                    {
                        handleParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                        customHandleParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                        handleParams.topMargin = margin;
                        break;
                    }
                    case CENTER:
                    {
                        handleParams.addRule(RelativeLayout.CENTER_VERTICAL);
                        customHandleParams.addRule(RelativeLayout.CENTER_VERTICAL);
                        break;
                    }
                    case END:
                    {
                        handleParams.addRule(RelativeLayout.ALIGN_BOTTOM, mInnerContainer.getId());
                        customHandleParams.addRule(RelativeLayout.ALIGN_BOTTOM, mInnerContainer.getId());
                        handleParams.bottomMargin = margin;
                        break;
                    }
                }

                containerParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                break;
            }
            case BOTTOM:
            {
                sliderParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                mOneItemView.setLayoutParams(sliderParams);
                mOneItemView.fixParams(com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE.BOTTOM);
                innerContainerParams.addRule(RelativeLayout.BELOW, mHandleButton.getId());
                innerContainerParams.width = LayoutParams.MATCH_PARENT;
                innerContainerParams.height = LayoutParams.WRAP_CONTENT;

                //handleParams.addRule(RelativeLayout.ABOVE);
                customHandleParams.addRule(RelativeLayout.ALIGN_BOTTOM, mHandleButton.getId());

                shadowParams.addRule(RelativeLayout.ABOVE, mInnerContainer.getId());
                shadowParams.width = LayoutParams.MATCH_PARENT;
                shadowParams.height = Utils.dpTOpx(getContext(), DEFAULT_SHADOW_LINE_SIZE);

                bottomBarParams.addRule(RelativeLayout.BELOW, mOneItemView.getId());
                bottomBarParams.addRule(RelativeLayout.RIGHT_OF, mAboutKidozButton.getId());
                bottomBarParams.addRule(RelativeLayout.LEFT_OF, mParentalLockButton.getId());

                aboutKidozParams.addRule(RelativeLayout.ALIGN_BOTTOM, mBottomBarContainer.getId());
                parentalLockParams.addRule(RelativeLayout.ALIGN_BOTTOM, mBottomBarContainer.getId());
                parentalLockParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);

                mPoweredByTextView.setVisibility(View.VISIBLE);

                switch (mHandlePosition)
                {
                    case START:
                    {
                        handleParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                        customHandleParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                        handleParams.leftMargin = margin;
                        break;
                    }
                    case CENTER:
                    {
                        handleParams.addRule(RelativeLayout.CENTER_HORIZONTAL);
                        customHandleParams.addRule(RelativeLayout.CENTER_HORIZONTAL);
                        break;
                    }
                    case END:
                    {
                        handleParams.addRule(RelativeLayout.ALIGN_RIGHT, mInnerContainer.getId());
                        customHandleParams.addRule(RelativeLayout.ALIGN_RIGHT, mInnerContainer.getId());
                        handleParams.rightMargin = margin;
                        break;
                    }
                }

                containerParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                break;
            }

        }
    }

    private void initContentLogicLoader()
    {
        mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback()
        {
            @Override
            public void onDataReady(ContentData contentData)
            {
                if (contentData != null)
                {
                    mOneItemView.setContent(contentData.getContentDataItems(), mPanelType);
                }
            }
        });
    }

    private void toggleAnimation()
    {
        if (mIsOpen == true)
        {
            collapsePanelView();
        }
        else
        {
            applyPanelMainBgColor();
            expandPanelView();
        }
    }

    /**
     * Collapse panel view
     */
    public void collapsePanelView()
    {
        if (mIsAnimationRunning == false && mIsOpen == true)
        {
            GenAnimator.closePanelView(mContainer, 200, mInnerContainer, mPanelType, new Animator.AnimatorListener()
            {
                @Override
                public void onAnimationStart(Animator animation)
                {
                    if (mIsCustomHandleSet == false)
                    {
                        GenAnimator.animateHandleClose(mHandleButton, null);
                    }
                }

                @Override
                public void onAnimationEnd(Animator animation)
                {
                    mShadowView.setVisibility(View.INVISIBLE);
                    if (mIsCustomHandleSet == false)
                    {
                        mHandleButton.setPanelButtonState(PanelStyleableButtonView.PANEL_BUTTON_STATE.CLOSED);
                    }
                    mIsOpen = false;
                    mIsAnimationRunning = false;
                    if (mIOnPanelViewEventListener != null)
                    {
                        mIOnPanelViewEventListener.onPanelViewCollapsed();
                    }
                }

                @Override
                public void onAnimationCancel(Animator animation)
                {

                }

                @Override
                public void onAnimationRepeat(Animator animation)
                {

                }
            });
        }
    }

    /**
     * Expand (Open) Panel view
     */
    public void expandPanelView()
    {
        if (mIsAnimationRunning == false && mIsOpen == false)
        {
            // Send log
            EventManager.getInstance(getContext()).logEvent(getContext(), WidgetType.WIDGET_TYPE_FAMILY_PANEL, EventManager.LOG_CRITICAL_LEVEL, EventParameters.CATEGORY_SPONSORED_CONTENT, EventParameters.ACTION_WIDGET_VIEW, EventParameters.PANEL_VIEW, false);

            //Refresh the parental lock icon
            boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
            mParentalLockButton.setIsLockActive(isLockActive);

            GenAnimator.openPanelView(mContainer, mContainer, mPanelType, new Animator.AnimatorListener()
            {
                @Override
                public void onAnimationStart(Animator animation)
                {
                    mShadowView.setVisibility(View.VISIBLE);
                    if (mIsCustomHandleSet == false)
                    {
                        GenAnimator.animateHandleOpen(mHandleButton, null);
                    }

                    mContentLogicLoader.loadContent(getContext(), WidgetType.WIDGET_TYPE_FAMILY_PANEL);
                }

                @Override
                public void onAnimationEnd(Animator animation)
                {
                    if (mIsCustomHandleSet == false)
                    {
                        mHandleButton.setPanelButtonState(PanelStyleableButtonView.PANEL_BUTTON_STATE.OPENED);
                    }
                    mIsOpen = true;
                    mIsAnimationRunning = false;

                    if (mIOnPanelViewEventListener != null)
                    {
                        mIOnPanelViewEventListener.onPanelViewExpanded();
                    }
                }

                @Override
                public void onAnimationCancel(Animator animation)
                {

                }

                @Override
                public void onAnimationRepeat(Animator animation)
                {

                }
            });
        }
    }

    /**
     * Set panel view configuration
     *
     * @param panelType      panel view type (Possible values <code> PANEL_TYPE.TOP, PANEL_TYPE.BOTTOM, PANEL_TYPE.LEFT ,PANEL_TYPE.RIGHT </code>
     * @param handlePosition handle position  (Possible values <code> HANDLE_POSITION.START, HANDLE_POSITION.CENTER, HANDLE_POSITION.END </code>
     */
    public void setPanelConfiguration(PANEL_TYPE panelType, com.kidoz.sdk.api.ui_views.panel_view.HANDLE_POSITION handlePosition)
    {
        setPanelConfiguration(panelType, handlePosition, null);
    }

    /**
     * Set panel view configuration
     *
     * @param panelType      panel view type (Possible values <code> PANEL_TYPE.TOP, PANEL_TYPE.BOTTOM, PANEL_TYPE.LEFT ,PANEL_TYPE.RIGHT </code>
     * @param handlePosition handle position  (Possible values <code> HANDLE_POSITION.START, HANDLE_POSITION.CENTER, HANDLE_POSITION.END </code>
     * @param customHandle   user defined custom handle iew
     */
    public void setPanelConfiguration(PANEL_TYPE panelType, com.kidoz.sdk.api.ui_views.panel_view.HANDLE_POSITION handlePosition, View customHandle)
    {
        mPanelType = panelType;
        mHandlePosition = handlePosition;
        mHandleButton.setPanelType(mPanelType);
        mParentalLockButton.setPanelType(PANEL_TYPE.BOTTOM);
        mAboutKidozButton.setPanelType(PANEL_TYPE.BOTTOM);
        if (customHandle != null)
        {
            LayoutParams relLayParams = new LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            mCustomUserHandleButton.setVisibility(View.VISIBLE);
            mCustomUserHandleButton.addView(customHandle, relLayParams);
            mIsCustomHandleSet = true;
            mHandleButton.setVisibility(View.INVISIBLE);
        }
        else
        {
            mCustomUserHandleButton.removeAllViews();
            mCustomUserHandleButton.setVisibility(View.GONE);
            mIsCustomHandleSet = false;
            mHandleButton.setVisibility(View.VISIBLE);
        }

        initPanelViewsRules();
    }

    /**
     * Set panel events listener
     *
     * @param iOnPanelViewEventListener listener
     */
    public void setOnPanelViewEventListener(IOnPanelViewEventListener iOnPanelViewEventListener)
    {
        mIOnPanelViewEventListener = iOnPanelViewEventListener;
    }

    /**
     * Get panel view state
     *
     * @return is panel expanded pr closed
     */
    public boolean getIsPanelViewExpanded()
    {
        return mIsOpen;
    }

    @Override
    protected void onAttachedToWindow()
    {
        super.onAttachedToWindow();

        if (!isInEditMode())
        {
            EventManager.getInstance(getContext()).logEvent(getContext(), WidgetType.WIDGET_TYPE_FAMILY_PANEL, EventManager.LOG_CRITICAL_LEVEL, EventParameters.CATEGORY_SDK, EventParameters.ACTION_BUTTON_VIEW, EventParameters.LABEL_PANEL_BUTTON_VIEW, false);
            EventManager.getInstance(getContext()).startEventsSync(getContext(), 1500);
        }
    }

    @Override
    protected void onDetachedFromWindow()
    {
        super.onDetachedFromWindow();
        getUiHandlerInstance().removeCallbacksAndMessages(null);
    }

    @Override
    protected void onWindowVisibilityChanged(int visibility)
    {
        super.onWindowVisibilityChanged(visibility);

        getMyHandlerInstance().removeCallbacksAndMessages(null);

        if (visibility == View.VISIBLE)
        {
            mAllowClickHandle = true;
        }
        else if (visibility == View.GONE || visibility == View.INVISIBLE)
        {
            if (EventManager.getInstance(getContext()).logAllTempStoredEvents(getContext()))
            {
                EventManager.getInstance(getContext()).startEventsSync(getContext(), 1000);
            }
            mAllowClickHandle = true;
        }
    }

    /**
     * Load Panel button style view define on server
     */
    private void loadButtonStyleView()
    {
        PropertiesObj appConfig = DatabaseManager.getInstance(getContext()).getConfigTable().loadAppProperties();
        if (appConfig != null)
        {
            if (mHandleButton != null && mIsCustomHandleSet == false)
            {
                mHandleButton.loadPanelButtonStyle(appConfig.getPanelButtonUrl(), new DefaultPanelDrawable(getContext(), mPanelType, DefaultPanelDrawable.PanelDrawableType.CLOSED_VIEW), appConfig.getPanelButtonCloseUrl(), new DefaultPanelDrawable(getContext(), mPanelType, DefaultPanelDrawable.PanelDrawableType.OPENED_VIEW));
            }
        }
        else
        {
            if (mNotReadyRepeatCount < BUTTON_STYLE_RESOURCE_NOT_READY_REPEAT_COUNT && mIsCustomHandleSet == false)
            {
                getUiHandlerInstance().postDelayed(new Runnable()
                {
                    @Override
                    public void run()
                    {
                        mNotReadyRepeatCount++;
                        loadButtonStyleView();
                    }
                }, 1200);
            }
        }
    }

    private void applyPanelMainBgColor()
    {

        if (mPanelBgColor == Color.WHITE)
        {
            PropertiesObj appConfig = DatabaseManager.getInstance(getContext()).getConfigTable().loadAppProperties();
            if (appConfig != null)
            {
                if (appConfig.getPanelBackGroundColor() != null)
                {
                    try
                    {
                        mPanelBgColor = Color.parseColor(appConfig.getPanelBackGroundColor());
                    } catch (Exception e)
                    {
                    }
                }

            }
        }

        setPanelColor(mPanelBgColor);
    }


    /**
     * Set panel color
     *
     * @param color
     */
    public void setPanelColor(int color)
    {
        mPanelBgColor = color;

        if (mParentalLockButton != null)
        {
            mParentalLockButton.setBaseColor(mPanelBgColor);
        }

        if (mAboutKidozButton != null)
        {
            mAboutKidozButton.setBaseColor(mPanelBgColor);
        }

        if (mBottomBarContainer != null)
        {
            mBottomBarContainer.setBackgroundColor(mPanelBgColor);
        }

        if (mInnerContainer != null)
        {
            mInnerContainer.setBackgroundColor(mPanelBgColor);
        }

        if (mHandleButton != null && mIsCustomHandleSet == false)
        {
            mHandleButton.setBaseColor(mPanelBgColor);
        }
    }

    /**
     * Get handler instance
     */
    private Utils.StaticHandler getMyHandlerInstance()
    {
        if (mStaticHandler == null)
        {
            mStaticHandler = new Utils.StaticHandler(Looper.getMainLooper())
            {
                @Override
                public void handleMessage(Message message)
                {
                    // This is where you do your work in the UI thread.
                    // Your worker tells you in the message what to do.
                }
            };
        }
        return mStaticHandler;
    }

    /**
     * Get handler instance
     */
    private Utils.StaticHandler getUiHandlerInstance()
    {
        if (mUiLoaderStaticHandler == null)
        {
            mUiLoaderStaticHandler = new Utils.StaticHandler(Looper.getMainLooper())
            {
                @Override
                public void handleMessage(Message message)
                {
                    // This is where you do your work in the UI thread.
                    // Your worker tells you in the message what to do.
                }
            };
        }
        return mUiLoaderStaticHandler;
    }
}
