package com.kidoz.events;

import android.content.Context;
import android.os.AsyncTask;

import com.kidoz.sdk.api.server_connect.ResultData;
import com.kidoz.sdk.api.server_connect.SdkAPIManager;


public class EventSyncAsyncTask extends AsyncTask<Void, Void, Void> {

    private static final String TAG = EventSyncAsyncTask.class.getSimpleName();

    private static final int MAX_ITERATION_TIMES_IN_SINGLE_SYNC = 3;
    private Context mContext;

    public EventSyncAsyncTask(Context context) {
        mContext = context;
    }

    @Override
    protected Void doInBackground(Void... params) {

        com.kidoz.sdk.api.general.utils.SDKLogger.printWarningLog(" ----------------------  ********************* ----------------------");
        com.kidoz.sdk.api.general.utils.SDKLogger.printWarningLog(" -----------------    START EVENTS SYNCING THREAD ---------------------");
        com.kidoz.sdk.api.general.utils.SDKLogger.printWarningLog(" ----------------------  ******************** ----------------------");

        try {
            int iterCount = MAX_ITERATION_TIMES_IN_SINGLE_SYNC;

            if (mContext != null) {
                while (EventManager.getInstance(mContext).getIsNeedEventsSync(mContext) && iterCount > 0)
                {
                    iterCount--;
                    EventBulk bulk = EventManager.getInstance(mContext).getNextBulk(mContext);
                    if (bulk != null)
                    {
                        String json = bulk.toString();
                        com.kidoz.sdk.api.general.utils.SDKLogger.printInfoLog("Log Events Sync info : bulk value:" + json);
                        if (json != null)
                        {
                            ResultData<Boolean> resultCallback =  SdkAPIManager.getSdkApiInstance(mContext).sendKidozEventsToServerNotAsync(json);
                            if (resultCallback != null && resultCallback.getResponseStatus().getIsSuccessful())
                            {
                                EventManager.getInstance(mContext).removeBulkFromDB(mContext, bulk);

                            }
                            else
                            {
                                com.kidoz.sdk.api.general.utils.SDKLogger.printInfoLog(TAG, "Log Events Sync Info : Server response failed ! Trying again...");
                            }
                        }
                        else
                        {
                            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Log Events Sync Error : Couldn't create JSON representation of an Events BULK !");
                            break;
                        }
                    }
                    else
                    {
                        com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Log Events Sync Error : Events BULK object is NULL !");
                        break;
                    }
                }
            }
        } catch (Exception e) {}
        return null;
    }
}
