package com.kidoz.sdk.api.ui_views;

import android.animation.Animator;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Color;
import android.view.View;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.utils.SdkAnimationsUtils;

/**
 * Created by roni on 8/26/2015.
 */
public class OnBoardingView extends RelativeLayout
{
    public static final String ON_BOARDING_SHARED_PREFERENCES_KEY = "ON_BOARDING_SHARED_PREFERENCES_KEY";
    private final long ON_BOARDING_ENTER_DELAY_ANIMATION = 500;
    private final long ON_BOARDING_EXIT_DELAY_ANIMATION = 2200;
    private final long FADE_IN_ANIMATION_DURATION = 1000;
    private final long FADE_OUT_ANIMATION_DURATION = 700;

    private View mBackgroundView;
    private OnBoardingCloud mOnBoardingCloud;
    private OnBoardingCloudInterface mOnBoardingCloudInterface;

    public OnBoardingView(Context context)
    {
        super(context);
        initView();
    }

    private void initView()
    {
        initBackgroundView();
        initOnBoardingCloud();
    }

    private void initBackgroundView()
    {
        mBackgroundView = new View(getContext());
        mBackgroundView.setBackgroundColor(Color.parseColor("#5004a0e1"));
        mBackgroundView.setClickable(true);
        mBackgroundView.setVisibility(View.INVISIBLE);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
        addView(mBackgroundView, params);
    }

    private void initOnBoardingCloud()
    {
        mOnBoardingCloud = new OnBoardingCloud(getContext());
        mOnBoardingCloud.setVisibility(View.INVISIBLE);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        params.addRule(RelativeLayout.CENTER_IN_PARENT);
        addView(mOnBoardingCloud, params);
    }

    public void animateView(final OnBoardingCloudInterface onBoardingCloudInterface)
    {
        mOnBoardingCloudInterface = onBoardingCloudInterface;
        postDelayed(new Runnable()
        {
            @Override public void run()
            {
                SdkAnimationsUtils.animateFade(mBackgroundView, true, FADE_IN_ANIMATION_DURATION, new Animator.AnimatorListener() {
                    @Override
                    public void onAnimationStart(Animator animation) {
                        mBackgroundView.setVisibility(View.VISIBLE);
                    }

                    @Override
                    public void onAnimationEnd(Animator animation) {

                    }

                    @Override
                    public void onAnimationCancel(Animator animation) {

                    }

                    @Override
                    public void onAnimationRepeat(Animator animation) {

                    }
                });

                GenAnimator.playOnBoardingCloudDropAnimation(mOnBoardingCloud, new Animator.AnimatorListener()
                {
                    @Override public void onAnimationStart(Animator animation)
                    {
                        mOnBoardingCloud.setVisibility(View.VISIBLE);
                    }

                    @Override public void onAnimationEnd(Animator animation)
                    {
                        OnBoardingView.this.postDelayed(new Runnable()
                        {
                            @Override public void run()
                            {
                                SdkAnimationsUtils.animateFade(mBackgroundView, false, FADE_OUT_ANIMATION_DURATION, new Animator.AnimatorListener() {
                                    @Override
                                    public void onAnimationStart(Animator animation) {
                                    }

                                    @Override
                                    public void onAnimationEnd(Animator animation) {
                                        mBackgroundView.setVisibility(View.GONE);
                                        if (mOnBoardingCloudInterface != null) {
                                            mOnBoardingCloudInterface.onFinished();
                                        }
                                    }

                                    @Override
                                    public void onAnimationCancel(Animator animation) {
                                        mBackgroundView.setVisibility(View.GONE);
                                        if (mOnBoardingCloudInterface != null) {
                                            mOnBoardingCloudInterface.onFinished();
                                        }
                                    }

                                    @Override
                                    public void onAnimationRepeat(Animator animation) {

                                    }
                                });

                                GenAnimator.playPopOutAnimation(mOnBoardingCloud, new Animator.AnimatorListener()
                                {
                                    @Override public void onAnimationStart(Animator animation)
                                    {
                                    }

                                    @Override public void onAnimationEnd(Animator animation)
                                    {
                                        mOnBoardingCloud.setVisibility(View.GONE);
                                    }

                                    @Override public void onAnimationCancel(Animator animation)
                                    {
                                    }

                                    @Override public void onAnimationRepeat(Animator animation)
                                    {
                                    }
                                });
                            }
                        }, ON_BOARDING_EXIT_DELAY_ANIMATION);
                    }

                    @Override public void onAnimationCancel(Animator animation)
                    {

                    }

                    @Override public void onAnimationRepeat(Animator animation)
                    {

                    }
                });
            }
        }, ON_BOARDING_ENTER_DELAY_ANIMATION);
    }

    public interface OnBoardingCloudInterface
    {
        void onFinished();
    }

    @Override protected void onConfigurationChanged(Configuration newConfig)
    {
        super.onConfigurationChanged(newConfig);
    }
}
