package com.kidoz.sdk.api.players.video_player;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.view.View;
import android.webkit.WebSettings;

import com.kidoz.sdk.api.dialogs.WebDialog.VideoEnabledWebChromeClient;
import com.kidoz.sdk.api.dialogs.WebDialog.VideoEnabledWebView;

import java.io.File;

/**
 * Created by roni on 11/8/2015.
 */
public class VideoManager
{
    private static VideoManager sVideoManager = null;
    private VideoEnabledWebView mIFrameVideo;
    private VideoJavaScriptInterface mVideoJavaScriptInterface;

    protected VideoManager()
    {
    }

    private void initIFrameVideo(Context context)
    {
        mIFrameVideo = new VideoEnabledWebView(context);
        mIFrameVideo.setVerticalScrollBarEnabled(false);
        mIFrameVideo.setHorizontalScrollBarEnabled(false);
        if (Build.VERSION.SDK_INT < 18)
        {
            mIFrameVideo.getSettings().setAppCacheMaxSize(Long.MAX_VALUE);
        }
        if (Build.VERSION.SDK_INT > 16)
        {
            mIFrameVideo.getSettings().setMediaPlaybackRequiresUserGesture(false);
        }
        if (Build.VERSION.SDK_INT >= 11)
        {
            mIFrameVideo.setLayerType(View.LAYER_TYPE_HARDWARE, null);
        }

        String state = Environment.getExternalStorageState();
        if (Environment.MEDIA_MOUNTED.equals(state)) {
            File path = context.getCacheDir();
            if(path != null) {
                mIFrameVideo.getSettings().setAppCachePath(path.toString() + "/VideoCache");
            }
        }

        mIFrameVideo.getSettings().setPluginState(WebSettings.PluginState.ON);
        mIFrameVideo.getSettings().setCacheMode(WebSettings.LOAD_DEFAULT);
        mIFrameVideo.getSettings().setLoadWithOverviewMode(true);
        mIFrameVideo.getSettings().setJavaScriptEnabled(true);
        mIFrameVideo.getSettings().setUseWideViewPort(true);
        mIFrameVideo.getSettings().setAppCacheEnabled(true);
        mIFrameVideo.getSettings().setSupportZoom(false);


        mIFrameVideo.setWebChromeClient(new VideoEnabledWebChromeClient());

        mVideoJavaScriptInterface = new VideoJavaScriptInterface();
        mIFrameVideo.addJavascriptInterface(mVideoJavaScriptInterface, "VideoJavaScriptInterface");
        mIFrameVideo.loadUrl("http://d28lrrc51wcjkk.cloudfront.net/video_player/video_player_sdk.html");

    }

    public static VideoManager getInstance(Context context)
    {
        if (sVideoManager == null)
        {
            sVideoManager = new VideoManager();
            sVideoManager.initIFrameVideo(context);
        }

        return sVideoManager;
    }

    public VideoEnabledWebView getIFrameVideo()
    {
        return mIFrameVideo;
    }

    public VideoJavaScriptInterface getVideoJavaScriptInterface()
    {
        return mVideoJavaScriptInterface;
    }
}
