package com.kidoz.sdk.api.players.video_player;

/**
 * Created by roni on 11/10/2015.
 */
public class VideoJavaScriptInterface
{
    private JavascriptListener mJavascriptListener;

    public void setJavascriptListener(JavascriptListener javascriptListener)
    {
        mJavascriptListener = javascriptListener;
    }

    @android.webkit.JavascriptInterface public void onVideoReady()
    {
        mJavascriptListener.onVideoReady();
    }

    @android.webkit.JavascriptInterface public void onError(final int errorCode)
    {
        mJavascriptListener.onError(errorCode);
    }

    @android.webkit.JavascriptInterface public void onStateChange(final int state)
    {
        mJavascriptListener.onStateChange(state);
    }

    @android.webkit.JavascriptInterface public void setVideoCurrentTime(final int currentTimeInSeconds)
    {

    }

    @android.webkit.JavascriptInterface public void setVideoTotalTime(final int totalTimeInSeconds)
    {

    }

    @android.webkit.JavascriptInterface public void onQualityChanged(final String quality)
    {
    }

    public interface JavascriptListener
    {
        public void onVideoReady();

        public void onError(final int errorCode);

        public void onStateChange(final int state);
    }
}
