package com.kidoz.sdk.api.general.database;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;

import com.kidoz.sdk.api.structure.IsEventRecord;

/**
 * Created by roni on 9/20/2015.
 */
public class IsEventTable extends BaseTable {
    private final String TAG = IsEventTable.class.getName();

    private static final String TABLE_NAME = "IsEventTable";

    private static final String COLUMN_APP_ID = "COLUMN_APP_ID";
    private static final String COLUMN_TIMESTAMP = "COLUMN_TIMESTAMP";
    private static final String COLUMN_ITEM_TYPE = "COLUMN_ITEM_TYPE";
    private static final String COLUMN_POSITION_INDEX = "COLUMN_POSITION_INDEX";
    private static final String COLUMN_APP_NAME = "COLUMN_APP_NAME";
    private static final String COLUMN_ADVERTISING_ID = "COLUMN_ADVERTISING_ID";

    public IsEventTable(DatabaseManager databaseManager, Object syncObject) {
        super(databaseManager, syncObject);
    }

    public static synchronized void onCreate(SQLiteDatabase database) {
        if (database != null) {
            String CREATE_TABLE_STATEMENT = "CREATE TABLE " + TABLE_NAME
                    + "(" + COLUMN_APP_ID + " TEXT PRIMARY KEY,"
                    + COLUMN_TIMESTAMP + " TEXT,"
                    + COLUMN_ITEM_TYPE + " TEXT,"
                    + COLUMN_POSITION_INDEX + " INTEGER,"
                    + COLUMN_APP_NAME + " TEXT,"
                    + COLUMN_ADVERTISING_ID + " TEXT)";
            database.execSQL(CREATE_TABLE_STATEMENT);
        }
    }

    public static synchronized void onUpgrade(SQLiteDatabase database, int oldVersion, int newVersion) {
        if (database != null && newVersion > oldVersion) {

        }
    }

    /**
     * Insert SDK click download application record
     *
     * @param record sdk record
     */
    public synchronized void insertRecord(IsEventRecord record) {
        if (mDBmanager != null && record != null) {
            synchronized (mSyncObject) {
                int rowsCount = 0;
                int rowID = -1;

                SQLiteDatabase database = mDBmanager.openDatabase();
                try {
                    database.beginTransaction();
                    ContentValues values = new ContentValues();
                    values.put(IsEventTable.COLUMN_APP_ID, record.getPackageName());
                    values.put(IsEventTable.COLUMN_TIMESTAMP, record.getTimeStamp());
                    values.put(IsEventTable.COLUMN_ITEM_TYPE, record.getContentType());
                    values.put(IsEventTable.COLUMN_POSITION_INDEX, record.getPositionIndex());
                    values.put(IsEventTable.COLUMN_APP_NAME, record.getName());
                    values.put(IsEventTable.COLUMN_ADVERTISING_ID, record.getAdvertiserId());

                    rowID = (int) database.insertWithOnConflict(TABLE_NAME, null, values, SQLiteDatabase.CONFLICT_REPLACE);
                    if (rowID != -1) {
                        rowsCount++;
                    }

                    database.setTransactionSuccessful();
                } catch (Exception ex) {
                    com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to insert sdk record data: " + ex.getMessage());
                } finally {
                    database.endTransaction();
                    mDBmanager.closeDatabase();
                }
                printDBLog(DBactionType.INSERT, "insertRecord", TABLE_NAME, rowsCount);
            }
        }
    }

    /**
     * Get SDK click download application record
     *
     * @param packageName
     */
    public synchronized IsEventRecord getRecord(String packageName) {
        IsEventRecord record = null;
        if (mDBmanager != null) {
            synchronized (mSyncObject) {
                int rowsCount = 0;
                SQLiteDatabase database = mDBmanager.openDatabase();
                try {
                    String selection = null;
                    String[] selectionArgs = null;
                    if (packageName != null) {
                        selection = IsEventTable.COLUMN_APP_ID + "=?";
                        selectionArgs = new String[]{packageName};
                    }
                    Cursor cursor = database.query(TABLE_NAME, null, selection, selectionArgs, null, null, null);
                    if (cursor != null && cursor.getCount() > 0) {
                        rowsCount = cursor.getCount();
                        cursor.moveToFirst();

                        record = new IsEventRecord();
                        record.setPackageName(cursor.getString(cursor.getColumnIndex(IsEventTable.COLUMN_APP_ID)));
                        record.setTimeStamp(cursor.getString(cursor.getColumnIndex(IsEventTable.COLUMN_TIMESTAMP)));
                        record.setContentType(cursor.getString(cursor.getColumnIndex(IsEventTable.COLUMN_ITEM_TYPE)));
                        record.setPositionIndex(cursor.getInt(cursor.getColumnIndex(IsEventTable.COLUMN_POSITION_INDEX)));
                        record.setName(cursor.getString(cursor.getColumnIndex(IsEventTable.COLUMN_APP_NAME)));
                        record.setAdvertiserId(cursor.getString(cursor.getColumnIndex(IsEventTable.COLUMN_ADVERTISING_ID)));

                        while (cursor.moveToNext()) ;
                    }
                    if (cursor != null) {
                        cursor.close();
                    }
                } catch (Exception e) {
                    com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to load install record: " + e.getMessage());
                } finally {
                    mDBmanager.closeDatabase();
                }
                printDBLog(DBactionType.LOAD, "load sdk record", TABLE_NAME, rowsCount);
            }
        }
        return record;
    }

    /**
     * Delete SDK click download application record
     *
     * @param packageName
     */
    public synchronized void deleteRecord(String packageName) {
        if (mDBmanager != null) {

            synchronized (mSyncObject) {
                int rowsCount = 0;
                int rowID = -1;

                if (packageName == null) {
                    clearTable(TABLE_NAME);
                } else {

                    SQLiteDatabase database = mDBmanager.openDatabase();
                    try {
                        database.beginTransaction();
                        String selection = IsEventTable.COLUMN_APP_ID + "=?";
                        String[] selectionArgs = new String[]{packageName};
                        rowID = database.delete(TABLE_NAME, selection, selectionArgs);
                        if (rowID != -1) {
                            rowsCount = rowID;
                        }
                        database.setTransactionSuccessful();
                        database.endTransaction();
                    } catch (Exception e) {
                        com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to delete sdk record: " + e.getMessage());
                    } finally {
                        mDBmanager.closeDatabase();
                    }
                    printDBLog(DBactionType.DELETE, "Delete Install App sdk record", TABLE_NAME, rowsCount);
                }
            }
        }
    }
}