package com.kidoz.sdk.api.ui_views.panel_view;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.widget.RelativeLayout;


import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.structure.ContentItem;

import java.util.ArrayList;

/**
 * Created by roni on 10/7/2015.
 */
public class PanelSliderView extends RelativeLayout
{
    private PANEL_TYPE mPanelType;
    private RecyclerView mCustomRecyclerView;
    private PanelAdapter mPanelAdapter;

    public PanelSliderView(Context context)
    {
        super(context);
        initView();
    }

    private void initView()
    {
        initRecyclerView();
    }

    public void initRecyclerView()
    {
        // Create an instance of the recycler view
        mCustomRecyclerView = new RecyclerView(getContext());
        mCustomRecyclerView.setHasFixedSize(true);
      //  mCustomRecyclerView.setItemAnimator(new ItemAnimator());
        mCustomRecyclerView.setClipToPadding(false);

        LinearLayoutManager customLinearLayoutManager = new LinearLayoutManager(getContext(), LinearLayoutManager.HORIZONTAL, false);
        mCustomRecyclerView.setLayoutManager(customLinearLayoutManager);

        // Init the adapter
        mPanelAdapter = new PanelAdapter(getContext());
        mCustomRecyclerView.setAdapter(mPanelAdapter);

        // Add the recycler view to the root layout
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        addView(mCustomRecyclerView, params);
    }

    private void preparePanelSlider()
    {
        // Set the width and height and layout manager orientation
        float SCALE_FACTOR = ScreenUtils.getScaleFactor(getContext());
        int itemWidth = (int) (517f * SCALE_FACTOR);
        int itemHeight = (int) (402f * SCALE_FACTOR);
        int padding = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(getContext(), 3);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        LinearLayoutManager customLinearLayoutManager = new LinearLayoutManager(getContext(), LinearLayoutManager.HORIZONTAL, false);
        switch (mPanelType)
        {
            case LEFT:
            {
                params.width = itemWidth + (padding * 4);
                params.height = LayoutParams.MATCH_PARENT;
                mCustomRecyclerView.setPadding(padding, padding, 0, padding);
                customLinearLayoutManager.setOrientation(LinearLayoutManager.VERTICAL);
                break;
            }
            case TOP:
            {
                params.width = LayoutParams.MATCH_PARENT;
                params.height = itemHeight + (padding * 3);
                mCustomRecyclerView.setPadding(padding, padding, padding, 0);
                customLinearLayoutManager.setOrientation(LinearLayoutManager.HORIZONTAL);
                break;
            }
            case RIGHT:
            {
                params.width = itemWidth + (padding * 4);
                params.height = LayoutParams.MATCH_PARENT;
                mCustomRecyclerView.setPadding(0, padding, padding, padding);
                customLinearLayoutManager.setOrientation(LinearLayoutManager.VERTICAL);
                break;
            }
            case BOTTOM:
            {
                params.width = LayoutParams.MATCH_PARENT;
                params.height = itemHeight + (padding * 3);
                mCustomRecyclerView.setPadding(0, padding, padding, padding);
                customLinearLayoutManager.setOrientation(LinearLayoutManager.HORIZONTAL);
                break;
            }
        }
        mCustomRecyclerView.setLayoutParams(params);
        mCustomRecyclerView.setLayoutManager(customLinearLayoutManager);
    }

    public void setPanelType(PANEL_TYPE panelType)
    {
        mPanelType = panelType;
        preparePanelSlider();
    }

    public void setContent(ArrayList<ContentItem> content)
    {
        mPanelAdapter.setContent(content);
    }

    public void clearContent()
    {
        mPanelAdapter.clearContent();
    }

    public void setPanelViewListener(PanelViewListener panelViewListener)
    {
        mPanelAdapter.setPanelViewListener(panelViewListener);
    }
}
