package com.kidoz.sdk.api.ui_views;

import android.animation.AnimatorSet;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Handler;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.view.Window;
import android.view.animation.AccelerateInterpolator;
import android.widget.RelativeLayout;


import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.assets_handling.SoundAssetsUtils;
import com.kidoz.sdk.api.general.utils.SdkSoundManager;
import com.kidoz.sdk.api.picasso_related.PicassoOk;
import com.kidoz.sdk.api.picasso_related.RoundedTransformation;
import com.kidoz.sdk.api.structure.ContentItem;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;


/**
 * Created by Eugine on 15/07/2015.
 * A Feed panel adapter implementation
 * Support multiple types of layouts
 */
public abstract class ItemsBaseRecycleViewAdapter extends RecyclerView.Adapter<ItemsBaseRecycleViewAdapter.ViewHolder> implements OnClickListener
{
    private final String TAG = ItemsBaseRecycleViewAdapter.class.getSimpleName();
    private final int POP_UP_ANIMATION_DURATION = 350;

    public static final float SECONDARY_THUMB_SIZE_RELATIVE_TO_ITEM_WIDTH_PORTRAIT = 0.24f;
    public static final float SECONDARY_THUMB_SIZE_RELATIVE_TO_ITEM_WIDTH_LANDSCAPE = 0.20f;

    public static final float MAIN_THUMB_DEFAULT_ITEM_HEIGHT_RELATIVE_TO_WIDTH_VERTICAL = 0.5f;
    public static final float HORIZONTAL_TYPE_ITEM_HEIGHT_RATIO = 0.8f;
    public static final float HORIZONTAL_TYPE_ITEM_THUMB_HEIGHT_RATIO = 0.70f;
    protected boolean mIsRegularAnimation;

    protected enum AdapterTypeScroling
    {
        HORIZONTAL, VERTICAL
    }

    private File mSoundFile;

    private ArrayList<ContentItem> mContentArrayList;
    private Context mContext;
    private int mItemWidth;
    private int mItemHeight;
    //    private ArrayList<ContentItem> mImpressionsArrayList;
    private int mContentTypeThubmnailSize;

    private float mFixedItemRation = 0;
    private AdapterTypeScroling mAdapterTypeScroling = AdapterTypeScroling.VERTICAL;

    private ContentPanelView.IOnContentItemClickListener mOnItemClickListener;

    private HashSet<Integer> animationExecutedSet = new HashSet<Integer>();
    private boolean mIsAnimationClick = false;

    private int mCurrentThumbWidth;
    private int mCurrentThumbHeight;
    private int mSpanCount;
    int roundedCorners;
    private int mLastPosition = -1;
    private AccelerateInterpolator mAnimationInterpolator;
    private Handler mHandler;

    private HashMap<String, Integer> mSponsoredContentDisplayed = new HashMap<String, Integer>();

    public class ViewHolder extends RecyclerView.ViewHolder
    {
        private ContentItemView mRootView;
        private AnimatorSet mItemAnimatorSet;

        public ViewHolder(ContentItemView rootView)
        {
            super(rootView);
            mRootView = rootView;
            mRootView.setOnClickListener(ItemsBaseRecycleViewAdapter.this);
            mRootView.setTag(this);
            mRootView.setSoundEffectsEnabled(false);
        }
    }

    public ItemsBaseRecycleViewAdapter(Context context, ArrayList<ContentItem> itemsList, int spanCount, AdapterTypeScroling typeScroling, int itemHeight)
    {
        mSoundFile = SoundAssetsUtils.getSoundAssetFile(context, SoundAssetsUtils.SOUND_ASSET_TYPE.ITEM_CLICK);

        mHandler = new Handler();
        mAnimationInterpolator = new AccelerateInterpolator();
        mContentArrayList = itemsList;
        mContext = context;
        //        mImpressionsArrayList = new ArrayList<ContentItem>();
        mAdapterTypeScroling = typeScroling;
        mItemHeight = itemHeight;
        roundedCorners = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(mContext, ContentItemView.DEFAULT_SHADOW_ELEVATION_RADIUS_DP);
        setSpanCount(spanCount, mContext.getResources().getConfiguration().orientation);
    }

    /**
     * Set current desired adapter span count ,so adapter will correctly render the content items view and its images
     *
     * @param count span count
     */
    public void setSpanCount(int count, int orientation)
    {
        mSpanCount = count;

        Rect rectangle = new Rect();
        if (mContext instanceof Activity && orientation == Configuration.ORIENTATION_LANDSCAPE)
        {
            Window window = ((Activity) mContext).getWindow();
            window.getDecorView().getWindowVisibleDisplayFrame(rectangle);
            mItemWidth = rectangle.width();
        }
        else
        {
            Point point = com.kidoz.sdk.api.general.utils.Utils.getScreenSize(mContext);
            mItemWidth = point.x;
        }

        if (mAdapterTypeScroling == AdapterTypeScroling.VERTICAL)
        {

            mItemWidth = (mItemWidth / count) - (com.kidoz.sdk.api.general.utils.Utils.dpTOpx(mContext, ContentItemView.VIEW_CONTENT_PADDING) * 2 + com.kidoz.sdk.api.general.utils.Utils.dpTOpx(mContext, ContentItemView.CARD_OUTER_MARGIN) * 2);
        }
        else if (mAdapterTypeScroling == AdapterTypeScroling.HORIZONTAL)
        {
            mItemHeight = mItemHeight - ContentItemView.getViewMargin(mContext);
            mItemWidth = (int) (mItemHeight / HORIZONTAL_TYPE_ITEM_HEIGHT_RATIO);
        }



        if (mContext instanceof Activity && orientation == Configuration.ORIENTATION_LANDSCAPE)
        {
            mContentTypeThubmnailSize = (int) (mItemWidth * SECONDARY_THUMB_SIZE_RELATIVE_TO_ITEM_WIDTH_LANDSCAPE);
        }else
        {
            mContentTypeThubmnailSize = (int) (mItemWidth * SECONDARY_THUMB_SIZE_RELATIVE_TO_ITEM_WIDTH_PORTRAIT);
        }
    }

    /**
     * Set fixed item ratio height depending on items width
     *
     * @param ratio ratio
     */
    public void setFixedItemRatio(float ratio)
    {
        mFixedItemRation = ratio;
    }

    /**
     * Set horizintal item height
     *
     * @param height
     */
    public void setHorizontalItemHeight(int height)
    {
        // mHorizontalItemHeight = height;
    }

    @Override public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType)
    {
        // create a new view
        ContentItemView convertView = new ContentItemView(mContext);

        ViewHolder viewHolder = new ViewHolder(convertView);
        return viewHolder;
    }

    // Replace the contents of a view (invoked by the layout manager)
    @Override public void onBindViewHolder(final ViewHolder holder, int position)
    {
        if (holder != null)
        {
            ContentItem contentItem = mContentArrayList.get(position);
            sendImpressionLog(holder, contentItem, position);
            holder.mRootView.getNameTextView().setText(contentItem.getName());

            if (mAdapterTypeScroling == AdapterTypeScroling.HORIZONTAL)
            {
                holder.mRootView.getNameTextView().setLines(1);
            }
            else if (mAdapterTypeScroling == AdapterTypeScroling.VERTICAL)
            {
                holder.mRootView.getNameTextView().setLines(2);
            }

            setCorrectItemSize(holder, contentItem);
            // loadMainThumbnail(holder, contentItem, position);
            loadSecondaryThumbnail(holder, contentItem);

            //            if (contentItem.isPromoted())
            //            {
            //                if (mSponsoredContentDisplayed.containsKey(contentItem.getId()) == false)
            //                {
            //                    mSponsoredContentDisplayed.put(contentItem.getId(), new Integer(position));
            //                    EventManager.getInstance().logSponsoredContentImpressionEvent(
            //                            holder.mRootView.getContext(),
            //                            EventParameters.ACTION_IMPRESSION_VIEWED, contentItem.getName(),
            //                            contentItem.getAdvertiserID(), contentItem.getId(), position);
            //                }
            //            }

            //            if (animationExecutedSet.contains(position) == false)
            //            {
            //                if (holder.mItemAnimatorSet == null)
            //                {
            //                    holder.mItemAnimatorSet = GenAnimator.recycleItemAnimation(holder.mRootView, null);
            //                }
            //                else
            //                {
            //                    holder.mItemAnimatorSet.start();
            //                }
            //                animationExecutedSet.add(position);
            //            }

            if (position > mLastPosition)
            {
                long delay = mIsRegularAnimation == false ? position * POP_UP_ANIMATION_DURATION : 0;
                holder.mRootView.setVisibility(View.INVISIBLE);
                mHandler.postDelayed(new Runnable()
                {
                    @Override public void run()
                    {
                        GenAnimator.recycleItemAnimation(holder.mRootView, new GenAnimator.ViewAnimationListener()
                        {
                            @Override public void onAnimationEnd()
                            {
                            }

                            @Override public void onAnimationStart()
                            {
                                holder.mRootView.setVisibility(View.VISIBLE);
                            }
                        });

                    }
                }, delay);
                mLastPosition = position;
            }
            else
            {
                holder.mRootView.clearAnimation();
                holder.mRootView.setVisibility(View.VISIBLE);
            }
        }
    }

    public void setIsRegularAnimation(boolean isRegularAnimation)
    {
        mIsRegularAnimation = isRegularAnimation;
    }

    private void setCorrectItemSize(final ViewHolder viewHolder, final ContentItem contentItem)
    {
        if (contentItem != null)
        {
            if (mAdapterTypeScroling == AdapterTypeScroling.VERTICAL)
            {
                RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams) viewHolder.mRootView.getMainThumbView().getLayoutParams();
                int itemWidth = mItemWidth;
                int itemHeight;

/*                if (mFixedItemRation == 0)
                {
                    if (contentItem.getMainThumbSize() != null)
                    {
                        itemHeight = (int) (itemWidth * contentItem.getMainThumbImageRatio());
                    } else
                    {
                        itemHeight = (int) (itemWidth * MAIN_THUMB_DEFAULT_ITEM_HEIGHT_RELATIVE_TO_WIDTH_VERTICAL);
                    }
                } else
                {
                    itemHeight = (int) (itemWidth * mFixedItemRation);
                }
*/
                itemHeight = (int) (itemWidth * MAIN_THUMB_DEFAULT_ITEM_HEIGHT_RELATIVE_TO_WIDTH_VERTICAL);

                if (params.height != itemHeight)
                {
                    params.height = itemHeight;
                }

                if (params.width != itemWidth)
                {
                    params.width = itemWidth;
                }

                mCurrentThumbWidth = itemWidth;
                mCurrentThumbHeight = itemHeight;
            }
            else if (mAdapterTypeScroling == AdapterTypeScroling.HORIZONTAL)
            {
                ViewGroup.LayoutParams params = viewHolder.mRootView.getLayoutParams();
                params.height = mItemHeight;
                params.width = mItemWidth;

                // Set thum height
                RelativeLayout.LayoutParams relParams = (RelativeLayout.LayoutParams) viewHolder.mRootView.getMainThumbView().getLayoutParams();
                relParams.height = (int) (mItemHeight * HORIZONTAL_TYPE_ITEM_THUMB_HEIGHT_RATIO);


                /*RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)mMainIconThumb.getLayoutParams();
                params.setMargins(left, top, right,bottom);*/

                mCurrentThumbWidth = mItemWidth;
                mCurrentThumbHeight = relParams.height;
            }

            if (mCurrentThumbWidth > 0 && mCurrentThumbHeight > 0)
            {
                loadMainThumbnail(viewHolder, contentItem, mCurrentThumbWidth, mCurrentThumbHeight);
            }
        }

    }


    /**
     * Loading of main thumbnail image with retain of its correct image ratio
     */
    private void loadMainThumbnail(final ViewHolder viewHolder, final ContentItem contentItem, int widht, int height)
    {
        if (contentItem != null)
        {
            viewHolder.mRootView.getMainThumbView().setImageBitmap(null);
            viewHolder.mRootView.getNameTextView().setTextColor(contentItem.getPaliteTextColor());
            viewHolder.mRootView.setItemBgColor(contentItem.getPaliteBgColor());

            PicassoOk.getPicasso(mContext).load(contentItem.getThumb()).transform(new RoundedTransformation(roundedCorners, 0)).resize(widht, height).centerCrop().into(viewHolder.mRootView.getMainThumbView());

        }
    }

    /**
     * Loading of secondary thumbnail image with proper sizing depending on item width
     */
    private void loadSecondaryThumbnail(ViewHolder viewHolder, final ContentItem contentItem)
    {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams) viewHolder.mRootView.getSecondaryThumbView().getLayoutParams();
        //if (params.width != mContentTypeThubmnailSize)
        // {
        params.height = mContentTypeThubmnailSize;
        params.width = mContentTypeThubmnailSize;
        params.rightMargin = (int) (mContentTypeThubmnailSize * 0.22);
        params.bottomMargin = (int) (mContentTypeThubmnailSize * 0.5) * -1;
        // }
        PicassoOk.getPicasso(mContext).load(contentItem.getSecThumb()).into(viewHolder.mRootView.getSecondaryThumbView());
    }


    /**
     * Set on adapter item click listener
     *
     * @param listener
     */
    public void setOnItemClickListener(ContentPanelView.IOnContentItemClickListener listener)
    {
        mOnItemClickListener = listener;
    }


    /**
     * Add content data (Without refresh)
     *
     * @param items   content data items
     * @param toStart is add to start
     */
    public void setContentData(ArrayList<ContentItem> items, boolean toStart)
    {
        //        mImpressionsArrayList.clear();
        mSponsoredContentDisplayed.clear();
        if (toStart == true)
        {
            animationExecutedSet.clear();
            mContentArrayList.addAll(0, items);
        }
        else
        {
            mContentArrayList.addAll(mContentArrayList.size(), items);
        }
    }

    /**
     * Add content data and resfresh view
     *
     * @param items   content data items
     * @param toStart is add to start
     */
    public void setContentDataWithNotify(ArrayList<ContentItem> items, boolean toStart)
    {
        //        mImpressionsArrayList.clear();
        mSponsoredContentDisplayed.clear();
        if (toStart == true)
        {
            animationExecutedSet.clear();

            mContentArrayList.addAll(0, items);
            notifyItemRangeInserted(0, items.size() - 1);
            notifyItemRangeChanged(0, mContentArrayList.size() - 1);
        }
        else
        {
            int size = mContentArrayList.size();
            mContentArrayList.addAll(items);
            notifyItemRangeInserted(size, mContentArrayList.size());
            notifyItemRangeChanged(0, mContentArrayList.size());
        }
    }

    /**
     * Clear content data and refresh view
     */
    public void clearContentDataWithNotify()
    {
        animationExecutedSet.clear();
        int size = mContentArrayList.size();
        mContentArrayList.clear();
        notifyItemRangeRemoved(0, size);
        notifyItemRangeChanged(0, size);
    }

    /**
     * Is adapter empty
     */
    public boolean isEmpty()
    {
        if (mContentArrayList != null)
        {
            return mContentArrayList.isEmpty();
        }
        else
        {
            return true;
        }
    }

    /**
     * Get adapter data structure
     *
     * @return data content list
     */
    public ArrayList<ContentItem> getData()
    {
        return mContentArrayList;
    }

    // Return the size of your dataset (invoked by the layout manager)
    @Override public int getItemCount()
    {
        return mContentArrayList.size();
    }


    @Override public void onClick(final View view)
    {
        if (mIsAnimationClick == false)
        {
            SdkSoundManager.playSound(view.getContext(), mSoundFile.getAbsolutePath());

            mIsAnimationClick = true;

            GenAnimator.clickItemAnimation(view, 90, new GenAnimator.ViewAnimationListener()
            {
                @Override public void onAnimationEnd()
                {
                    if (mOnItemClickListener != null)
                    {
                        ViewHolder viewHolder = (ViewHolder) view.getTag();
                        if (viewHolder.getAdapterPosition() != RecyclerView.NO_POSITION)
                        {
                            ContentItem contentItem = mContentArrayList.get(viewHolder.getAdapterPosition());
                            mOnItemClickListener.onItemClick(contentItem, viewHolder.getAdapterPosition());
                        }
                    }
                    mHandler.postDelayed(new Runnable()
                    {
                        @Override public void run()
                        {
                            mIsAnimationClick = false;
                        }
                    },300);
                }

                @Override public void onAnimationStart()
                {

                }
            });
        }
    }

    public int getItemOuterMargin()
    {
        return ContentItemView.getViewMargin(mContext);
    }

    private void sendImpressionLog(ViewHolder viewHolder, ContentItem contentItem, int position)
    {
        if (contentItem != null && contentItem.isPromoted() == true)
        {
            if (mSponsoredContentDisplayed != null)
            {
                if (mSponsoredContentDisplayed.containsKey(contentItem.getId()) == false)
                {
                    mSponsoredContentDisplayed.put(contentItem.getId(), Integer.valueOf(position));
                    EventManager.getInstance().logSponsoredContentImpressionEvent(viewHolder.mRootView.getContext(), EventParameters.ACTION_IMPRESSION, contentItem.getName(), contentItem.getAdvertiserID(), contentItem.getId(), position);
                }
                //                if (mImpressionsArrayList.contains(contentItem) == false)
                //                {
                //                    mImpressionsArrayList.add(contentItem);
                ////                    LogEventHelper.logEventForSponsoredContent(mContext, LogParameters.TYPE_EVENT, LogParameters.CATEGORY_SPONSORED_CONTENT, LogParameters.ACTION_IMPRESSION, LogParameters.ACTION_IMPRESSION_VIEWED, contentItem.getId());
                ////                    EventManager.getInstance().logSponsoredContentImpressionEvent(mContext, EventParameters.ACTION_IMPRESSION_VIEWED,contentItem.getName(), contentItem.getAdvertiserID(), contentItem.getId(), position);
                //                }
            }
        }
    }
}