package com.kidoz.sdk.api.ui_views;

import android.content.Context;
import android.graphics.Rect;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;

import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.server_connect.GifDrawableCallback;
import com.kidoz.sdk.api.server_connect.SdkAPIManager;

import pl.droidsonroids.gif.GifDrawable;

/**
 * Created by Eugine on 8/17/2015.
 */
public class AnimatableGifImageView extends ImageView {

    private GifDrawable mAnimatedGifDrawable = null;

    public AnimatableGifImageView(Context context) {
        super(context);
    }

    public AnimatableGifImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AnimatableGifImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setAnimatedGif(Uri uri,IOnAnimatedGifReadyListener listener) {
        if (getId() == -1) {
            setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());
        }

        if (mAnimatedGifDrawable != null) {
            SdkAPIManager.getSdkApiInstance(getContext()).cancelGifLoadingRequest(getId() + "");
            mAnimatedGifDrawable.recycle();
            mAnimatedGifDrawable = null;
            setImageDrawable(null);
        }

        loadGifImage(uri, listener);
    }

    private void loadGifImage(Uri uri,final IOnAnimatedGifReadyListener listener) {
        if (uri != null) {
            SdkAPIManager.getSdkApiInstance(getContext()).loadGifImage(getContext(), uri, getId() + "", new GifDrawableCallback() {
                @Override
                public void onGifDrawableLoaded(GifDrawable gifDrawable) {
                    mAnimatedGifDrawable = gifDrawable;
                    if (gifDrawable != null && gifDrawable.isRecycled() == false) {
                        setImageDrawable(gifDrawable);
                        gifDrawable.start();

                        if (listener != null) {
                            listener.onGifReady();
                        }
                    }
                }
            });
        }
    }

    public void startGifAnimation() {
        if (mAnimatedGifDrawable != null) {
            mAnimatedGifDrawable.stop();
        }
    }

    public void stopGifAnimation() {
        if (mAnimatedGifDrawable != null) {
            mAnimatedGifDrawable.start();
        }
    }

    public void pauseGifAnimation() {
        if (mAnimatedGifDrawable != null) {
            if (mAnimatedGifDrawable.canPause()) {
                mAnimatedGifDrawable.pause();
            }
        }
    }


    @Override
    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);

      /*  if (visibility == View.VISIBLE) {
            changeGifAnimationState(true);
        } else {
            changeGifAnimationState(false);
        }*/

        SDKLogger.printWarningLog("ANIMATABLE GIF IMAGE : " + " ### - Window Visibility Change : " + visibility);
    }

    @Override
    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);

        if (visibility == View.VISIBLE) {
            changeGifAnimationState(true);
        } else {
            changeGifAnimationState(false);
        }

        SDKLogger.printWarningLog("ANIMATABLE GIF IMAGE : " + " ### - Visibility Change : " + visibility);
    }

    @Override
    protected void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);

        if(gainFocus == true) {
            changeGifAnimationState(true);
        }

        SDKLogger.printWarningLog("ANIMATABLE GIF IMAGE : " +" ### - Focus change  : GainFocus:" + gainFocus);
    }

    private void changeGifAnimationState(boolean isStateState) {
        if (mAnimatedGifDrawable != null && mAnimatedGifDrawable.isRecycled() == false) {
            if (isStateState == true) {
                if (mAnimatedGifDrawable.isPlaying() == false) {
                    mAnimatedGifDrawable.start();
                }
            } else {
                mAnimatedGifDrawable.stop();
            }
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();

        if (mAnimatedGifDrawable != null && mAnimatedGifDrawable.isRecycled() == false) {
            mAnimatedGifDrawable.recycle();
            mAnimatedGifDrawable = null;
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }


    public interface IOnAnimatedGifReadyListener {
        void onGifReady();
    }
}
