package com.kidoz.sdk.api.ui_views;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.Utils;

/**
 * Created by roni on 9/30/2015.
 */
public class AboutKidozWebViewContainer extends RelativeLayout
{
    private final String TAG = AboutKidozWebViewContainer.class.getSimpleName();

    private int mHeight;
    private int mWidth;
    private int mMargin;
    private Paint mPaint;

    public AboutKidozWebViewContainer(Context context)
    {
        super(context);
        initView();
    }

    private void initView()
    {
        setWillNotDraw(false);
        int screenMaxSize = Math.min(ScreenUtils.getScreenSize(getContext(), true), (ScreenUtils.getScreenSize(getContext(), false)));
        float MARGIN = 50 / 1080f;
        mMargin = (int) (screenMaxSize * MARGIN);
        mPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
        mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        mPaint.setColor(Color.parseColor("#ffffff"));
        initImageParameters();
    }

    private void initImageParameters()
    {
        mHeight = (int) (0.75f * ScreenUtils.getScreenSize(getContext(), false));
    }

    @Override protected void onConfigurationChanged(Configuration newConfig)
    {
        super.onConfigurationChanged(newConfig);
        initImageParameters();
        invalidate();
    }


    @Override protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec)
    {
        mWidth = MeasureSpec.getSize(widthMeasureSpec);
        setMeasuredDimension(mWidth, mHeight);
    }

    @Override protected void onLayout(boolean changed, int l, int t, int r, int b)
    {
        int left = 0;
        int top = 0;
        int right = mWidth;
        int bottom = mHeight;
        getChildAt(0).layout(left, top, right, bottom);

        int padding = Utils.dpTOpx(getContext(), 10);
        left = mWidth - (padding * 3);
        top = padding;
        right = left + (padding * 2);
        bottom = top + (padding * 2);
        getChildAt(1).layout(left, top, right, bottom);
    }

    @Override protected void onDraw(Canvas canvas)
    {
        super.onDraw(canvas);
        canvas.drawRect(0, 0, mWidth, mHeight, mPaint);
    }
}
