package com.kidoz.sdk.api.structure;



import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * Created by roni on 8/23/2015.
 */
public class ParentalLockData
{
    private final String TAG = ParentalLockData.class.getSimpleName();
    private boolean mIsActivated;
    private ArrayList<LockIconData> mLockIconArrayList;

    public ParentalLockData()
    {
    }

    public ParentalLockData(JSONObject jSONObject)
    {
        if (jSONObject != null)
        {
            try
            {
                if (jSONObject.has("is_parental_lock_activated") == true && jSONObject.isNull("is_parental_lock_activated") == false)
                {
                    mIsActivated = jSONObject.getBoolean("is_parental_lock_activated");
                }
                if (jSONObject.has("lock_icons") == true && jSONObject.isNull("lock_icons") == false)
                {
                    mLockIconArrayList = new ArrayList<LockIconData>();
                    JSONArray lockIconsArray = jSONObject.getJSONArray("lock_icons");
                    if (lockIconsArray.length() > 1)
                    {
                        HashMap<String, Integer> keysHashMap = new HashMap<String, Integer>();
                        JSONArray keysJSONArray = lockIconsArray.getJSONArray(0);
                        // 1. Extract the object keys.
                        for (int keyIndex = 0; keyIndex < keysJSONArray.length(); keyIndex++)
                        {
                            keysHashMap.put(keysJSONArray.getString(keyIndex), keyIndex);
                        }
                        // 2. Extract the objects using the keys above.
                        for (int lockIconIndex = 1; lockIconIndex < lockIconsArray.length(); lockIconIndex++)
                        {
                            JSONArray nextJSONArray = lockIconsArray.getJSONArray(lockIconIndex);
                            LockIconData nextLockIconData = new LockIconData(nextJSONArray, keysHashMap);
                            mLockIconArrayList.add(nextLockIconData);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error creating parental lock data: " + ex.getMessage());
            }
        }

    }

    public boolean getIsActivated()
    {
        return mIsActivated;
    }

    public void setIsActivated(boolean isActivated)
    {
        mIsActivated = isActivated;
    }

    public ArrayList<LockIconData> getLockIconArrayList()
    {
        return mLockIconArrayList;
    }

    public void setLockIconArrayList(ArrayList<LockIconData> lockIconArrayList)
    {
        mLockIconArrayList = lockIconArrayList;
    }
}
