package com.kidoz.sdk.api.structure;

import android.graphics.Color;

import com.kidoz.sdk.api.general.enums.ContentType;

import org.json.JSONArray;

import java.io.Serializable;
import java.util.HashMap;

/**
 * Created by orikam on 7/13/15.
 * Class trepresent a single ContentItem received from the server
 */
public class ContentItem implements Serializable {

    private final String ID_KEY = "id";
    private final String THUMB_KEY = "thumb";
    private final String SEC_THUMB_KEY = "sec_thumb";
    private final String CONTENT_TYPE_KEY = "type";
    private final String DATA_KEY = "data";
    private final String TITLE_KEY = "title";
    private final String LANG_KEY = "lang";
    private final String PROMOTED_KEY = "promoted";
    private final String ADVERTISER_KEY = "advertiser_id";

    private String mId;
    private String mThumb;
    private String mSecThumb;
    private ContentType mContentType;
    private String mData;
    private String mTiltle;
    private String mLang;
    private boolean mPromoted;
    private String mAdvertiserID;

    // Inner variables
    private int[] mMainThumbSize;
    private float mMainThumbImageRation;
    private int mPaliteBgColor = Color.WHITE;
    private int mPaliteTextColor = Color.parseColor("#484848");

    public ContentItem(JSONArray jsonArray, HashMap<String, Integer> keysMap) {
        if (jsonArray != null) {
            // Get item Id
            if (keysMap.containsKey(ID_KEY)) {
                mId = jsonArray.optString(keysMap.get(ID_KEY), "");
            }

            // Get thumb url
            if (keysMap.containsKey(THUMB_KEY)) {
                mThumb = jsonArray.optString(keysMap.get(THUMB_KEY), "");
                mThumb = com.kidoz.sdk.api.general.utils.Utils.fixUrlLink(mThumb);
                getThumbSize();
            }

            // Get thumb url
            if (keysMap.containsKey(SEC_THUMB_KEY)) {
                mSecThumb = jsonArray.optString(keysMap.get(SEC_THUMB_KEY), "");
                mSecThumb = com.kidoz.sdk.api.general.utils.Utils.fixUrlLink(mSecThumb);
            }

            // Get content type
            if (keysMap.containsKey(CONTENT_TYPE_KEY)) {
                try {
                    int val = jsonArray.optInt(keysMap.get(CONTENT_TYPE_KEY), -1);
                    mContentType = ContentType.getTypeByValue(val);
                    if (mContentType != null) {
                        switch (mContentType) {
                            case PROMOTED_PLAY_APPLICATION: {
                            }
                            case GOOGLE_PLAY_APPLICATION: {
                                mPaliteBgColor = Color.parseColor("#4aaed3");
                                break;
                            }
                            case WEB_GAME_URL: {
                                mPaliteBgColor = Color.parseColor("#b0d63a");
                                break;
                            }
                            case STREAMING_VIDEO: {
                            }
                            case YOTUBE_VIDEO: {
                                mPaliteBgColor = Color.parseColor("#f8de46");
                                break;
                            }
                            case WEBSITE_URL: {
                                mPaliteBgColor = Color.parseColor("#f8a850");
                                break;
                            }
                        }
                    }

                } catch (Exception e) {
                    com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog("Error parsing single content item Action : \n" + e.getMessage());
                    mContentType = ContentType.NONE;
                }
            }

            // Get data
            if (keysMap.containsKey(DATA_KEY)) {
                mData = jsonArray.optString(keysMap.get(DATA_KEY), "");
            }

            // Get item title
            if (keysMap.containsKey(TITLE_KEY)) {
                mTiltle = jsonArray.optString(keysMap.get(TITLE_KEY), "");
            }

            // Get item language
            if (keysMap.containsKey(LANG_KEY)) {
                mLang = jsonArray.optString(keysMap.get(LANG_KEY), "");
            }

            // Get Advertiser id
            if (keysMap.containsKey(ADVERTISER_KEY)) {
                mAdvertiserID = jsonArray.optString(keysMap.get(ADVERTISER_KEY), "0");
            }

            // Get id item promoted
            if (keysMap.containsKey(PROMOTED_KEY)) {
                int val = jsonArray.optInt(keysMap.get(PROMOTED_KEY), 0);
                mPromoted = val == 1;
            }
        }
    }//end ContentItem

    private void getThumbSize() {
        String sizePrefix = "ImageSize_";

        if (mThumb.contains(sizePrefix) == true) {
            try {
                String[] dotSplitArray = mThumb.split("\\.");
                String stripedExtensionString = dotSplitArray[dotSplitArray.length - 2];
                int start = stripedExtensionString.indexOf(sizePrefix);
                if (start != -1) {
                    String sizeString = stripedExtensionString.substring(start + sizePrefix.length(), stripedExtensionString.length());
                    String[] values = sizeString.split("_");
                    mMainThumbSize = new int[2];
                    mMainThumbSize[0] = Integer.parseInt(values[0]);
                    mMainThumbSize[1] = Integer.parseInt(values[1]);
                    mMainThumbImageRation = (float) (mMainThumbSize[1]) / (float) (mMainThumbSize[0]);
                }
            } catch (Exception ex) {
                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog("Error trying to extract image size from WEBSITE_URL: \n" + mThumb + "\n " + ex.getMessage());
            }
        }
    }

    public int getPaliteBgColor() {
        return mPaliteBgColor;
    }

    public void setPaliteBgColor(int paliteBgColor) {
        //        this.mPaliteBgColor = paliteBgColor;
    }

    public int getPaliteTextColor() {
        return mPaliteTextColor;
    }

    public void setPaliteTextColor(int paliteTextColor) {
        this.mPaliteTextColor = paliteTextColor;
    }

    public float getMainThumbImageRatio() {
        return mMainThumbImageRation;
    }

    public int[] getMainThumbSize() {
        return mMainThumbSize;
    }

    public String getId() {
        return mId;
    }

    public String getThumb() {
        return mThumb;
    }

    public void setThumb(String thumb) {
        this.mThumb = thumb;
    }

    public ContentType getContentType() {
        return mContentType;
    }

    public String getSecThumb() {
        return mSecThumb;
    }

    public String getData() {
        return mData;
    }

    public void setData(String data) {
        this.mData = data;
    }

    public String getName() {
        return mTiltle;
    }

    public void setName(String name) {
        this.mTiltle = name;
    }

    public String getLang() {
        return mLang;
    }

    public boolean isPromoted() {
        return mPromoted;
    }

    public String getAdvertiserID() {return mAdvertiserID;}

    public void setContentType(ContentType contentType) {
        mContentType = contentType;
    }

}
