package com.kidoz.sdk.api.server_connect;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.AsyncTask.Status;
import android.os.Build;
import android.os.Environment;
import android.util.Log;

import com.kidoz.sdk.api.general.assets_handling.ImageAssetsUtils;
import com.kidoz.sdk.api.general.assets_handling.SoundAssetsUtils;
import com.kidoz.sdk.api.general.utils.ConstantDef;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.UriUtil;
import com.kidoz.sdk.api.structure.ContentData;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Response;

import org.json.JSONObject;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map.Entry;

import pl.droidsonroids.gif.GifDrawable;

@SuppressLint("NewApi") class BaseAPIManager extends BaseConnectionClient
{
    private static final String TAG = BaseAPIManager.class.getSimpleName();
    private HashMap<SdkRequestType, RequestAsyncTask> runningTaskList = new HashMap<SdkRequestType, RequestAsyncTask>();
    private HashMap<String, GifAsyncTaskLoader> mGifLoadingTasks = new HashMap<String, GifAsyncTaskLoader>();

    /**
     * Launch specific API request
     */
    @TargetApi(Build.VERSION_CODES.HONEYCOMB) protected void startServerConnection(Context context, CONNECTION_TYPE type, SdkRequestType requestType,
                                                                                   ContentValues contentValues, int numOfReconnecsOnFail, ApiResultCallback<?> resultCallback,boolean devLog)
    {
        try
        {
            if (runningTaskList.containsKey(requestType))
            {
                if (runningTaskList.get(requestType) != null)
                {
                    RequestAsyncTask task = runningTaskList.get(requestType);
                    if (task.getStatus() != Status.FINISHED)
                    {
                        task.cancel(true);
                        task.closeCurrentConnection();
                    }
                    else
                    {
                        runningTaskList.remove(requestType);
                    }
                }
            }
        }
        catch (Exception ex)
        {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, " \n Unable to finish Running Request asyncTask ! \n\n " + ex.getMessage());
        }

        RequestAsyncTask requestAsyncTask = new RequestAsyncTask(context, type, requestType, contentValues, numOfReconnecsOnFail, resultCallback,devLog);
        runningTaskList.put(requestType, requestAsyncTask);

        if (Build.VERSION.SDK_INT < 11)
        {
            requestAsyncTask.execute();
        }
        else
        {
            requestAsyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        }
    }


    /**
     * Cancel all running task
     */
    public void cancelAllRunningRequests()
    {
        Iterator<Entry<SdkRequestType, RequestAsyncTask>> it = runningTaskList.entrySet().iterator();
        while (it.hasNext())
        {
            Entry<SdkRequestType, RequestAsyncTask> entry = it.next();
            RequestAsyncTask asyncTask = entry.getValue();
            if (asyncTask != null)
            {
                if (asyncTask.getStatus() == Status.RUNNING && asyncTask.getStatus() == Status.PENDING)
                {
                    asyncTask.cancel(true);
                    asyncTask.closeCurrentConnection();
                }
            }
        }
        runningTaskList.clear();
    }


    /**
     * Background Async Task executor for HTTP server requests
     */
    class RequestAsyncTask extends AsyncTask<Void, Void, ResultData<?>>
    {

        private CONNECTION_TYPE restRequestType = CONNECTION_TYPE.POST;
        private ApiResultCallback<?> mResultCallback;
        private int numOfReconnectionsOnFail = 0;
        private SdkRequestType sdkRequestType;
        private ContentValues mContentValues;
        private Call mCall;
        private Context mContext;
        private boolean mDeveloperLogging = false;

        public RequestAsyncTask(Context context, CONNECTION_TYPE type, SdkRequestType requestType, ContentValues contentValues, int numOfReconnecsOnFail, ApiResultCallback<?> resultCallback,boolean devLog)
        {
            mContext = context;
            restRequestType = type;
            sdkRequestType = requestType;
            mContentValues = contentValues;
            mResultCallback = resultCallback;
            restRequestType = type;
            numOfReconnectionsOnFail = numOfReconnecsOnFail;
            mDeveloperLogging = devLog;
        }

        @Override protected ResultData<?> doInBackground(Void... params)
        {

            String dataResponce = null;
            ResultData<?> webServiceResult = null;

            int mReconnectionTries = 0;
            if (!isCancelled())
            {
                Response response = null;
                while (mReconnectionTries <= numOfReconnectionsOnFail) // make reconnection tries
                {
                    mReconnectionTries = mReconnectionTries + 1;
                    if (!isCancelled())
                    {
                        try
                        {
                            if (restRequestType == CONNECTION_TYPE.POST)
                            {
                                com.kidoz.sdk.api.general.utils.SDKLogger.printPostRequestDebugLog(MAIN_SERVER_URL, mContentValues, sdkRequestType.name());
                                mCall = makePostConnection(MAIN_SERVER_URL, mContentValues, sdkRequestType.name());
                                if (mCall != null)
                                {
                                    response = mCall.execute();
                                }
                            }
                            else
                            {
                                com.kidoz.sdk.api.general.utils.SDKLogger.printGetRequestDebugLog(MAIN_SERVER_URL, mContentValues, sdkRequestType.name());
                                mCall = makeGetConnection(MAIN_SERVER_URL, mContentValues, sdkRequestType.name());
                                if (mCall != null)
                                {
                                    response = mCall.execute();
                                }
                            }
                        }
                        catch (IOException e)
                        {
                            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(" \n IO Exception On [" + sdkRequestType.name() + "] request! \n" + e.getMessage());
                        }
                    }
                    else
                    {
                        break;
                    }

                    if (response != null)
                    {
                        if (!isCancelled())
                        {
                            if (response.isSuccessful())
                            {
                                try
                                {
                                    com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(" \n Succesfull connection ! , Code :  " + response.code());
                                    dataResponce = StreamToStringConverter.readStream(new BufferedInputStream(response.body().byteStream()), this, true);
                                    break;
                                }
                                catch (IOException e)
                                {
                                    com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(" \n Unable to convertByte Stream to String! : \n\n" + e.getMessage());
                                }
                            }
                            else
                            {
                                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(" \n Server connectivity Error!  Code : " + response.code());
                            }
                        }
                        else
                        {
                            break;
                        }
                    }
                    try
                    {
                        if (!isCancelled())
                        {
                            Thread.sleep(300 * mReconnectionTries * 2);
                        }
                        else
                        {
                            break;
                        }
                    }
                    catch (InterruptedException e)
                    {
                        break;
                    }
                }
            }

            // Print server responce string before parsing data responce
            com.kidoz.sdk.api.general.utils.SDKLogger.printResponse(dataResponce, sdkRequestType.name());

            if (isCancelled())
            {
                return null;
            }

            if (dataResponce != null)
            {
                if (!isCancelled())
                {
                    if(mContext != null) {
                        webServiceResult = parseWerServiceResponce(mContext,sdkRequestType,dataResponce,mDeveloperLogging);
                    }
                }
                return webServiceResult;
            }
            else
            {
                return null;
            }
        }

        @Override protected void onPostExecute(ResultData<?> result)
        {
            if (!isCancelled())
            {
                if (result == null)
                {
                    if (mResultCallback != null)
                    {
                        mResultCallback.onFailed();
                    }
                }
                else
                {
                    if (mResultCallback != null)
                    {
                        mResultCallback.onServerResult(result);
                    }
                }
            }
            runningTaskList.remove(sdkRequestType);
        }

        @Override protected void onCancelled()
        {
            super.onCancelled();
            if (sdkRequestType != null && runningTaskList != null)
            {
                runningTaskList.remove(sdkRequestType);
            }
        }

        public void closeCurrentConnection()
        {
            if (mCall != null)
            {
                if (mCall.isCanceled() == false)
                {
                    mCall.cancel();
                }
            }
        }

        public String getRequestTag()
        {
            return sdkRequestType.name();
        }
    }


    private  ResultData<?> parseWerServiceResponce(Context context,SdkRequestType sdkRequestType,String dataResponce,boolean devLog) {

        ResultData<?> webServiceResult = null;
        switch (sdkRequestType)
        {
            //Parsers
            case LOAD_SDK_CONTENT:
            {
                ContentData contentData = new ContentData();
                contentData.decodeResponse(dataResponce);
                ResultData<ContentData> resultData = new ResultData<ContentData>();
                resultData.setData(contentData);
                webServiceResult = resultData;

                if(devLog) {
                    if(contentData.getContentDataItems() == null) {
                        Log.d(SDKLogger.GENERAL_TAG, "Error : Unable to get FeedView data!");
                    }
                    else if(contentData.getContentDataItems().isEmpty()) {
                        Log.d(SDKLogger.GENERAL_TAG, "Error : FeedView data list is Empty !");
                    }else {
                        Log.d(SDKLogger.GENERAL_TAG, "Success : Recieved " + contentData.getContentDataItems() + "FeedView data items!");
                    }
                }

                break;
            }
            case VALIDATE_SDK:
            {
                try
                {
                    ResponseStatus responseStatus = new ResponseStatus(dataResponce);
                    ResultData<PropertiesObj> resultData = new ResultData<PropertiesObj>();
                    resultData.setResponseStatus(responseStatus);
                    if (responseStatus.getIsSuccessful() == true)
                    {
                        JSONObject jSONObject = new JSONObject(dataResponce);
                        PropertiesObj propertiesObj = new PropertiesObj(jSONObject.optJSONObject("data"));
                        resultData.setData(propertiesObj);
                    }
                    webServiceResult = resultData;
                }
                catch (Exception ex)
                {
                    com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to parse validate SDK: " + ex.getMessage());
                }
                break;
            }
            case GET_SDK_RESOURCES:
            {
                try
                {
                    com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>dataResponce = \n" + dataResponce);
                    ResponseStatus responseStatus = new ResponseStatus(dataResponce);
                    ResultData<Boolean> resultData = new ResultData<Boolean>();
                    resultData.setResponseStatus(responseStatus);
                    if (responseStatus.getIsSuccessful() == true)
                    {
                        com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>Get SDK assets");
                        boolean isImagesAssetsSynced;
                        String isAssetsSyncedFlag = SharedPreferencesUtils.loadSharedPreferencesData(context, ImageAssetsUtils.IMAGE_ASSETS_SYNCED_FLAG);
                        if (isAssetsSyncedFlag == null)
                        {
                            com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>Downloading image assets");
                            isImagesAssetsSynced = ImageAssetsUtils.parseAssets(context, dataResponce);
                            if (isImagesAssetsSynced == true)
                            {
                                com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>All image assets downloaded");
                                SharedPreferencesUtils.saveSharedPreferencesData(context, ImageAssetsUtils.IMAGE_ASSETS_SYNCED_FLAG, ImageAssetsUtils.IMAGE_ASSETS_SYNCED_FLAG);
                            }
                            else
                            {
                                com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>Not all image assets downloaded");
                            }
                        }
                        else
                        {
                            com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>Image assets already downloaded");
                            isImagesAssetsSynced = true;
                        }

                        boolean isParentalLockAssetsSynced;
                        String isParentalLockAssetsSyncedFlag = SharedPreferencesUtils.loadSharedPreferencesData(context, ImageAssetsUtils.PARENTAL_LOCK_ASSETS_SYNCED_FLAG);
                        if (isParentalLockAssetsSyncedFlag == null)
                        {
                            com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>Downloading parental lock assets");
                            isParentalLockAssetsSynced = ImageAssetsUtils.parseLockIcons(context, dataResponce);
                            if (isParentalLockAssetsSynced == true)
                            {
                                com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>All parental lock assets downloaded");
                                SharedPreferencesUtils.saveSharedPreferencesData(context, ImageAssetsUtils.PARENTAL_LOCK_ASSETS_SYNCED_FLAG, ImageAssetsUtils.PARENTAL_LOCK_ASSETS_SYNCED_FLAG);
                            }
                            else
                            {
                                com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>Not all parental lock assets downloaded");
                            }
                        }
                        else
                        {
                            com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>Parental lock assets already downloaded");
                            isParentalLockAssetsSynced = true;
                        }

                        boolean isSoundsAssetsSynced;
                        String isSoundsAssetsSyncedFlag = SharedPreferencesUtils.loadSharedPreferencesData(context, SoundAssetsUtils.SOUND_ASSETS_SYNCED_FLAG);
                        if (isSoundsAssetsSyncedFlag == null)
                        {
                            com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>Downloading sound assets");
                            isSoundsAssetsSynced = SoundAssetsUtils.parseSounds(context, dataResponce);
                            if (isSoundsAssetsSynced == true)
                            {
                                com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>All sound assets downloaded");
                                SharedPreferencesUtils.saveSharedPreferencesData(context, SoundAssetsUtils.SOUND_ASSETS_SYNCED_FLAG, SoundAssetsUtils.SOUND_ASSETS_SYNCED_FLAG);
                            }
                            else
                            {
                                com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>Not all sound assets downloaded");
                            }
                        }
                        else
                        {
                            com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>Sound assets already downloaded");
                            isSoundsAssetsSynced = true;
                        }

                        resultData.setData(isImagesAssetsSynced == true && isParentalLockAssetsSynced == true && isSoundsAssetsSynced == true);
                    }
                    webServiceResult = resultData;
                }
                catch (Exception ex)
                {
                    com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to parse get SDK resources: " + ex.getMessage());
                }
                break;
            }
        }

        return webServiceResult;
    }


    /**
     * Cancel all running task
     *
     * @param requestType type
     */
    public void cancelRequest(SdkRequestType requestType)
    {
        if (runningTaskList.containsKey(requestType))
        {
            if (runningTaskList.get(requestType) != null && runningTaskList.get(requestType).getStatus() != Status.FINISHED)
            {
                runningTaskList.get(requestType).cancel(true);
                runningTaskList.get(requestType).closeCurrentConnection();
            }
        }
    }

    /**
     * Load gif Image
     */
    @TargetApi(Build.VERSION_CODES.HONEYCOMB) public void loadGifImage(Context context, Uri uri, String tag, GifDrawableCallback drawableCallback)
    {
        try
        {
            if (mGifLoadingTasks.containsKey(tag))
            {
                if (mGifLoadingTasks.get(tag) != null)
                {
                    GifAsyncTaskLoader task = mGifLoadingTasks.get(tag);
                    if (task.getStatus() != Status.FINISHED)
                    {
                        task.cancel(true);
                        task.closeCurrentConnection();
                    }
                    else
                    {
                        mGifLoadingTasks.remove(tag);
                    }
                }
            }
        }
        catch (Exception ex)
        {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, " \n Unable to finish gif image loading task asyncTask ! \n\n " + ex.getMessage());
        }

        GifAsyncTaskLoader requestAsyncTask = new GifAsyncTaskLoader(context, uri, tag, drawableCallback);
        mGifLoadingTasks.put(tag, requestAsyncTask);

        if (Build.VERSION.SDK_INT < 11)
        {
            requestAsyncTask.execute();
        }
        else
        {
            requestAsyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        }
    }

    /**
     * Cancel gif loading request task
     *
     * @param tag type
     */
    public void cancelGifLoadingRequest(String tag)
    {
        if (mGifLoadingTasks.containsKey(tag))
        {
            if (mGifLoadingTasks.get(tag) != null && mGifLoadingTasks.get(tag).getStatus() != Status.FINISHED)
            {
                mGifLoadingTasks.get(tag).cancel(true);
                mGifLoadingTasks.get(tag).closeCurrentConnection();
            }
        }
    }

    /**
     * Background Async Task executor for loading gif image animations
     */
    class GifAsyncTaskLoader extends AsyncTask<Void, Void, GifDrawable>
    {

        private static final String NEW_ANIMATION_TEMP_NAME = "temp_GifAnim.gif";

        private Call mCall;
        private Uri mUri;
        private GifDrawableCallback mGifDrawableCallback;
        private Context mContext;
        private File myAnimFile;
        private String mTag;

        public GifAsyncTaskLoader(Context context, Uri uri, String tag, GifDrawableCallback drawableCallback)
        {
            mUri = uri;
            mGifDrawableCallback = drawableCallback;
            mContext = context;
            mTag = tag;
        }

        @Override protected GifDrawable doInBackground(Void... params)
        {
            GifDrawable mGifDrawable = null;
            if (!isCancelled())
            {
                if (mUri != null)
                {
                    // Load from Url
                    if (UriUtil.isNetworkUri(mUri))
                    {
                        final String url = mUri.toString();
                        // Check if valid link and of Gif type
                        if (url != null && url.contains(".gif") || url.contains(".GIF"))
                        {
                            int index1 = url.lastIndexOf("/");
                            // Extract file name
                            String name = url.substring(index1 + 1, url.length());
                            // Get temp folder sd card path
                            File filePath = getSDfoldersPath();

                            if (filePath != null)
                            {
                                // Create file path
                                myAnimFile = new File(filePath, name);
                                if (myAnimFile != null)
                                {
                                    if (myAnimFile.exists() == true && myAnimFile.length() > 0)
                                    {
                                        // If we have new animation file we want to delete the previous and rename the new to the same name
                                        File tempAnimFile = new File(filePath, NEW_ANIMATION_TEMP_NAME);
                                        if (tempAnimFile != null && tempAnimFile.exists())
                                        {
                                            myAnimFile.delete();
                                            tempAnimFile.renameTo(myAnimFile);
                                        }

                                        try
                                        {
                                            // If animation file already exists no need to download it just play it
                                            mGifDrawable = new GifDrawable(myAnimFile);
                                        }
                                        catch (IOException e)
                                        {
                                            // If something went wrong delete the file
                                            if (myAnimFile != null && myAnimFile.exists() == true)
                                            {
                                                myAnimFile.delete();
                                            }
                                            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(" \n Unable to create GidDrawable ! : \n\n" + e.getMessage());
                                        }
                                    }

                                    if (isCancelled() == false)
                                    {
                                        // We check if file alreadu exists and if it the same file currently on the server
                                        if (myAnimFile.exists() == true)
                                        {
                                            Thread thread = new Thread(new Runnable()
                                            {
                                                @Override public void run()
                                                {

                                                    File tempAnimFile = new File(getSDfoldersPath(), NEW_ANIMATION_TEMP_NAME);
                                                    if (tempAnimFile != null)
                                                    {
                                                        if (tempAnimFile.exists())
                                                        {
                                                            tempAnimFile.delete();
                                                        }
                                                    }

                                                    InputStream inputStream = null;
                                                    try
                                                    {
                                                        Response response = null;
                                                        mCall = BaseConnectionClient.getImageStream(url, mTag);
                                                        response = mCall.execute();
                                                        inputStream = response.body().byteStream();
                                                        if (response.isSuccessful() == true && inputStream != null)
                                                        {
                                                            long savedFileSize = myAnimFile.length();
                                                            long newFileSize = -1;
                                                            String fileSize = response.header("content-length");
                                                            if (fileSize != null)
                                                            {
                                                                try
                                                                {
                                                                    newFileSize = Long.parseLong(fileSize);
                                                                }
                                                                catch (NumberFormatException e)
                                                                {
                                                                    newFileSize = -1;
                                                                }
                                                            }

                                                            //In case its not the same file the old one will be replaced. and the new one will be played next lounch.
                                                            if (newFileSize != -1 && newFileSize != savedFileSize)
                                                            {
                                                                tempAnimFile.createNewFile();
                                                                loadImageAndSaveToSd(inputStream, tempAnimFile);
                                                            }
                                                        }
                                                    }
                                                    catch (IOException e)
                                                    {
                                                        com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(" \n Failed to load gif image for the server ! : \n\n");
                                                    }
                                                    finally
                                                    {
                                                        if (inputStream != null)
                                                        {
                                                            try
                                                            {
                                                                inputStream.close();
                                                            }
                                                            catch (IOException e)
                                                            {
                                                            }
                                                        }
                                                    }
                                                }
                                            });
                                            thread.setPriority(Thread.MIN_PRIORITY);
                                            thread.start();
                                        }
                                        else
                                        {

                                            InputStream inputStream = null;
                                            try
                                            {

                                                Response response = null;
                                                mCall = BaseConnectionClient.getImageStream(url, mTag);
                                                response = mCall.execute();
                                                inputStream = response.body().byteStream();
                                                if (response.isSuccessful() == true && inputStream != null)
                                                {
                                                    // Load image and save it to sd card
                                                    myAnimFile.createNewFile();
                                                    loadImageAndSaveToSd(inputStream, myAnimFile);

                                                    if (myAnimFile.exists() == true && myAnimFile.length() > 0)
                                                    {
                                                        try
                                                        {
                                                            // Create animation drawable from newly downloaded file
                                                            mGifDrawable = new GifDrawable(myAnimFile);
                                                        }
                                                        catch (IOException e)
                                                        {
                                                            // If something went wrong delete the file
                                                            if (myAnimFile != null && myAnimFile.exists() == true)
                                                            {
                                                                myAnimFile.delete();
                                                            }
                                                            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(" \n Unable to create GidDrawable ! : \n\n" + e.getMessage());
                                                        }
                                                    }
                                                }
                                            }
                                            catch (IOException e)
                                            {
                                                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(" \n Failed to load gif image for the server ! : \n\n");
                                            }
                                            finally
                                            {
                                                if (inputStream != null)
                                                {
                                                    try
                                                    {
                                                        inputStream.close();
                                                    }
                                                    catch (IOException e)
                                                    {
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                else
                                {
                                    com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(" \n Failed to create Gif image file path ! : \n\n");
                                }
                            }
                        }
                    } // Load from Asset
                    else if (UriUtil.isLocalAssetUri(mUri))
                    {
                        if (isCancelled() == false)
                        {
                            try
                            {
                                InputStream inputStream = mContext.getAssets().open(mUri.getLastPathSegment());
                                mGifDrawable = new GifDrawable(inputStream);
                            }
                            catch (IOException e)
                            {
                                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(" \n Unable to create GidDrawable ! : \n\n" + e.getMessage());
                            }
                        }

                    } // Load from Local Resource
                    else if (UriUtil.isLocalResourceUri(mUri))
                    {
                        if (isCancelled() == false)
                        {
                            try
                            {
                                int res = Integer.valueOf(mUri.getLastPathSegment());
                                mGifDrawable = new GifDrawable(mContext.getResources(), res);
                            }
                            catch (IOException e)
                            {
                                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(" \n Unable to create GidDrawable ! : \n\n" + e.getMessage());
                            }
                        }

                    } // Load from File
                    else if (UriUtil.isLocalFileUri(mUri))
                    {
                        if (isCancelled() == false)
                        {
                            myAnimFile = new File(mUri.toString());
                            if (myAnimFile.exists() == true && myAnimFile.length() > 0)
                            {
                                try
                                {
                                    mGifDrawable = new GifDrawable(myAnimFile);
                                }
                                catch (IOException e)
                                {
                                    com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(" \n Unable to create GidDrawable ! : \n\n" + e.getMessage());
                                }
                            }
                        }
                    }
                }
            }
            return mGifDrawable;
        }

        public void loadImageAndSaveToSd(InputStream inputStream, File filePath)
        {
            try
            {
                OutputStream output = new FileOutputStream(filePath);
                try
                {
                    byte[] buffer = new byte[4096];
                    int bytesRead = 0;
                    while ((bytesRead = inputStream.read(buffer, 0, buffer.length)) >= 0)
                    {
                        output.write(buffer, 0, bytesRead);
                    }
                }
                finally
                {
                    output.close();
                }
            }
            catch (IOException e)
            {
                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(" \n Failed to read Gif image input stream !: \n\n" + e.getMessage());
            }
            finally
            {
                if (inputStream != null)
                {
                    try
                    {
                        inputStream.close();
                    }
                    catch (IOException e)
                    {
                    }
                }
            }
        }

        @Override protected void onPostExecute(GifDrawable gifDrawable)
        {
            super.onPostExecute(gifDrawable);

            if (mGifDrawableCallback != null && isCancelled() == false)
            {
                mGifDrawableCallback.onGifDrawableLoaded(gifDrawable);
            }
        }


        @Override protected void onCancelled()
        {
            super.onCancelled();

        }

        public void closeCurrentConnection()
        {
            if (mCall != null)
            {
                if (mCall.isCanceled() == false)
                {
                    mCall.cancel();
                }
            }
        }

        /**
         * Get correct folder path for tem animation files
         *
         * @return folder path
         */
        private File getSDfoldersPath()
        {
            // Check if storage available for saving gif animation file
            File filePath = null;
            String state = Environment.getExternalStorageState();
            if (Environment.MEDIA_MOUNTED.equals(state))
            {
                if (mContext != null)
                {
                    // Trying to get private storage location if exists
                    filePath = mContext.getExternalFilesDir(ConstantDef.TEMPORARY_SDK_SD_FOLDER_NAME);
                    if (filePath.exists() == false)
                    {
                        filePath.mkdirs();
                    }
                }

                // Trying to get public storage location if exists in case private is not accessible
                if (filePath == null)
                {
                    String path = Environment.getExternalStorageDirectory() + File.separator + ConstantDef.TEMPORARY_SDK_SD_FOLDER_NAME;
                    filePath = new File(path);
                    if (filePath.exists() == false)
                    {
                        filePath.mkdirs();
                    }
                }
            }
            return filePath;
        }

    }
}
