package com.kidoz.sdk.api.players.web_player;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.ActivityInfo;
import android.os.Bundle;
import android.view.View;

import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.general.BaseDialog;
import com.kidoz.sdk.api.structure.ContentItem;

/**
 * Created by Eugine on 10/1/2015.
 */
public class WebPlayerDialog extends BaseDialog {

    private static final String TAG = WebPlayerDialog.class.getSimpleName();

    private static final int WEB_PLAYER_RESOURCE_ID = 1;

    private static final String CONTENT_ITEM_SAVE_STATE_KEY = "CONTENT_ITEM_SAVE_STATE_KEY";
    private static final String WEB_PLAYER_TYPE_SAVE_STATE_KEY = "WEB_PLAYER_TYPE_SAVE_STATE_KEY";
    private static final String ORIENTATION_STATE_SAVE_STATE_KEY = "ORIENTATION_STATE_SAVE_STATE_KEY";
    private static final String EVENT_ID_STATE_SAVE_STATE_KEY = "EVENT_ID_STATE_SAVE_STATE_KEY";
    private static final String ORIENTATION_MODFY_SAVE_STATE_KEY = "ORIENTATION_MODFY_SAVE_STATE_KEY";

    private ContentItem mContentItem;
    private WebPlayerType mWebPlayerType;
    private WebPlayerView mWebPlayerView;

    private long mEventID;
    private boolean mAlllowOrientationModify = false;

    public WebPlayerDialog(Context context, ContentItem contentItem, WebPlayerType webPlayerType,boolean allowOrientationModification) {
        super(context, android.R.style.Theme_Black_NoTitleBar_Fullscreen);
        setCancelable(true);

        mContentItem = contentItem;
        mWebPlayerType = webPlayerType;
        mAlllowOrientationModify = allowOrientationModification;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        if (savedInstanceState != null) {
            mAlllowOrientationModify = savedInstanceState.getBoolean(ORIENTATION_MODFY_SAVE_STATE_KEY);
        }


        if(mAlllowOrientationModify) {
            if (savedInstanceState != null && savedInstanceState.containsKey(ORIENTATION_STATE_SAVE_STATE_KEY)) {
                mCurrentOrientationState = savedInstanceState.getInt(ORIENTATION_STATE_SAVE_STATE_KEY);
            } else {
                if (mCallingActivity instanceof Activity && mCallingActivity.isFinishing() == false) {
                    mCurrentOrientationState = mCallingActivity.getResources().getConfiguration().orientation;
                    mCallingActivity.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR);
                }
            }
        }


        if (savedInstanceState != null) {
            if (savedInstanceState.containsKey(CONTENT_ITEM_SAVE_STATE_KEY)) {
                mContentItem = (ContentItem) savedInstanceState.getSerializable(CONTENT_ITEM_SAVE_STATE_KEY);
            }
            mWebPlayerType = (WebPlayerType) savedInstanceState.getSerializable(WEB_PLAYER_TYPE_SAVE_STATE_KEY);
            mEventID = savedInstanceState.getLong(EVENT_ID_STATE_SAVE_STATE_KEY);
        }

        mWebPlayerView = new WebPlayerView(mCallingActivity, mWebPlayerType);
        if (mContentItem != null) {
            mWebPlayerView.loadWebUrl(mContentItem.getData(), mContentItem.getId(), mContentItem.getName());
        }

        mWebPlayerView.setOnCloseButtonClickListenr(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                closeDialog();
            }
        });

        mWebPlayerView.setOnRemoveViewRequestListener(new WebPlayerView.IOnRemoveViewRequestListener() {
            @Override
            public void onRemoveView() {
                closeDialog();
            }
        });

        setContentView(mWebPlayerView);

        setOnDismissListener(new OnDismissListener() {
            @Override
            public void onDismiss(DialogInterface dialog) {
                // Restore previous orientation
                if(mAlllowOrientationModify) {
                    restoreUserOriginalOrientation();
                }

                EventManager.getInstance().activityEnd(getContext(), EventManager.LOG_CRITICAL_LEVEL, mEventID);
                EventManager.getInstance().logEventWithDurationEnd(getContext(), WEB_PLAYER_RESOURCE_ID);
            }
        });
    }

    @Override
    protected void onStart() {
        super.onStart();
    }

    @Override
    protected void onStop() {
        super.onStop();
    }

    @Override
    public Bundle onSaveInstanceState() {
        Bundle bundle = super.onSaveInstanceState();
        if (bundle != null) {
            bundle.putSerializable(CONTENT_ITEM_SAVE_STATE_KEY, mContentItem);
            bundle.putSerializable(WEB_PLAYER_TYPE_SAVE_STATE_KEY, mWebPlayerType);
            bundle.putSerializable(ORIENTATION_STATE_SAVE_STATE_KEY, mCurrentOrientationState);
            bundle.putSerializable(EVENT_ID_STATE_SAVE_STATE_KEY, mEventID);
            bundle.putBoolean(ORIENTATION_MODFY_SAVE_STATE_KEY,mAlllowOrientationModify);
        }
        return bundle;
    }

    @Override
    public void closeDialog() {
        super.closeDialog();

    }

    @Override
    public void openDialog() {
        super.openDialog();


        String activityName = "";
        String action = "";
        switch (mWebPlayerType) {
            case EXTERNAL_LINK:
                activityName = "Web Player External Link";
                action = EventParameters.ACTION_EXTERNAL_LINK_VIEW;
                break;
            case ONLINE_GAME:
                activityName = "Web Player Online Game";
                action = EventParameters.ACTION_GAME_VIEW;
                break;
            case WEB_BROWSER:
                activityName = "Web Player Web Browser";
                action = EventParameters.ACTION_WEBSITE_VIEW;
                break;
        }
        mEventID = EventManager.getInstance().activityStart(this.getContext(), EventManager.LOG_CRITICAL_LEVEL, activityName);
        EventManager.getInstance().logEventWithDuration(this.getContext(), EventManager.LOG_NORMAL_LEVEL, WEB_PLAYER_RESOURCE_ID,
                EventManager.LOG_CLOSE_RESOURCE_LEVEL, EventParameters.CATEGORY_WEB_PLAYER,
                action, mContentItem.getName(), mContentItem.getId());
    }


    @Override
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (mWebPlayerView != null) {
            try {
                mWebPlayerView.releseAndcloseView();
            } catch (Exception ex) {
                com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, "Error when trying to onDetach: " + ex.getMessage());
            }
        }

    }
}
