package com.kidoz.sdk.api.general.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.SoundPool;
import android.os.Build;

import java.util.HashMap;

@SuppressLint("NewApi") public class SdkSoundManager
{

    private static SoundPool soundPool;
    private static HashMap<String, Integer> loadedSounds = new HashMap<String, Integer>();

    @SuppressLint("NewApi") public static void initSoundPool()
    {
        if (soundPool == null)
        {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP)
            {
                SoundPool.Builder builder = new SoundPool.Builder();
                builder.setMaxStreams(3);
                AudioAttributes.Builder atrBuilder = new AudioAttributes.Builder();
                atrBuilder.setContentType(AudioAttributes.CONTENT_TYPE_SONIFICATION);
                atrBuilder.setLegacyStreamType(AudioAttributes.CONTENT_TYPE_SONIFICATION);
                atrBuilder.setUsage(AudioAttributes.USAGE_ASSISTANCE_SONIFICATION);
                builder.setAudioAttributes(atrBuilder.build());
                soundPool = builder.build();
            }
            else
            {
                soundPool = new SoundPool(3, AudioManager.STREAM_NOTIFICATION, 0);
            }
        }

       /* soundPool.setOnLoadCompleteListener(new OnLoadCompleteListener() {
            @Override
            public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {

            }
        });*/
    }

    /**
     * Release sound manager
     */
    public static void releaseManager()
    {
        if (soundPool != null)
        {
            soundPool.release();
        }
        soundPool = null;
        loadedSounds.clear();
    }

    /**
     * Play sound from resource
     *
     * @param soundResource sound resource id
     */
    public static void playSound(Context context, int soundResource)
    {
        initSoundPool();

        if (loadedSounds != null && loadedSounds.get(soundResource) == null)
        {
            int soundID = soundPool.load(context, soundResource, 1);
            loadedSounds.put(soundResource + "", soundID);
            playLoadedSound(context, soundID);
        }
        else if (loadedSounds != null)
        {
            playLoadedSound(context, loadedSounds.get("" + soundResource));
        }
    }

    /**
     * Play sound from path
     *
     * @param path sound path
     */
    public static void playSound(Context context, String path)
    {
        initSoundPool();

        if (loadedSounds != null && loadedSounds.get(path) == null)
        {
            int soundID = soundPool.load(path, 1);
            loadedSounds.put(path, soundID);
            playLoadedSound(context, soundID);
        }
        else if (loadedSounds != null)
        {
            playLoadedSound(context, loadedSounds.get(path));
        }
    }

    private static void playLoadedSound(Context context, int sound)
    {
        AudioManager audioManager = (AudioManager) context.getSystemService(Context.AUDIO_SERVICE);
        float actualVolume = (float) audioManager.getStreamVolume(AudioManager.STREAM_SYSTEM);
        float maxVolume = (float) audioManager.getStreamMaxVolume(AudioManager.STREAM_SYSTEM);
        float volume = actualVolume / maxVolume;

        if (soundPool != null)
        {
            soundPool.play(sound, volume, volume, 1, 0, 1f);
        }
    }
}
