package com.kidoz.sdk.api.dialogs;

import android.content.Context;
import android.graphics.Color;
import android.support.v7.widget.RecyclerView;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.ViewFlipper;

import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozCardView;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.CloseButtonView;


/**
 * Created by Eugine on 9/24/2015.
 */
class ParentalLockLayoutGenerator {

    public static int PARENTAL_CARDVIEW_ID;
    public static int FEEDBACK_MESSAGE_CONTAINER_ID;
    public static int FEEDBACK_MESSAGE_TEXT_VIEW_ID;
    public static int FEEDBACK_ACTION_TEXT_VIEW_ID;
    public static int VIEW_FLIPPER_ID;
    public static int PARENTAL_DIALOG_TITLE_ID;
    public static int PARENTAL_LOCK_DIALOG_MESSAGE_TEXTVIEW_ID;
    public static int RECYCLER_VIEW_ID;
    public static int EXIT_BUTTON_ID;
    public static int ANIMATABLE_VIEW;


    public static View generateParentalLockView(Context context) {

        RelativeLayout baseContainer = new RelativeLayout(context);
        baseContainer.setBackgroundColor(Color.parseColor("#50000000"));
        RelativeLayout.LayoutParams baseParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.WRAP_CONTENT);

        baseParams.addRule(RelativeLayout.CENTER_IN_PARENT);
        FrameLayout wrapContainer = new FrameLayout(context);
        ANIMATABLE_VIEW = Utils.generateViewId();
        wrapContainer.setId(ANIMATABLE_VIEW);
        baseContainer.addView(wrapContainer, baseParams);

        // Create Card view
        KidozCardView kidozCardView = new KidozCardView(context);
        PARENTAL_CARDVIEW_ID = Utils.generateViewId();
        kidozCardView.setId(PARENTAL_CARDVIEW_ID);
        int margin = Utils.dpTOpx(context, 10);
        FrameLayout.LayoutParams frameParams = new FrameLayout.LayoutParams(FrameLayout.LayoutParams.WRAP_CONTENT, FrameLayout.LayoutParams.WRAP_CONTENT);
        frameParams.setMargins(margin, margin, margin, margin);
        wrapContainer.addView(kidozCardView, frameParams);

        // Create main outer container
        RelativeLayout outerContainer = new RelativeLayout(context);
        kidozCardView.addView(outerContainer, new FrameLayout.LayoutParams(FrameLayout.LayoutParams.MATCH_PARENT, FrameLayout.LayoutParams.WRAP_CONTENT));

        // Create main holder container
        LinearLayout mainViewContainer = new LinearLayout(context);
        outerContainer.addView(mainViewContainer, new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.WRAP_CONTENT));
        mainViewContainer.setOrientation(LinearLayout.VERTICAL);
        mainViewContainer.setGravity(Gravity.CENTER);

        //Create X close button
        CloseButtonView closeButtonView = new CloseButtonView(context, Color.parseColor("#ffffff"));
        EXIT_BUTTON_ID = Utils.generateViewId();
        closeButtonView.setId(EXIT_BUTTON_ID);
        RelativeLayout.LayoutParams relParams = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        relParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
        relParams.setMargins(0, Utils.dpTOpx(context, 5), Utils.dpTOpx(context, 5), 0);
        closeButtonView.setPadding(Utils.dpTOpx(context, 12), 0, 0, Utils.dpTOpx(context, 12));
        outerContainer.addView(closeButtonView, relParams);

        // Upper title container
        LinearLayout topContainerView = new LinearLayout(context);
        topContainerView.setOrientation(LinearLayout.HORIZONTAL);
        topContainerView.setGravity(Gravity.CENTER);

        ImageView LockIcon = new ImageView(context);
        topContainerView.addView(LockIcon, new LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.WRAP_CONTENT));

        TextView parentalLockTitle = new TextView(context);
        PARENTAL_DIALOG_TITLE_ID = Utils.generateViewId();
        parentalLockTitle.setId(PARENTAL_DIALOG_TITLE_ID);
        parentalLockTitle.setGravity(Gravity.CENTER_HORIZONTAL);
        parentalLockTitle.setMaxLines(2);
        parentalLockTitle.setMinLines(2);
        parentalLockTitle.setTextColor(Color.WHITE);
        parentalLockTitle.setTextSize(TypedValue.COMPLEX_UNIT_SP, 22);

        LinearLayout.LayoutParams linParams = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.WRAP_CONTENT);
        linParams.setMargins(Utils.dpTOpx(context, 10), 0, 0, 0);
        topContainerView.addView(parentalLockTitle, linParams);

        // Add upper container to main holder
        mainViewContainer.addView(topContainerView, new LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.WRAP_CONTENT));

        View view = new View(context);
        view.setBackgroundColor(Color.parseColor("#86e6fc"));
        linParams = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, Utils.dpTOpx(context, 1));
        linParams.setMargins(Utils.dpTOpx(context, 5), 0, Utils.dpTOpx(context, 5), 0);
        // Add line to main holder
        mainViewContainer.addView(view, linParams);

        //Parental dialog message
        TextView parentalLockDialogMesssageView = new TextView(context);
        PARENTAL_LOCK_DIALOG_MESSAGE_TEXTVIEW_ID = Utils.generateViewId();
        parentalLockDialogMesssageView.setId(PARENTAL_LOCK_DIALOG_MESSAGE_TEXTVIEW_ID);
        parentalLockDialogMesssageView.setGravity(Gravity.LEFT);
        parentalLockDialogMesssageView.setPadding(
                Utils.dpTOpx(context, 30), // Left
                Utils.dpTOpx(context, 20), // Top
                Utils.dpTOpx(context, 30), // Right
                Utils.dpTOpx(context, 20) // Bottom
        );
        parentalLockDialogMesssageView.setTextColor(Color.WHITE);
        parentalLockDialogMesssageView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 18);
        mainViewContainer.addView(parentalLockDialogMesssageView, new LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.WRAP_CONTENT));

        //View flipper
        ViewFlipper viewFlipper = new ViewFlipper(context);
        VIEW_FLIPPER_ID = Utils.generateViewId();
        viewFlipper.setId(VIEW_FLIPPER_ID);
        mainViewContainer.addView(viewFlipper, new LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.WRAP_CONTENT));

        // Recycler view
        RecyclerView customRecyclerView = new RecyclerView(context);
        RECYCLER_VIEW_ID = Utils.generateViewId();
        customRecyclerView.setId(RECYCLER_VIEW_ID);
        customRecyclerView.setClipToPadding(false);
        customRecyclerView.setOverScrollMode(RecyclerView.OVER_SCROLL_NEVER);
        customRecyclerView.setHorizontalScrollBarEnabled(false);
        customRecyclerView.setVerticalScrollBarEnabled(false);
        viewFlipper.addView(customRecyclerView, new ViewFlipper.LayoutParams(ViewFlipper.LayoutParams.MATCH_PARENT, ViewFlipper.LayoutParams.WRAP_CONTENT));

        RelativeLayout feedBackMessageContainer = new RelativeLayout(context);
        FEEDBACK_MESSAGE_CONTAINER_ID = Utils.generateViewId();
        feedBackMessageContainer.setId(FEEDBACK_MESSAGE_CONTAINER_ID);
        feedBackMessageContainer.setPadding(
                Utils.dpTOpx(context, 10), // Left
                Utils.dpTOpx(context, 20), // Top
                Utils.dpTOpx(context, 10), // Right
                Utils.dpTOpx(context, 5) // Bottom
        );

        TextView feedBackMessageView = new TextView(context);
        FEEDBACK_MESSAGE_TEXT_VIEW_ID = Utils.generateViewId();
        feedBackMessageView.setId(FEEDBACK_MESSAGE_TEXT_VIEW_ID);
        feedBackMessageView.setGravity(Gravity.CENTER);
        feedBackMessageView.setSingleLine(true);
        feedBackMessageView.setTextColor(Color.WHITE);
        feedBackMessageView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 22);

        relParams = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        relParams.addRule(RelativeLayout.CENTER_HORIZONTAL);
        relParams.setMargins(
                Utils.dpTOpx(context, 10), // Left
                0, // Top
                Utils.dpTOpx(context, 10), // Right
                0 // Bottom
        );
        feedBackMessageContainer.addView(feedBackMessageView, relParams);

        TextView feedBackActionView = new TextView(context);
        FEEDBACK_ACTION_TEXT_VIEW_ID = Utils.generateViewId();
        feedBackActionView.setId(FEEDBACK_ACTION_TEXT_VIEW_ID);
        feedBackActionView.setGravity(Gravity.CENTER);
        feedBackActionView.setTextColor(Color.WHITE);
        feedBackActionView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 22);

        relParams = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        relParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
        relParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
        relParams.setMargins(
                0, // Left
                0, // Top
                Utils.dpTOpx(context, 10), // Right
                0 // Bottom
        );
        feedBackMessageContainer.addView(feedBackActionView, relParams);

        viewFlipper.addView(feedBackMessageContainer, new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.MATCH_PARENT));

        return baseContainer;
    }

}
