package com.kidoz.sdk.api;

import android.animation.Animator;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.os.Build;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.widget.RelativeLayout;

import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.dialogs.AboutKidozDialog;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.enums.UiStyleType;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.interfaces.IOnPanelViewEventListener;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_BUTTON_TYPE;
import com.kidoz.sdk.api.ui_views.panel_view.PanelButton;
import com.kidoz.sdk.api.ui_views.panel_view.PanelSliderView;
import com.kidoz.sdk.api.ui_views.panel_view.PanelViewListener;


public class PanelView extends RelativeLayout
{
    private final String TAG = PanelView.class.getSimpleName();
    private RelativeLayout mRootView;
    private RelativeLayout mContainer;
    private com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE mPanelType;
    private com.kidoz.sdk.api.ui_views.panel_view.HANDLE_POSITION mHandlePosition;
    private PanelSliderView mPanelSliderView;
    private ContentLogicLoader mContentLogicLoader;
    private PanelButton mHandleButton;
    private PanelButton mParentalLockButton;
    private PanelButton mAboutKidozButton;
    private PanelViewListener mPanelViewListener;
    private IOnPanelViewEventListener mIOnPanelViewEventListener;
    private boolean mIsOpen;
    private boolean mIsAnimationRunning;
    private boolean mIsClicksBlocked;

    public PanelView(Context context)
    {
        super(context);
        initView();
    }

    public PanelView(Context context, AttributeSet attrs)
    {
        super(context, attrs);
        initView();
    }

    public PanelView(Context context, AttributeSet attrs, int defStyleAttr)
    {
        super(context, attrs, defStyleAttr);
        initView();
    }

    private void initView()
    {
        initPanelTypeAndHandlePosition();
        initRootView();
        initContainer();
        initHandleButton();
        initParentalLockButton();
        initAboutKidozkButton();
        initPanelSliderView();
        initPanelViewsRules();
        initContentLogicLoader();
        preparePanel();
    }

    private void initRootView()
    {
        mRootView = new RelativeLayout(getContext());
        mRootView.setBackgroundColor(Color.TRANSPARENT);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);
        addView(mRootView, params);
    }

    private void initContainer()
    {
        mContainer = new RelativeLayout(getContext());
        mContainer.setBackgroundColor(Color.TRANSPARENT);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mRootView.addView(mContainer, params);
    }

    private void initHandleButton()
    {
        mHandleButton = new PanelButton(getContext(), mPanelType, com.kidoz.sdk.api.ui_views.panel_view.PANEL_BUTTON_TYPE.HANDLE_OPEN, new PanelButton.PanelButtonListener()
        {
            @Override public void onClickStarted()
            {

            }

            @Override public void onClickEnd()
            {
                toggleAnimation();
            }
        });
        mHandleButton.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mContainer.addView(mHandleButton, params);
    }

    private void initParentalLockButton()
    {
        mParentalLockButton = new PanelButton(getContext(), mPanelType, com.kidoz.sdk.api.ui_views.panel_view.PANEL_BUTTON_TYPE.PARENTAL_LOCK, new PanelButton.PanelButtonListener()
        {
            @Override public void onClickStarted()
            {

            }

            @Override public void onClickEnd()
            {
                if (mIsClicksBlocked == false)
                {
                    mIsClicksBlocked = true;
                    if (ParentalLockDialog.getIsCanShowDialog(getContext()) == true)
                    {
                        int[] popLocation = new int[2];
                        popLocation[0] = (int) (ScreenUtils.getScreenSize(getContext(), true) * 0.5f);
                        popLocation[1] = (int) (ScreenUtils.getScreenSize(getContext(), false) * 0.5f);
                        ParentalLockDialog parentalLockDialog = new ParentalLockDialog(getContext(), false, popLocation);
                        parentalLockDialog.setOnDismissListener(new DialogInterface.OnDismissListener()
                        {
                            @Override public void onDismiss(DialogInterface dialog)
                            {
                                //Refresh the parental lock icon
                                boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
                                mParentalLockButton.setIsLockActive(isLockActive);
                                mIsClicksBlocked = false;
                            }
                        });
                        parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener()
                        {
                            @Override public void onPasswordEntered(boolean isPasswordCorrect)
                            {
                                boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
                                mParentalLockButton.setIsLockActive(isLockActive);
                            }
                        });
                        parentalLockDialog.show();
                    }
                    else
                    {
                        mIsClicksBlocked = false;
                    }
                }
            }
        });
        mParentalLockButton.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mContainer.addView(mParentalLockButton, params);
        boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
        mParentalLockButton.setIsLockActive(isLockActive);
    }

    private void initAboutKidozkButton()
    {
        mAboutKidozButton = new PanelButton(getContext(), mPanelType, com.kidoz.sdk.api.ui_views.panel_view.PANEL_BUTTON_TYPE.ABOUT_KIDOZ, new PanelButton.PanelButtonListener()
        {
            @Override public void onClickStarted()
            {

            }

            @Override public void onClickEnd()
            {
                int[] popLocation = new int[2];
                popLocation[0] = (int) (ScreenUtils.getScreenSize(getContext(), true) * 0.5f);
                popLocation[1] = (int) (ScreenUtils.getScreenSize(getContext(), false) * 0.5f);
                AboutKidozDialog aboutKidozDialog = new AboutKidozDialog(getContext(), popLocation);
                aboutKidozDialog.openDialog();
            }
        });
        mAboutKidozButton.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mContainer.addView(mAboutKidozButton, params);
    }

    private void initPanelSliderView()
    {
        mPanelSliderView = new PanelSliderView(getContext());
        mPanelSliderView.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());
        mPanelSliderView.setBackgroundColor(Color.WHITE);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mContainer.addView(mPanelSliderView, params);

        mPanelViewListener = new PanelViewListener()
        {
            @Override public void onItemClick(ContentItem contentItem, int position)
            {
                ContentExecutionHandler.handleContentItemClick(getContext(), contentItem, position, true);
            }
        };
        mPanelSliderView.setPanelViewListener(mPanelViewListener);
    }

    private void preparePanel()
    {
        mIsOpen = true;
        mIsAnimationRunning = true;
        Utils.setOnGlobalLayoutFinishListener(mRootView, new Utils.OnGlobalLayoutFinishedListener()
        {
            @Override public void onLayoutFinished()
            {
                GenAnimator.playShrinkAnimation(mHandleButton, 0, null);
                GenAnimator.playShrinkAnimation(mParentalLockButton, 0, new Animator.AnimatorListener()
                {
                    @Override public void onAnimationStart(Animator animation)
                    {

                    }

                    @Override public void onAnimationEnd(Animator animation)
                    {
                        mParentalLockButton.setVisibility(View.INVISIBLE);
                    }

                    @Override public void onAnimationCancel(Animator animation)
                    {

                    }

                    @Override public void onAnimationRepeat(Animator animation)
                    {

                    }
                });
                GenAnimator.playShrinkAnimation(mAboutKidozButton, 0, new Animator.AnimatorListener()
                {
                    @Override public void onAnimationStart(Animator animation)
                    {

                    }

                    @Override public void onAnimationEnd(Animator animation)
                    {
                        mAboutKidozButton.setVisibility(View.INVISIBLE);
                    }

                    @Override public void onAnimationCancel(Animator animation)
                    {

                    }

                    @Override public void onAnimationRepeat(Animator animation)
                    {

                    }
                });
                GenAnimator.closePanelView(mContainer, 200, mPanelSliderView, mPanelType, new Animator.AnimatorListener()
                {
                    @Override public void onAnimationStart(Animator animation)
                    {
                        GenAnimator.animateHandleClose(mHandleButton, null);
                    }

                    @Override public void onAnimationEnd(Animator animation)
                    {
                        mHandleButton.setPanelButtonType(PANEL_BUTTON_TYPE.HANDLE_OPEN);
                        GenAnimator.playGrowAnimation(mHandleButton, 350, 500, new Animator.AnimatorListener()
                        {
                            @Override public void onAnimationStart(Animator animation)
                            {
                            }

                            @Override public void onAnimationEnd(Animator animation)
                            {
                                mIsOpen = false;
                                mIsAnimationRunning = false;
                            }

                            @Override public void onAnimationCancel(Animator animation)
                            {

                            }

                            @Override public void onAnimationRepeat(Animator animation)
                            {

                            }
                        });
                    }

                    @Override public void onAnimationCancel(Animator animation)
                    {

                    }

                    @Override public void onAnimationRepeat(Animator animation)
                    {

                    }
                });
            }
        });
    }

    private void initPanelTypeAndHandlePosition()
    {
        mPanelType = com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE.BOTTOM;
        mHandlePosition = com.kidoz.sdk.api.ui_views.panel_view.HANDLE_POSITION.START;
        if (Build.VERSION.SDK_INT >= 16)
        {
            int gravity = getGravity();
            switch (gravity)
            {
                case Gravity.LEFT:
                {
                    mPanelType = com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE.LEFT;
                    break;
                }
                case Gravity.TOP:
                {
                    mPanelType = com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE.TOP;
                    break;
                }
                case Gravity.RIGHT:
                {
                    mPanelType = com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE.RIGHT;
                    break;
                }
                case Gravity.BOTTOM:
                {
                    mPanelType = com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE.BOTTOM;
                    break;
                }
            }
        }
    }

    private void initPanelViewsRules()
    {
        RelativeLayout.LayoutParams containerParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mContainer.setLayoutParams(containerParams);

        RelativeLayout.LayoutParams sliderParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mPanelSliderView.setLayoutParams(sliderParams);

        RelativeLayout.LayoutParams handleParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mHandleButton.setLayoutParams(handleParams);

        RelativeLayout.LayoutParams parentalLockParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mParentalLockButton.setLayoutParams(parentalLockParams);

        RelativeLayout.LayoutParams aboutKidozParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mAboutKidozButton.setLayoutParams(aboutKidozParams);

        int margin = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(getContext(), 6);
        switch (mPanelType)
        {
            case LEFT:
            {
                mPanelSliderView.setPanelType(com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE.LEFT);
                sliderParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                sliderParams.width = LayoutParams.WRAP_CONTENT;
                sliderParams.height = LayoutParams.MATCH_PARENT;

                handleParams.addRule(RelativeLayout.RIGHT_OF, mPanelSliderView.getId());
                aboutKidozParams.addRule(RelativeLayout.RIGHT_OF, mPanelSliderView.getId());
                parentalLockParams.addRule(RelativeLayout.RIGHT_OF, mPanelSliderView.getId());
                switch (mHandlePosition)
                {
                    case START:
                    {
                        handleParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                        handleParams.topMargin = margin;

                        aboutKidozParams.addRule(RelativeLayout.ALIGN_BOTTOM, mPanelSliderView.getId());
                        aboutKidozParams.bottomMargin = margin;

                        parentalLockParams.addRule(RelativeLayout.ABOVE, mAboutKidozButton.getId());
                        parentalLockParams.bottomMargin = margin;
                        break;
                    }
                    case CENTER:
                    {
                        handleParams.addRule(RelativeLayout.CENTER_VERTICAL);

                        aboutKidozParams.addRule(RelativeLayout.ALIGN_BOTTOM, mPanelSliderView.getId());
                        aboutKidozParams.bottomMargin = margin;

                        parentalLockParams.addRule(RelativeLayout.ABOVE, mAboutKidozButton.getId());
                        parentalLockParams.bottomMargin = margin;
                        break;
                    }
                    case END:
                    {
                        handleParams.addRule(RelativeLayout.ALIGN_BOTTOM, mPanelSliderView.getId());
                        handleParams.bottomMargin = margin;

                        parentalLockParams.addRule(RelativeLayout.ALIGN_TOP, mPanelSliderView.getId());
                        parentalLockParams.topMargin = margin;

                        aboutKidozParams.addRule(RelativeLayout.BELOW, mParentalLockButton.getId());
                        aboutKidozParams.topMargin = margin;
                        break;
                    }
                }
                containerParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                break;
            }
            case TOP:
            {
                mPanelSliderView.setPanelType(com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE.TOP);
                sliderParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                sliderParams.width = LayoutParams.MATCH_PARENT;
                sliderParams.height = LayoutParams.WRAP_CONTENT;

                handleParams.addRule(RelativeLayout.BELOW, mPanelSliderView.getId());
                aboutKidozParams.addRule(RelativeLayout.BELOW, mPanelSliderView.getId());
                parentalLockParams.addRule(RelativeLayout.BELOW, mPanelSliderView.getId());
                switch (mHandlePosition)
                {
                    case START:
                    {
                        handleParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                        handleParams.leftMargin = margin;

                        aboutKidozParams.addRule(RelativeLayout.ALIGN_RIGHT, mPanelSliderView.getId());
                        aboutKidozParams.rightMargin = margin;

                        parentalLockParams.addRule(RelativeLayout.LEFT_OF, mAboutKidozButton.getId());
                        parentalLockParams.rightMargin = margin;
                        break;
                    }
                    case CENTER:
                    {
                        handleParams.addRule(RelativeLayout.CENTER_HORIZONTAL);

                        parentalLockParams.addRule(RelativeLayout.ALIGN_LEFT, mPanelSliderView.getId());
                        parentalLockParams.leftMargin = margin;

                        aboutKidozParams.addRule(RelativeLayout.RIGHT_OF, mParentalLockButton.getId());
                        aboutKidozParams.leftMargin = margin;
                        break;
                    }
                    case END:
                    {
                        handleParams.addRule(RelativeLayout.ALIGN_RIGHT, mPanelSliderView.getId());
                        handleParams.rightMargin = margin;

                        parentalLockParams.addRule(RelativeLayout.ALIGN_LEFT, mPanelSliderView.getId());
                        parentalLockParams.leftMargin = margin;

                        aboutKidozParams.addRule(RelativeLayout.RIGHT_OF, mParentalLockButton.getId());
                        aboutKidozParams.leftMargin = margin;
                        break;
                    }
                }

                containerParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                break;
            }
            case RIGHT:
            {
                mPanelSliderView.setPanelType(com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE.RIGHT);
                sliderParams.addRule(RelativeLayout.RIGHT_OF, mHandleButton.getId());
                sliderParams.width = LayoutParams.WRAP_CONTENT;
                sliderParams.height = LayoutParams.MATCH_PARENT;

                handleParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                aboutKidozParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                parentalLockParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                switch (mHandlePosition)
                {
                    case START:
                    {
                        handleParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                        handleParams.topMargin = margin;

                        aboutKidozParams.addRule(RelativeLayout.ALIGN_BOTTOM, mPanelSliderView.getId());
                        aboutKidozParams.bottomMargin = margin;

                        parentalLockParams.addRule(RelativeLayout.ABOVE, mAboutKidozButton.getId());
                        parentalLockParams.bottomMargin = margin;
                        break;
                    }
                    case CENTER:
                    {
                        handleParams.addRule(RelativeLayout.CENTER_VERTICAL);

                        aboutKidozParams.addRule(RelativeLayout.ALIGN_BOTTOM, mPanelSliderView.getId());
                        aboutKidozParams.bottomMargin = margin;

                        parentalLockParams.addRule(RelativeLayout.ABOVE, mAboutKidozButton.getId());
                        parentalLockParams.bottomMargin = margin;
                        break;
                    }
                    case END:
                    {
                        handleParams.addRule(RelativeLayout.ALIGN_BOTTOM, mPanelSliderView.getId());
                        handleParams.bottomMargin = margin;

                        parentalLockParams.addRule(RelativeLayout.ALIGN_TOP, mPanelSliderView.getId());
                        parentalLockParams.topMargin = margin;

                        aboutKidozParams.addRule(RelativeLayout.BELOW, mParentalLockButton.getId());
                        aboutKidozParams.topMargin = margin;
                        break;
                    }
                }

                containerParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                break;
            }
            case BOTTOM:
            {
                mPanelSliderView.setPanelType(com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE.BOTTOM);
                sliderParams.addRule(RelativeLayout.BELOW, mHandleButton.getId());
                sliderParams.width = LayoutParams.MATCH_PARENT;
                sliderParams.height = LayoutParams.WRAP_CONTENT;

                handleParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                aboutKidozParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                parentalLockParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                switch (mHandlePosition)
                {
                    case START:
                    {
                        handleParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                        handleParams.leftMargin = margin;

                        aboutKidozParams.addRule(RelativeLayout.ALIGN_RIGHT, mPanelSliderView.getId());
                        aboutKidozParams.rightMargin = margin;

                        parentalLockParams.addRule(RelativeLayout.LEFT_OF, mAboutKidozButton.getId());
                        parentalLockParams.rightMargin = margin;
                        break;
                    }
                    case CENTER:
                    {
                        handleParams.addRule(RelativeLayout.CENTER_HORIZONTAL);

                        aboutKidozParams.addRule(RelativeLayout.ALIGN_RIGHT, mPanelSliderView.getId());
                        aboutKidozParams.rightMargin = margin;

                        parentalLockParams.addRule(RelativeLayout.LEFT_OF, mAboutKidozButton.getId());
                        parentalLockParams.rightMargin = margin;
                        break;
                    }
                    case END:
                    {
                        handleParams.addRule(RelativeLayout.ALIGN_RIGHT, mPanelSliderView.getId());
                        handleParams.rightMargin = margin;

                        parentalLockParams.addRule(RelativeLayout.ALIGN_LEFT, mPanelSliderView.getId());
                        parentalLockParams.leftMargin = margin;

                        aboutKidozParams.addRule(RelativeLayout.RIGHT_OF, mParentalLockButton.getId());
                        aboutKidozParams.leftMargin = margin;
                        break;
                    }
                }

                containerParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                break;
            }
        }
    }

    private void initContentLogicLoader()
    {
        mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback()
        {
            @Override public void onDataReady(ContentData contentData)
            {
                if (contentData != null)
                {
                    mPanelSliderView.setContent(contentData.getContentDataItems());
                }
            }
        });
    }

    private void toggleAnimation()
    {
        if (mIsOpen == true)
        {
            collapsePanelView();
        }
        else
        {
            expandPanelView();
        }
    }

    public void collapsePanelView()
    {
        if (mIsAnimationRunning == false && mIsOpen == true)
        {
            GenAnimator.closePanelView(mContainer, 200, mPanelSliderView, mPanelType, new Animator.AnimatorListener()
            {
                @Override public void onAnimationStart(Animator animation)
                {
                    GenAnimator.animateHandleClose(mHandleButton, null);
                    GenAnimator.playShrinkAnimation(mParentalLockButton, 350, new Animator.AnimatorListener()
                    {
                        @Override public void onAnimationStart(Animator animation)
                        {

                        }

                        @Override public void onAnimationEnd(Animator animation)
                        {
                            mParentalLockButton.setVisibility(View.INVISIBLE);
                        }

                        @Override public void onAnimationCancel(Animator animation)
                        {

                        }

                        @Override public void onAnimationRepeat(Animator animation)
                        {

                        }
                    });
                    GenAnimator.playShrinkAnimation(mAboutKidozButton, 350, new Animator.AnimatorListener()
                    {
                        @Override public void onAnimationStart(Animator animation)
                        {

                        }

                        @Override public void onAnimationEnd(Animator animation)
                        {
                            mAboutKidozButton.setVisibility(View.INVISIBLE);
                        }

                        @Override public void onAnimationCancel(Animator animation)
                        {

                        }

                        @Override public void onAnimationRepeat(Animator animation)
                        {

                        }
                    });
                }

                @Override public void onAnimationEnd(Animator animation)
                {
                    mHandleButton.setPanelButtonType(PANEL_BUTTON_TYPE.HANDLE_OPEN);
                    mPanelSliderView.clearContent();
                    mIsOpen = false;
                    mIsAnimationRunning = false;
                    if (mIOnPanelViewEventListener != null)
                    {
                        mIOnPanelViewEventListener.onPanelViewCollapsed();
                    }
                }

                @Override public void onAnimationCancel(Animator animation)
                {

                }

                @Override public void onAnimationRepeat(Animator animation)
                {

                }
            });
        }
    }

    public void expandPanelView()
    {
        if (mIsAnimationRunning == false && mIsOpen == false)
        {
            // Send log
            EventManager.getInstance().logEvent(getContext(), EventManager.LOG_CRITICAL_LEVEL, EventParameters.CATEGORY_SPONSORED_CONTENT, EventParameters.ACTION_WIDGET_VIEW, EventParameters.PANEL_VIEW);

            //Refresh the parental lock icon
            boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
            mParentalLockButton.setIsLockActive(isLockActive);

            GenAnimator.openPanelView(mContainer, mPanelSliderView, mPanelType, new Animator.AnimatorListener()
            {
                @Override public void onAnimationStart(Animator animation)
                {
                    GenAnimator.animateHandleOpen(mHandleButton, null);
                    mContentLogicLoader.loadContent(getContext(), UiStyleType.FEED_VIEW_STYLE);
                }

                @Override public void onAnimationEnd(Animator animation)
                {
                    mHandleButton.setPanelButtonType(PANEL_BUTTON_TYPE.HANDLE_CLOSE);
                    mIsOpen = true;
                    mIsAnimationRunning = false;
                    GenAnimator.playGrowAnimation(mParentalLockButton, 120, 0, new Animator.AnimatorListener()
                    {
                        @Override public void onAnimationStart(Animator animation)
                        {
                            mParentalLockButton.setVisibility(View.VISIBLE);
                        }

                        @Override public void onAnimationEnd(Animator animation)
                        {

                        }

                        @Override public void onAnimationCancel(Animator animation)
                        {

                        }

                        @Override public void onAnimationRepeat(Animator animation)
                        {

                        }
                    });
                    GenAnimator.playGrowAnimation(mAboutKidozButton, 120, 125, new Animator.AnimatorListener()
                    {
                        @Override public void onAnimationStart(Animator animation)
                        {
                            mAboutKidozButton.setVisibility(View.VISIBLE);
                        }

                        @Override public void onAnimationEnd(Animator animation)
                        {

                        }

                        @Override public void onAnimationCancel(Animator animation)
                        {

                        }

                        @Override public void onAnimationRepeat(Animator animation)
                        {

                        }
                    });
                    if (mIOnPanelViewEventListener != null)
                    {
                        mIOnPanelViewEventListener.onPanelViewExpanded();
                    }
                }

                @Override public void onAnimationCancel(Animator animation)
                {

                }

                @Override public void onAnimationRepeat(Animator animation)
                {

                }
            });
        }
    }

    public void setPanelConfiguration(com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE panelType, com.kidoz.sdk.api.ui_views.panel_view.HANDLE_POSITION handlePosition)
    {
        mPanelType = panelType;
        mHandlePosition = handlePosition;
        initPanelViewsRules();
    }

    public void setOnPanelViewEventListener(IOnPanelViewEventListener iOnPanelViewEventListener)
    {
        mIOnPanelViewEventListener = iOnPanelViewEventListener;
    }
}
