package com.kidoz.events;

import android.app.IntentService;
import android.content.Intent;

import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.server_connect.ResultData;
import com.kidoz.sdk.api.server_connect.SdkAPIManager;
import com.kidoz.sdk.api.structure.IsEventRecord;


public class SyncEventService extends IntentService
{

	public static final String SYNC_TYPE_KEY = "SYNC_TYPE_KEY";
	public static final int SYNC_EVENTS = 1;
	public static final int UPDATE_INSTALL_EVENT = 2;


	public static final String TAG = SyncEventService.class.getSimpleName();

	public SyncEventService()
	{
		super("LogIntentService");
	}

	// Sync definitions
	private static final int NUM_OF_RETRIES_IN_CASE_FAILED = 1;
	private static final int MAX_TIME_TO_ALLOW_SYNC_TO_RUN = 1000 * 60 * 15; // Safety mechanize to shutdown the sync thread if it runs too long ,witch means that something is wrong

	private boolean mSyncRunning = false;
	private boolean mContinueSyncProcces;

	private int munOfRetriesInCaseFailedCount = NUM_OF_RETRIES_IN_CASE_FAILED;
	private long mServiceSyncStartTime;

	// Update install definitions
	public static final int MAX_ACCEPTABLE_INSTALL_INTERVAL = 2* 24 * 60 * 60 * 1000;  // 24 hours
	public static final String PACKAGE_NAME_KEY = "packageNameKey";

	@Override
	protected void onHandleIntent(Intent intent)
	{
		com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>> SyncEventService : onHandleIntent");
		if(intent != null) {
			if(intent.hasExtra(SYNC_TYPE_KEY)) {
				int type = intent.getIntExtra(SYNC_TYPE_KEY,SYNC_EVENTS);
				if(type == UPDATE_INSTALL_EVENT) {
					updateInstallEvent(intent);
				}else {
					syncEvents(intent);
				}

			}else {
				syncEvents(intent);
			}
		}
	}


	/** Update install on click event */
	private void updateInstallEvent(Intent intent) {

		com.kidoz.sdk.api.general.utils.SDKLogger.printWarningLog(" ----------------------  ******************************  ----------------------");
		com.kidoz.sdk.api.general.utils.SDKLogger.printWarningLog(" -----------------    START UPDATE CLICK ON INSTALL EVENT ---------------------");
		com.kidoz.sdk.api.general.utils.SDKLogger.printWarningLog(" ----------------------  ******************************  ----------------------");

		String packageName = null;
		if (intent != null)
		{
			packageName = intent.getStringExtra(PACKAGE_NAME_KEY);
			if (packageName != null)
			{
				DatabaseManager databaseManager = DatabaseManager.getInstance(getApplicationContext());
				if(databaseManager != null) {
					IsEventRecord record = databaseManager.getIsEventTable().getRecord(packageName);
					if(record != null) {
						long setTime = -1;
						try {
							setTime = Long.parseLong(record.getTimeStamp());
						} catch (NumberFormatException e) {
							setTime = -1;
						}

						if(setTime != -1 && ((System.currentTimeMillis() -  setTime) < MAX_ACCEPTABLE_INSTALL_INTERVAL)) {

							// Send event
							EventManager.getInstance().logSponsoredContentInstallEvent(getApplicationContext(), record.getPackageName(), record.getAdvertiserId(),  record.getPackageName(),record.getPositionIndex());

							// Send event
							com.kidoz.sdk.api.general.utils.SDKLogger.printWarningLog("!!!!!!!! SEND ANALYTICS EVENT OF APPLICATION INSTALLED !!!!!!! ");
							com.kidoz.sdk.api.general.utils.SDKLogger.printWarningLog("getPackageName : " + record.getPackageName());
							com.kidoz.sdk.api.general.utils.SDKLogger.printWarningLog("getTimeStamp : " + record.getTimeStamp());
							com.kidoz.sdk.api.general.utils.SDKLogger.printWarningLog("getItemType : " + record.getContentType());
							com.kidoz.sdk.api.general.utils.SDKLogger.printWarningLog("getLocationInFeed : " + record.getPositionIndex());
							com.kidoz.sdk.api.general.utils.SDKLogger.printWarningLog("getApppName : " + record.getName());
							com.kidoz.sdk.api.general.utils.SDKLogger.printWarningLog("getAdvertiser ID : " + record.getAdvertiserId());
						}
						databaseManager.getIsEventTable().deleteRecord(packageName);
					}
				}
			}
		}
	}

	/** Sync events to server */
	private void syncEvents(Intent intent) {
		// Stop event sending by specific request
		if (intent != null && intent.hasExtra(EventManager.STOP_SERVICE_EXTRA))
		{
			mSyncRunning = false;
			mContinueSyncProcces = false;
		}

		if (mSyncRunning == false)
		{
			com.kidoz.sdk.api.general.utils.SDKLogger.printWarningLog(" ----------------------  ******************************  ----------------------");
			com.kidoz.sdk.api.general.utils.SDKLogger.printWarningLog(" -----------------  START SYNCHRONIZATION OF LOG EVENTS DATA  V4.0 ----------------------");
			com.kidoz.sdk.api.general.utils.SDKLogger.printWarningLog(" ----------------------  ******************************  ----------------------");

			mSyncRunning = true;
			mContinueSyncProcces = true;
			mServiceSyncStartTime = System.currentTimeMillis();
			com.kidoz.sdk.api.general.utils.SDKLogger.printInfoLog("Log Events info:"+ mSyncRunning + " , " + mContinueSyncProcces);
			while (EventManager.getInstance().getIsCanSendLog(this) && isAllowedToRunTimeFrame() && mContinueSyncProcces)
			{
				com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog( ">>>> SyncEventService : sending logs");
				EventBulk bulk = EventManager.getInstance().getNextBulk(this);
				com.kidoz.sdk.api.general.utils.SDKLogger.printInfoLog("Log Events Sync info : bulk value:" + bulk.toString());
				if (bulk != null)
				{
					String json = bulk.toString();
					if (json != null)
					{
						ResultData<Boolean> resultCallback =  SdkAPIManager.getSdkApiInstance(SyncEventService.this).sendKidozEventsToServerNotAsync(json);
						if (resultCallback != null && resultCallback.getResponseStatus().getIsSuccessful())
						{
							EventManager.getInstance().removeBulkFromDB(this, bulk);
							munOfRetriesInCaseFailedCount = NUM_OF_RETRIES_IN_CASE_FAILED;
						}
						else
						{
							if (munOfRetriesInCaseFailedCount > 0)
							{
								com.kidoz.sdk.api.general.utils.SDKLogger.printInfoLog(TAG, "Log Events Sync Info : Server response failed ! Trying again...");
								munOfRetriesInCaseFailedCount--;
							}
							else
							{
								break;
							}
						}
					}
					else
					{
						com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Log Events Sync Error : Couldnt create JSON representation of an Events BULK !");
						break;
					}
				}
				else
				{
					com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Log Events Sync Error : Events BULK object is NULL !");
					break;
				}
			}
		}

		mSyncRunning = false;
	}


	public boolean isAllowedToRunTimeFrame()
	{
		return (System.currentTimeMillis() - mServiceSyncStartTime) < MAX_TIME_TO_ALLOW_SYNC_TO_RUN;
	}

	@Override
	public void onDestroy()
	{
		mContinueSyncProcces = false;
		super.onDestroy();
	}
}
