package com.kidoz.events;

import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/**
 * Created by orikam on 8/24/15.
 */
public class Event
{
    private final String TAG = Event.class.getName();
    private SimpleDateFormat mSimpleDateFormat;
    private JSONObject mJsonObject;
    private String mRowID;
    private int mLogLevel;
    private int mCloseLevel;
    private int mResourceID;
    private long mCreationTime;
    public Event()
    {
        mJsonObject = new JSONObject();
        mSimpleDateFormat = new SimpleDateFormat("yy-MM-dd HH:mm:ss", Locale.getDefault());
        mSimpleDateFormat.setTimeZone(TimeZone.getDefault());
        mCreationTime = System.currentTimeMillis();
        String logTimeUTC = String.valueOf(mCreationTime);
        String logTimeLocal = mSimpleDateFormat.format(new Date(System.currentTimeMillis()));
        try
        {
            mJsonObject.put(EventParameters.LOG_TIME_UTC, logTimeUTC);
            mJsonObject.put(EventParameters.LOG_TIME_LOCAL, logTimeLocal);
        }
        catch (Exception ex)
        {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to add parameters to JsonObject: " + ex.getMessage());
        }

    }

    public void addParameterToJsonObject(String key, String value)
    {
        try
        {
            if (key != null && value != null)
            {
                mJsonObject.put(key, value);
            }
        }
        catch (Exception ex)
        {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to add parameter to JsonObject: " + ex.getMessage());
        }
    }

    public void addParameterToJsonObject(String key, int value)
    {
        try
        {
            mJsonObject.put(key,value);
        }
        catch (Exception ex)
        {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to add parameter to JsonObject: " + ex.getMessage());
        }
    }

    public void addParameterToJsonObject(String key, long value)
    {
        try
        {
            mJsonObject.put(key,value);
        }
        catch (Exception ex)
        {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to add parameter to JsonObject: " + ex.getMessage());
        }
    }

    public void setJsonObject(JSONObject jsonObject)
    {
        mJsonObject = jsonObject;
    }

    public JSONObject getJSONObject()
    {
        return mJsonObject;
    }

    public void setRowID(String rowID)
    {
        mRowID = rowID;
    }

    public String getRowID()
    {
        return mRowID;
    }

    public void setLogLevel(int logLevel) { mLogLevel = logLevel;}

    public int getLogLevel() {return mLogLevel;}

    public void setCloseLevel(int closeLevel) {mCloseLevel = closeLevel;}

    public int getCloseLevel() {return mCloseLevel;}

    public void setResourceID(int resourceID) {mResourceID = resourceID;}

    public int getResourceID() {return mResourceID;}

    public long getEventCreationTime() {return mCreationTime;}

    public void printData()
    {
        com.kidoz.sdk.api.general.utils.SDKLogger.printInfoLog(TAG, "*** KidozEvent ***");
        com.kidoz.sdk.api.general.utils.SDKLogger.printInfoLog(TAG, "Row ID = " + mRowID);
        com.kidoz.sdk.api.general.utils.SDKLogger.printInfoLog(TAG, "JsonObject= " + mJsonObject.toString());
    }
}//end class Event
