/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.parental_lock;

import android.animation.Animator;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.custom_recycler_view.CustomRecyclerView;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.utils.AnimationsUtils;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.picasso_related.PicassoOk;
import com.kidoz.sdk.api.structure.LockIconData;
import java.io.File;
import java.util.ArrayList;

public class LockIconsAdapter
extends CustomRecyclerView.Adapter<ViewHolder>
implements View.OnClickListener {
    private final String TAG = LockIconsAdapter.class.getSimpleName();
    private final int POP_UP_ANIMATION_DURATION = 40;
    private ArrayList<LockIconData> mContent;
    private int mItemSize;
    private boolean mIsCanClick = true;
    private LockIconAdapterListener mLockIconAdapterListener;
    private int mLastPosition = -1;
    private AccelerateInterpolator mAnimationInterpolator;
    private Handler mHandler = new Handler();

    public LockIconsAdapter() {
        this.mContent = new ArrayList();
        this.mAnimationInterpolator = new AccelerateInterpolator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setContent(ArrayList<LockIconData> content) {
        LockIconsAdapter lockIconsAdapter = this;
        synchronized (lockIconsAdapter) {
            if (content != null) {
                this.mLastPosition = -1;
                if (this.mContent.isEmpty()) {
                    this.mContent.clear();
                    this.mContent.addAll(content);
                    this.notifyItemRangeInserted(0, this.getItemCount());
                    this.notifyItemRangeChanged(0, this.getItemCount());
                } else {
                    this.mContent.clear();
                    this.mContent.addAll(content);
                    this.notifyDataSetChanged();
                }
            }
        }
    }

    @Override
    public int getItemCount() {
        int result = 0;
        if (this.mContent != null) {
            result = this.mContent.size();
        }
        return result;
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int arg1) {
        this.mItemSize = parent.getWidth() / 4;
        RelativeLayout convertView = new RelativeLayout(parent.getContext());
        CustomRecyclerView.LayoutParams params = new CustomRecyclerView.LayoutParams(-1, -1);
        convertView.setLayoutParams((ViewGroup.LayoutParams)params);
        ViewHolder viewHolder = new ViewHolder(convertView);
        viewHolder.mRootView.setOnClickListener((View.OnClickListener)this);
        viewHolder.mRootView.setTag((Object)viewHolder);
        return viewHolder;
    }

    @Override
    public void onBindViewHolder(final ViewHolder viewHolder, int position) {
        LockIconData lockIconData = this.mContent.get(position);
        if (lockIconData != null) {
            this.fixItemSize(viewHolder);
            this.loadLockIcon(viewHolder, lockIconData);
        }
        if (position > this.mLastPosition) {
            long delay = position * 40;
            viewHolder.mRootView.setVisibility(4);
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    GenAnimator.recycleItemAnimation((View)viewHolder.mRootView, new GenAnimator.ViewAnimationListener(){

                        @Override
                        public void onAnimationEnd() {
                        }

                        @Override
                        public void onAnimationStart() {
                            viewHolder.mRootView.setVisibility(0);
                        }
                    });
                }
            }, delay);
            this.mLastPosition = position;
        } else {
            viewHolder.mRootView.clearAnimation();
            viewHolder.mRootView.setVisibility(0);
        }
    }

    private void fixItemSize(ViewHolder viewHolder) {
        ((ViewHolder)viewHolder).mRootView.getLayoutParams().height = this.mItemSize;
        ((ViewHolder)viewHolder).mRootView.getLayoutParams().width = this.mItemSize;
    }

    private void loadLockIcon(ViewHolder viewHolder, LockIconData lockIconData) {
        if (viewHolder != null && lockIconData != null) {
            try {
                File dir = viewHolder.mRootView.getContext().getFilesDir();
                File imageFile = new File(dir, lockIconData.getIconURL());
                PicassoOk.getPicasso(viewHolder.mLockIconImageView.getContext()).load(imageFile).into(viewHolder.mLockIconImageView);
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(this.TAG, "Error when trying to load lock icon: " + ex.getMessage());
            }
        }
    }

    public void onClick(final View view) {
        if (this.mIsCanClick) {
            this.mIsCanClick = false;
            AnimationsUtils.animateClick(view, new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    ViewHolder viewHolder = (ViewHolder)view.getTag();
                    int position = viewHolder.getAdapterPosition();
                    if (position == -1) {
                        position = viewHolder.getPosition();
                    }
                    if (position != -1 && LockIconsAdapter.this.mLockIconAdapterListener != null) {
                        LockIconsAdapter.this.mLockIconAdapterListener.onLockIconClick(position);
                    }
                    LockIconsAdapter.this.mIsCanClick = true;
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            }, 50, 100);
        }
    }

    public void setLockIconAdapterListener(LockIconAdapterListener lockIconAdapterListener) {
        this.mLockIconAdapterListener = lockIconAdapterListener;
    }

    public static interface LockIconAdapterListener {
        public void onLockIconClick(int var1);
    }

    public class ViewHolder
    extends CustomRecyclerView.ViewHolder {
        private RelativeLayout mRootView;
        private ImageView mLockIconImageView;

        public ViewHolder(RelativeLayout rootView) {
            int margin;
            super((View)rootView);
            this.mRootView = rootView;
            this.mRootView.setSoundEffectsEnabled(false);
            this.mLockIconImageView = new ImageView(this.mRootView.getContext());
            this.mLockIconImageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
            params.addRule(13);
            params.leftMargin = margin = Utils.dpTOpx(this.mRootView.getContext(), 5);
            params.topMargin = margin;
            params.rightMargin = margin;
            params.bottomMargin = margin;
            this.mRootView.addView((View)this.mLockIconImageView, (ViewGroup.LayoutParams)params);
        }
    }
}

