/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.panel_view;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.custom_recycler_view.CustomLinearLayoutManager;
import com.custom_recycler_view.CustomRecyclerView;
import com.custom_recycler_view.DefaultItemAnimator;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;
import com.kidoz.sdk.api.ui_views.panel_view.PanelAdapter;
import com.kidoz.sdk.api.ui_views.panel_view.PanelViewListener;
import java.util.ArrayList;

public class PanelSliderView
extends RelativeLayout {
    private PANEL_TYPE mPanelType;
    private CustomRecyclerView mCustomRecyclerView;
    private PanelAdapter mPanelAdapter;

    public PanelSliderView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.initRecyclerView();
    }

    public void initRecyclerView() {
        this.mCustomRecyclerView = new CustomRecyclerView(this.getContext());
        this.mCustomRecyclerView.setHasFixedSize(true);
        this.mCustomRecyclerView.setItemAnimator(new DefaultItemAnimator());
        this.mCustomRecyclerView.setClipToPadding(false);
        CustomLinearLayoutManager customLinearLayoutManager = new CustomLinearLayoutManager(this.getContext(), 0, false);
        this.mCustomRecyclerView.setLayoutManager(customLinearLayoutManager);
        this.mPanelAdapter = new PanelAdapter();
        this.mCustomRecyclerView.setAdapter(this.mPanelAdapter);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        this.addView((View)this.mCustomRecyclerView, (ViewGroup.LayoutParams)params);
    }

    private void preparePanelSlider() {
        float SCALE_FACTOR = ScreenUtils.getScaleFactor(this.getContext());
        int itemWidth = (int)(517.0f * SCALE_FACTOR);
        int itemHeight = (int)(402.0f * SCALE_FACTOR);
        int padding = Utils.dpTOpx(this.getContext(), 3);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        CustomLinearLayoutManager customLinearLayoutManager = new CustomLinearLayoutManager(this.getContext(), 0, false);
        switch (this.mPanelType) {
            case LEFT: {
                params.width = itemWidth + padding * 4;
                params.height = -1;
                this.mCustomRecyclerView.setPadding(padding, padding, 0, padding);
                customLinearLayoutManager.setOrientation(1);
                break;
            }
            case TOP: {
                params.width = -1;
                params.height = itemHeight + padding * 3;
                this.mCustomRecyclerView.setPadding(padding, padding, padding, 0);
                customLinearLayoutManager.setOrientation(0);
                break;
            }
            case RIGHT: {
                params.width = itemWidth + padding * 4;
                params.height = -1;
                this.mCustomRecyclerView.setPadding(0, padding, padding, padding);
                customLinearLayoutManager.setOrientation(1);
                break;
            }
            case BOTTOM: {
                params.width = -1;
                params.height = itemHeight + padding * 3;
                this.mCustomRecyclerView.setPadding(0, padding, padding, padding);
                customLinearLayoutManager.setOrientation(0);
            }
        }
        this.mCustomRecyclerView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mCustomRecyclerView.setLayoutManager(customLinearLayoutManager);
    }

    public void setPanelType(PANEL_TYPE panelType) {
        this.mPanelType = panelType;
        this.preparePanelSlider();
    }

    public void setContent(ArrayList<ContentItem> content) {
        this.mPanelAdapter.setContent(content);
    }

    public void clearContent() {
        this.mPanelAdapter.clearContent();
    }

    public void setPanelViewListener(PanelViewListener panelViewListener) {
        this.mPanelAdapter.setPanelViewListener(panelViewListener);
    }
}

