/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.panel_view;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozCardView;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.picasso_related.PicassoOk;
import com.kidoz.sdk.api.picasso_related.RoundedTransformation;
import com.kidoz.sdk.api.structure.ContentItem;

public class PanelContentItem
extends KidozCardView {
    private RelativeLayout mContainer;
    private TextView mItemName;
    private ImageView mItemThumbnail;
    private ImageView mItemTypeIcon;
    private int mWidth;
    private int mHeight;
    private int mThumbnailCornersRadius;
    private int mThumbnailWidth;
    private int mThumbnailHeight;

    public PanelContentItem(Context context) {
        super(context);
        this.initParameters();
        this.initView();
    }

    private void initParameters() {
        float WIDTH = 0.4787037f;
        float HEIGHT = 0.209375f;
        float SCALE_FACTOR = ScreenUtils.getScaleFactor(this.getContext());
        int screenWidth = Math.min(ScreenUtils.getScreenSize(this.getContext(), true), ScreenUtils.getScreenSize(this.getContext(), false));
        int screenHeight = Math.max(ScreenUtils.getScreenSize(this.getContext(), true), ScreenUtils.getScreenSize(this.getContext(), false));
        this.mWidth = (int)(517.0f * SCALE_FACTOR);
        this.mHeight = (int)(402.0f * SCALE_FACTOR);
    }

    private void initView() {
        this.initRootView();
        this.initContainer();
        this.initItemThumbnail();
        this.initItemTypeIcon();
        this.initItemName();
    }

    private void initRootView() {
        this.setContentPadding(0, 0, 0, 0);
        this.setRadius(Utils.dpTOpx(this.getContext(), 6));
        this.setCardElevation(Utils.dpTOpx(this.getContext(), 4));
        int margin = Utils.dpTOpx(this.getContext(), 3);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.leftMargin = margin;
        params.topMargin = margin;
        params.rightMargin = margin;
        params.bottomMargin = margin;
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void initContainer() {
        this.mContainer = new RelativeLayout(this.getContext());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(this.mWidth, this.mHeight);
        this.addView((View)this.mContainer, (ViewGroup.LayoutParams)params);
    }

    private void initItemThumbnail() {
        float WIDTH = 0.97485495f;
        float HEIGHT = 0.6467662f;
        float MARGIN_TOP = 0.016169155f;
        this.mItemThumbnail = new ImageView(this.getContext());
        this.mItemThumbnail.setId(Utils.generateViewId());
        this.mItemThumbnail.setScaleType(ImageView.ScaleType.FIT_XY);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.width = (int)((float)this.mWidth * WIDTH);
        params.height = (int)((float)this.mHeight * HEIGHT);
        params.topMargin = (int)((float)this.mHeight * MARGIN_TOP);
        params.addRule(14);
        this.mContainer.addView((View)this.mItemThumbnail, (ViewGroup.LayoutParams)params);
        this.mThumbnailCornersRadius = Utils.dpTOpx(this.getContext(), 5);
        this.mThumbnailWidth = params.width;
        this.mThumbnailHeight = params.height;
    }

    private void initItemTypeIcon() {
        float SIZE = 0.2205029f;
        float MARGIN_RIGHT = 0.06382979f;
        this.mItemTypeIcon = new ImageView(this.getContext());
        this.mItemTypeIcon.setId(Utils.generateViewId());
        this.mItemTypeIcon.setScaleType(ImageView.ScaleType.FIT_CENTER);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(11);
        params.addRule(8, this.mItemThumbnail.getId());
        params.width = (int)((float)this.mWidth * SIZE);
        params.height = (int)((float)this.mWidth * SIZE);
        params.rightMargin = (int)((float)this.mWidth * MARGIN_RIGHT);
        params.bottomMargin = (int)((float)(-1 * this.mWidth) * SIZE / 2.0f);
        this.mContainer.addView((View)this.mItemTypeIcon, (ViewGroup.LayoutParams)params);
    }

    private void initItemName() {
        float TEXT_SIZE = 0.10945274f;
        float MARGIN_HORIZONTAL = 0.0483559f;
        float MARGIN_TOP = 0.031094527f;
        this.mItemName = new TextView(this.getContext());
        this.mItemName.setTextSize(0, (float)this.mHeight * TEXT_SIZE);
        this.mItemName.setMaxLines(2);
        this.mItemName.setEllipsize(TextUtils.TruncateAt.END);
        this.mItemName.setTextColor(Color.parseColor((String)"#484848"));
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        params.addRule(3, this.mItemThumbnail.getId());
        params.addRule(0, this.mItemTypeIcon.getId());
        params.leftMargin = (int)((float)this.mWidth * MARGIN_HORIZONTAL);
        params.rightMargin = (int)((float)this.mWidth * MARGIN_HORIZONTAL);
        params.topMargin = (int)((float)this.mHeight * MARGIN_TOP);
        this.mContainer.addView((View)this.mItemName, (ViewGroup.LayoutParams)params);
    }

    private void loadBackgroundColor(ContentItem contentItem) {
        this.setCardBackgroundColor(-1);
        if (contentItem != null) {
            this.setCardBackgroundColor(contentItem.getPaliteBgColor());
        }
    }

    private void loadThumbnail(ContentItem contentItem) {
        this.mItemThumbnail.setImageBitmap(null);
        if (contentItem != null) {
            PicassoOk.getPicasso(this.getContext()).load(contentItem.getThumb()).transform(new RoundedTransformation(this.mThumbnailCornersRadius, 0)).resize(this.mThumbnailWidth, this.mThumbnailHeight).centerCrop().into(this.mItemThumbnail);
        }
    }

    private void loadItemTypeIcon(ContentItem contentItem) {
        this.mItemTypeIcon.setImageBitmap(null);
        if (contentItem != null) {
            PicassoOk.getPicasso(this.getContext()).load(contentItem.getSecThumb()).into(this.mItemTypeIcon);
        }
    }

    private void loadIteNameAndSetTextColor(ContentItem contentItem) {
        this.mItemName.setText(null);
        if (contentItem != null) {
            this.mItemName.setTextColor(contentItem.getPaliteTextColor());
            this.mItemName.setText((CharSequence)contentItem.getName());
        }
    }

    public void setData(ContentItem contentItem) {
        this.loadBackgroundColor(contentItem);
        this.loadThumbnail(contentItem);
        this.loadItemTypeIcon(contentItem);
        this.loadIteNameAndSetTextColor(contentItem);
    }
}

