/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.panel_view;

import android.animation.Animator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.View;
import android.widget.ImageView;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.utils.AppAssetsUtils;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.picasso_related.PicassoOk;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_BUTTON_TYPE;
import java.io.File;

public class PanelButton
extends ImageView {
    private final String TAG = PanelButton.class.getSimpleName();
    private PanelButtonListener mPanelButtonListener;
    private PANEL_BUTTON_TYPE mButtonType;
    private File mImageFile;
    private Paint mPaint;
    private int mWidth;
    private int mHeight;
    private int mAnimationType;
    private boolean mIsLockActive;
    private RectF mLockBodyRectF;
    private RectF mLockIconRectF;

    public PanelButton(Context context, PANEL_BUTTON_TYPE panelButtonType, PanelButtonListener panelButtonListener) {
        super(context);
        this.mButtonType = panelButtonType;
        this.mPanelButtonListener = panelButtonListener;
        this.setScaleType(ImageView.ScaleType.FIT_XY);
        this.initView();
    }

    private void initView() {
        this.initImageFile();
        this.initImageParameters();
        this.initPaints();
        this.initRectF();
        this.initOnClickAnimation();
    }

    private void initImageFile() {
        switch (this.mButtonType) {
            case HANDLE: {
                this.mImageFile = AppAssetsUtils.getAssetFile(this.getContext(), AppAssetsUtils.APP_ASSET_TYPE.PANEL_BUTTON_HANDLE);
                break;
            }
            case EXIT: {
                this.mImageFile = AppAssetsUtils.getAssetFile(this.getContext(), AppAssetsUtils.APP_ASSET_TYPE.PANEL_BUTTON_EXIT);
                break;
            }
            case ABOUT_KIDOZ: {
                this.mImageFile = AppAssetsUtils.getAssetFile(this.getContext(), AppAssetsUtils.APP_ASSET_TYPE.PANEL_BUTTON_ABOUT_KIDOZ);
                break;
            }
            case PARENTAL_LOCK: {
                this.mImageFile = AppAssetsUtils.getAssetFile(this.getContext(), AppAssetsUtils.APP_ASSET_TYPE.PANEL_BUTTON_PARENTAL_LOCK);
            }
        }
    }

    private void initPaints() {
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mPaint.setColor(Color.parseColor((String)"#ffffff"));
        this.setLayerType(1, this.mPaint);
    }

    private void initRectF() {
        float left = 0.26056337f * (float)this.mWidth;
        float top = 0.4084507f * (float)this.mHeight;
        float right = 0.73239434f * (float)this.mWidth;
        float bottom = 0.7605634f * (float)this.mHeight;
        this.mLockBodyRectF = new RectF(left, top, right, bottom);
        left = 0.47887325f * (float)this.mWidth;
        top = 0.5492958f * (float)this.mHeight;
        right = 0.52112675f * (float)this.mWidth;
        bottom = 0.6830986f * (float)this.mHeight;
        this.mLockIconRectF = new RectF(left, top, right, bottom);
    }

    private void initImageParameters() {
        float scaleFactor = ScreenUtils.getScaleFactor(this.getContext());
        this.mWidth = 142;
        this.mHeight = 142;
        this.mAnimationType = 1;
        if (this.mImageFile != null && this.mImageFile.exists()) {
            String width = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), "PANEL_BUTTON_WIDTH", "142", 0);
            String height = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), "PANEL_BUTTON_HEIGHT", "142", 0);
            String animationType = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), "PANEL_BUTTON_ANIMATION", "1", 0);
            try {
                this.mWidth = Integer.parseInt(width);
                this.mHeight = Integer.parseInt(height);
                this.mAnimationType = Integer.parseInt(animationType);
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(this.TAG, "Error when trying to init image parameters: " + ex.getMessage());
            }
        }
        this.mWidth = (int)((float)this.mWidth * scaleFactor);
        this.mHeight = (int)((float)this.mHeight * scaleFactor);
    }

    private void initOnClickAnimation() {
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PanelButton.this.mPanelButtonListener != null) {
                    PanelButton.this.mPanelButtonListener.onClickStarted();
                }
                switch (PanelButton.this.mAnimationType) {
                    case 1: {
                        GenAnimator.playClickAnimation(view, new Animator.AnimatorListener(){

                            public void onAnimationStart(Animator animation) {
                            }

                            public void onAnimationEnd(Animator animation) {
                                if (PanelButton.this.mPanelButtonListener != null) {
                                    PanelButton.this.mPanelButtonListener.onClickEnd();
                                }
                            }

                            public void onAnimationCancel(Animator animation) {
                            }

                            public void onAnimationRepeat(Animator animation) {
                            }
                        });
                    }
                }
            }
        });
    }

    private void loadImage() {
        if (this.mImageFile.exists() && this.getDrawable() == null) {
            PicassoOk.getPicasso(this.getContext()).load(this.mImageFile).into(this);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.mWidth, this.mHeight);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.mImageFile.exists()) {
            float radius = 0.5f * (float)this.mWidth;
            float centerX = 0.5f * (float)this.mWidth;
            float centerY = 0.5f * (float)this.mHeight;
            switch (this.mButtonType) {
                case HANDLE: {
                    this.mPaint.setColor(Color.parseColor((String)"#ffffff"));
                    canvas.drawCircle(centerX, centerY, radius, this.mPaint);
                    this.mPaint.setColor(Color.parseColor((String)"#39b0c5"));
                    float left = 0.43661973f * (float)this.mWidth;
                    float top = 0.1971831f * (float)this.mHeight;
                    float right = 0.5633803f * (float)this.mWidth;
                    float bottom = 0.8028169f * (float)this.mHeight;
                    canvas.drawRect(left, top, right, bottom, this.mPaint);
                    canvas.restore();
                    canvas.save();
                    canvas.rotate(90.0f, centerX, centerY);
                    canvas.drawRect(left, top, right, bottom, this.mPaint);
                    canvas.restore();
                    break;
                }
                case EXIT: {
                    this.mPaint.setColor(Color.parseColor((String)"#c23e85"));
                    canvas.drawCircle(centerX, centerY, radius, this.mPaint);
                    break;
                }
                case ABOUT_KIDOZ: {
                    this.mPaint.setColor(Color.parseColor((String)"#ffffff"));
                    canvas.drawCircle(centerX, centerY, radius, this.mPaint);
                    this.mPaint.setColor(Color.parseColor((String)"#d90000"));
                    radius = 0.15845071f * (float)this.mWidth;
                    centerX = 0.29929578f * (float)this.mWidth;
                    centerY = 0.5809859f * (float)this.mHeight;
                    canvas.drawCircle(centerX, centerY, radius, this.mPaint);
                    this.mPaint.setColor(Color.parseColor((String)"#4aaed3"));
                    radius = 0.15845071f * (float)this.mWidth;
                    centerX = 0.7007042f * (float)this.mWidth;
                    centerY = 0.5809859f * (float)this.mHeight;
                    canvas.drawCircle(centerX, centerY, radius, this.mPaint);
                    this.mPaint.setColor(Color.parseColor((String)"#f7da32"));
                    radius = 0.17605634f * (float)this.mWidth;
                    centerX = 0.50352114f * (float)this.mWidth;
                    centerY = 0.32042253f * (float)this.mHeight;
                    canvas.drawCircle(centerX, centerY, radius, this.mPaint);
                    this.mPaint.setColor(Color.parseColor((String)"#f79e3d"));
                    radius = 0.15845071f * (float)this.mWidth;
                    centerX = 0.30633804f * (float)this.mWidth;
                    centerY = 0.41197184f * (float)this.mHeight;
                    canvas.drawCircle(centerX, centerY, radius, this.mPaint);
                    this.mPaint.setColor(Color.parseColor((String)"#a7d125"));
                    radius = 0.15845071f * (float)this.mWidth;
                    centerX = 0.693662f * (float)this.mWidth;
                    centerY = 0.41197184f * (float)this.mHeight;
                    canvas.drawCircle(centerX, centerY, radius, this.mPaint);
                    this.mPaint.setColor(Color.parseColor((String)"#ffffff"));
                    radius = 0.17605634f * (float)this.mWidth;
                    centerX = 0.5f * (float)this.mWidth;
                    centerY = 0.52112675f * (float)this.mHeight;
                    canvas.drawCircle(centerX, centerY, radius, this.mPaint);
                    break;
                }
                case PARENTAL_LOCK: {
                    this.mPaint.setColor(Color.parseColor((String)"#ffffff"));
                    canvas.drawCircle(centerX, centerY, radius, this.mPaint);
                    if (this.mIsLockActive) {
                        this.mPaint.setColor(Color.parseColor((String)"#39b0c5"));
                        radius = 0.20422535f * (float)this.mWidth;
                        centerX = 0.5f * (float)this.mWidth;
                        centerY = 0.35915494f * (float)this.mHeight;
                        canvas.drawCircle(centerX, centerY, radius, this.mPaint);
                        this.mPaint.setColor(Color.parseColor((String)"#ffffff"));
                        radius = 0.11971831f * (float)this.mWidth;
                        centerX = 0.5f * (float)this.mWidth;
                        centerY = 0.35915494f * (float)this.mHeight;
                        canvas.drawCircle(centerX, centerY, radius, this.mPaint);
                    } else {
                        this.mPaint.setColor(Color.parseColor((String)"#fe9400"));
                        radius = 0.20422535f * (float)this.mWidth;
                        centerX = 0.5f * (float)this.mWidth;
                        centerY = 0.35915494f * (float)this.mHeight;
                        canvas.drawCircle(centerX, centerY, radius, this.mPaint);
                        centerX = 0.69014084f * (float)this.mWidth;
                        centerY = 0.3697183f * (float)this.mHeight;
                        canvas.save();
                        canvas.rotate(-45.0f, centerX, centerY);
                        float left = 0.5070422f * (float)this.mWidth;
                        float top = 0.2535211f * (float)this.mHeight;
                        float right = 0.87323946f * (float)this.mWidth;
                        float bottom = 0.48591548f * (float)this.mHeight;
                        this.mPaint.setColor(Color.parseColor((String)"#ffffff"));
                        canvas.drawRect(left, top, right, bottom, this.mPaint);
                        canvas.restore();
                        this.mPaint.setColor(Color.parseColor((String)"#ffffff"));
                        radius = 0.11971831f * (float)this.mWidth;
                        centerX = 0.5f * (float)this.mWidth;
                        centerY = 0.35915494f * (float)this.mHeight;
                        canvas.drawCircle(centerX, centerY, radius, this.mPaint);
                    }
                    this.mPaint.setColor(Color.parseColor((String)"#39b0c5"));
                    radius = 0.07042254f * (float)this.mWidth;
                    canvas.drawRoundRect(this.mLockBodyRectF, radius, radius, this.mPaint);
                    this.mPaint.setColor(Color.parseColor((String)"#ffffff"));
                    canvas.drawRect(this.mLockIconRectF, this.mPaint);
                    radius = 0.056338027f * (float)this.mWidth;
                    centerX = 0.5f * (float)this.mWidth;
                    centerY = 0.5492958f * (float)this.mHeight;
                    canvas.drawCircle(centerX, centerY, radius, this.mPaint);
                }
            }
        } else {
            this.loadImage();
        }
    }

    public void setIsLockActive(boolean isLockActive) {
        this.mIsLockActive = isLockActive;
        this.invalidate();
    }

    public static interface PanelButtonListener {
        public void onClickStarted();

        public void onClickEnd();
    }
}

