/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.panel_view;

import android.animation.Animator;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import com.custom_recycler_view.CustomRecyclerView;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.utils.AnimationsUtils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.panel_view.PanelContentItem;
import com.kidoz.sdk.api.ui_views.panel_view.PanelViewListener;
import java.util.ArrayList;

public class PanelAdapter
extends CustomRecyclerView.Adapter<ViewHolder>
implements View.OnClickListener {
    private PanelViewListener mPanelViewListener;
    private ArrayList<ContentItem> mContent = new ArrayList();
    private Handler mHandler = new Handler();
    private boolean mIsCanClick = true;
    private int mLastPosition = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent(ArrayList<ContentItem> content) {
        PanelAdapter panelAdapter = this;
        synchronized (panelAdapter) {
            if (content != null) {
                if (this.mContent.isEmpty()) {
                    this.mContent.clear();
                    this.mContent.addAll(content);
                    this.notifyItemRangeInserted(0, this.getItemCount());
                    this.notifyItemRangeChanged(0, this.getItemCount());
                } else {
                    this.mContent.clear();
                    this.mContent.addAll(content);
                    this.notifyDataSetChanged();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearContent() {
        PanelAdapter panelAdapter = this;
        synchronized (panelAdapter) {
            if (this.mContent != null) {
                this.mLastPosition = -1;
                if (this.mContent.isEmpty()) {
                    this.notifyItemRangeRemoved(0, this.getItemCount());
                    this.notifyItemRangeChanged(0, this.getItemCount());
                    this.mContent.clear();
                } else {
                    this.mContent.clear();
                    this.notifyDataSetChanged();
                }
            }
        }
    }

    @Override
    public int getItemCount() {
        int result = 0;
        if (this.mContent != null) {
            result = this.mContent.size();
        }
        return result;
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        PanelContentItem panelContentItem = new PanelContentItem(parent.getContext());
        ViewHolder viewHolder = new ViewHolder(panelContentItem);
        viewHolder.mPanelContentItem.setOnClickListener(this);
        viewHolder.mPanelContentItem.setTag(viewHolder);
        return viewHolder;
    }

    @Override
    public void onBindViewHolder(final ViewHolder holder, int position) {
        ContentItem contentItem = this.mContent.get(position);
        holder.setData(contentItem);
        if (position > this.mLastPosition) {
            holder.mPanelContentItem.setVisibility(4);
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    GenAnimator.recycleItemAnimation((View)holder.mPanelContentItem, new GenAnimator.ViewAnimationListener(){

                        @Override
                        public void onAnimationEnd() {
                        }

                        @Override
                        public void onAnimationStart() {
                            holder.mPanelContentItem.setVisibility(0);
                        }
                    });
                }
            }, 0L);
            this.mLastPosition = position;
        } else {
            holder.mPanelContentItem.clearAnimation();
            holder.mPanelContentItem.setVisibility(0);
        }
    }

    public void onClick(final View view) {
        if (this.mIsCanClick) {
            this.mIsCanClick = false;
            AnimationsUtils.animateClick(view, new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    ViewHolder viewHolder = (ViewHolder)view.getTag();
                    int position = viewHolder.getAdapterPosition();
                    ContentItem contentItem = (ContentItem)PanelAdapter.this.mContent.get(position);
                    if (position == -1) {
                        position = viewHolder.getPosition();
                    }
                    if (position != -1 && PanelAdapter.this.mPanelViewListener != null) {
                        PanelAdapter.this.mPanelViewListener.onItemClick(contentItem, position);
                    }
                    PanelAdapter.this.mIsCanClick = true;
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            }, 50, 100);
        }
    }

    public void setPanelViewListener(PanelViewListener panelViewListener) {
        this.mPanelViewListener = panelViewListener;
    }

    public class ViewHolder
    extends CustomRecyclerView.ViewHolder {
        private PanelContentItem mPanelContentItem;

        public ViewHolder(PanelContentItem view) {
            super((View)view);
            this.mPanelContentItem = view;
        }

        public void setData(ContentItem contentItem) {
            this.mPanelContentItem.setData(contentItem);
        }
    }
}

