/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views;

import android.animation.Animator;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.utils.AnimationsUtils;
import com.kidoz.sdk.api.ui_views.OnBoardingCloud;

public class OnBoardingView
extends RelativeLayout {
    public static final String ON_BOARDING_SHARED_PREFERENCES_KEY = "ON_BOARDING_SHARED_PREFERENCES_KEY";
    private final long ON_BOARDING_ENTER_DELAY_ANIMATION = 500L;
    private final long ON_BOARDING_EXIT_DELAY_ANIMATION = 2200L;
    private final long FADE_IN_ANIMATION_DURATION = 1000L;
    private final long FADE_OUT_ANIMATION_DURATION = 700L;
    private View mBackgroundView;
    private OnBoardingCloud mOnBoardingCloud;
    private OnBoardingCloudInterface mOnBoardingCloudInterface;

    public OnBoardingView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.initBackgroundView();
        this.initOnBoardingCloud();
    }

    private void initBackgroundView() {
        this.mBackgroundView = new View(this.getContext());
        this.mBackgroundView.setBackgroundColor(Color.parseColor((String)"#5004a0e1"));
        this.mBackgroundView.setClickable(true);
        this.mBackgroundView.setVisibility(4);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        this.addView(this.mBackgroundView, (ViewGroup.LayoutParams)params);
    }

    private void initOnBoardingCloud() {
        this.mOnBoardingCloud = new OnBoardingCloud(this.getContext());
        this.mOnBoardingCloud.setVisibility(4);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(13);
        this.addView((View)this.mOnBoardingCloud, (ViewGroup.LayoutParams)params);
    }

    public void animateView(OnBoardingCloudInterface onBoardingCloudInterface) {
        this.mOnBoardingCloudInterface = onBoardingCloudInterface;
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                AnimationsUtils.animateFade(OnBoardingView.this.mBackgroundView, true, 1000L, new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                        OnBoardingView.this.mBackgroundView.setVisibility(0);
                    }

                    public void onAnimationEnd(Animator animation) {
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
                GenAnimator.playOnBoardingCloudDropAnimation((View)OnBoardingView.this.mOnBoardingCloud, new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                        OnBoardingView.this.mOnBoardingCloud.setVisibility(0);
                    }

                    public void onAnimationEnd(Animator animation) {
                        OnBoardingView.this.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                AnimationsUtils.animateFade(OnBoardingView.this.mBackgroundView, false, 700L, new Animator.AnimatorListener(){

                                    public void onAnimationStart(Animator animation) {
                                    }

                                    public void onAnimationEnd(Animator animation) {
                                        OnBoardingView.this.mBackgroundView.setVisibility(8);
                                        if (OnBoardingView.this.mOnBoardingCloudInterface != null) {
                                            OnBoardingView.this.mOnBoardingCloudInterface.onFinished();
                                        }
                                    }

                                    public void onAnimationCancel(Animator animation) {
                                        OnBoardingView.this.mBackgroundView.setVisibility(8);
                                        if (OnBoardingView.this.mOnBoardingCloudInterface != null) {
                                            OnBoardingView.this.mOnBoardingCloudInterface.onFinished();
                                        }
                                    }

                                    public void onAnimationRepeat(Animator animation) {
                                    }
                                });
                                GenAnimator.playPopOutAnimation((View)OnBoardingView.this.mOnBoardingCloud, new Animator.AnimatorListener(){

                                    public void onAnimationStart(Animator animation) {
                                    }

                                    public void onAnimationEnd(Animator animation) {
                                        OnBoardingView.this.mOnBoardingCloud.setVisibility(8);
                                    }

                                    public void onAnimationCancel(Animator animation) {
                                    }

                                    public void onAnimationRepeat(Animator animation) {
                                    }
                                });
                            }
                        }, 2200L);
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
            }
        }, 500L);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    public static interface OnBoardingCloudInterface {
        public void onFinished();
    }
}

