/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.widget.ImageView;
import com.kidoz.sdk.api.general.utils.AppAssetsUtils;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.picasso_related.PicassoOk;
import com.kidoz.sdk.api.ui_views.ExitButton;
import java.io.File;

public class OnBoardingCloud
extends ImageView {
    private final String TAG = ExitButton.class.getSimpleName();
    private File mImageFile;
    private int mWidth;
    private int mHeight;
    private int mAnimationType;
    private Paint mWhitePaint;
    private Paint mTextPaint;

    public OnBoardingCloud(Context context) {
        super(context);
        this.setScaleType(ImageView.ScaleType.FIT_XY);
        this.initView();
    }

    private void initView() {
        this.initImageFile();
        this.initImageParameters();
        this.initPaints();
    }

    private void initImageFile() {
        this.mImageFile = AppAssetsUtils.getAssetFile(this.getContext(), AppAssetsUtils.APP_ASSET_TYPE.ON_BOARDING_BACKGROUND);
    }

    private void loadImage() {
        if (this.mImageFile.exists() && this.getDrawable() == null) {
            PicassoOk.getPicasso(this.getContext()).load(this.mImageFile).into(this);
        }
    }

    private void initImageParameters() {
        float scaleFactor = ScreenUtils.getScaleFactor(this.getContext());
        this.mWidth = 852;
        this.mHeight = 801;
        this.mAnimationType = 1;
        if (this.mImageFile != null && this.mImageFile.exists()) {
            String width = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), "ON_BOARDING_BACKGROUND_WIDTH", "852", 0);
            String height = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), "ON_BOARDING_BACKGROUND_HEIGHT", "801", 0);
            String animationType = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), "LOCK_NOT_ACTIVE_BUTTON_ANIMATION_TYPE", "1", 0);
            try {
                this.mWidth = Integer.parseInt(width);
                this.mHeight = Integer.parseInt(height);
                this.mAnimationType = Integer.parseInt(animationType);
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(this.TAG, "Error when trying to init image parameters: " + ex.getMessage());
            }
        }
        this.mWidth = (int)((float)this.mWidth * scaleFactor);
        this.mHeight = (int)((float)this.mHeight * scaleFactor);
    }

    private void initPaints() {
        this.mWhitePaint = new Paint(1);
        this.mWhitePaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mWhitePaint.setColor(Color.parseColor((String)"#ffffff"));
        this.mTextPaint = new Paint(1);
        this.mTextPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mTextPaint.setColor(Color.parseColor((String)"#04a0e1"));
        this.mTextPaint.setTextSize(0.062421974f * (float)this.mHeight);
        this.setLayerType(1, this.mTextPaint);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.mWidth, this.mHeight);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.mImageFile.exists()) {
            float radius = 0.21624413f * (float)this.mWidth;
            float centerX = 0.55353284f * (float)this.mWidth;
            float centerY = 0.7720849f * (float)this.mHeight;
            canvas.drawCircle(centerX, centerY, radius, this.mWhitePaint);
            radius = 0.21624413f * (float)this.mWidth;
            centerX = 0.4471831f * (float)this.mWidth;
            centerY = 0.2278402f * (float)this.mHeight;
            canvas.drawCircle(centerX, centerY, radius, this.mWhitePaint);
            radius = 0.21624413f * (float)this.mWidth;
            centerX = 0.21596244f * (float)this.mWidth;
            centerY = 0.43508115f * (float)this.mHeight;
            canvas.drawCircle(centerX, centerY, radius, this.mWhitePaint);
            radius = 0.21624413f * (float)this.mWidth;
            centerX = 0.28403756f * (float)this.mWidth;
            centerY = 0.6048689f * (float)this.mHeight;
            canvas.drawCircle(centerX, centerY, radius, this.mWhitePaint);
            radius = 0.21624413f * (float)this.mWidth;
            centerX = 0.78403753f * (float)this.mWidth;
            centerY = 0.5699126f * (float)this.mHeight;
            canvas.drawCircle(centerX, centerY, radius, this.mWhitePaint);
            radius = 0.21624413f * (float)this.mWidth;
            centerX = 0.7699531f * (float)this.mWidth;
            centerY = 0.3764045f * (float)this.mHeight;
            canvas.drawCircle(centerX, centerY, radius, this.mWhitePaint);
            radius = 0.21624413f * (float)this.mWidth;
            centerX = 0.62089205f * (float)this.mWidth;
            centerY = 0.4563046f * (float)this.mHeight;
            canvas.drawCircle(centerX, centerY, radius, this.mWhitePaint);
            String text = "Surprise!";
            this.drawCenter(canvas, this.mTextPaint, text);
        } else {
            this.loadImage();
        }
    }

    private void drawCenter(Canvas canvas, Paint paint, String text) {
        int cHeight = canvas.getClipBounds().height();
        int cWidth = canvas.getClipBounds().width();
        Rect r = new Rect();
        paint.setTextAlign(Paint.Align.LEFT);
        paint.getTextBounds(text, 0, text.length(), r);
        float x = (float)cWidth / 2.0f - (float)r.width() / 2.0f - (float)r.left;
        float y = (float)cHeight / 2.0f + (float)r.height() / 2.0f - (float)r.bottom;
        canvas.drawText(text, x, y, paint);
    }
}

