/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views;

import android.animation.Animator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.View;
import android.widget.ImageView;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.utils.AppAssetsUtils;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.picasso_related.PicassoOk;
import java.io.File;

public class ExitButton
extends ImageView {
    private final String TAG = ExitButton.class.getSimpleName();
    private boolean mIsUseBackButton;
    private File mImageFile;
    private float mScaleFactor;
    private int mWidth;
    private int mHeight;
    private int mAnimationType;
    private Paint mWhitePaint;
    private Paint mBluePaint;
    private RectF mRectF;
    private ExitButtonListener mExitButtonListener;

    public ExitButton(Context context, ExitButtonListener exitButtonListener, boolean isUseBackButton) {
        super(context);
        this.mExitButtonListener = exitButtonListener;
        this.mIsUseBackButton = isUseBackButton;
        this.setScaleType(ImageView.ScaleType.FIT_XY);
        this.initView();
    }

    private void initView() {
        this.initImageFile();
        this.initImageParameters();
        this.initPaints();
        this.initRectF();
        this.initOnClickAnimation();
    }

    private void initOnClickAnimation() {
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ExitButton.this.mExitButtonListener != null) {
                    ExitButton.this.mExitButtonListener.onClickStarted();
                }
                switch (ExitButton.this.mAnimationType) {
                    case 1: {
                        GenAnimator.playStandUpAnimation(view, new Animator.AnimatorListener(){

                            public void onAnimationStart(Animator animation) {
                            }

                            public void onAnimationEnd(Animator animation) {
                                if (ExitButton.this.mExitButtonListener != null) {
                                    ExitButton.this.mExitButtonListener.onClickEnd();
                                }
                            }

                            public void onAnimationCancel(Animator animation) {
                            }

                            public void onAnimationRepeat(Animator animation) {
                            }
                        });
                    }
                }
            }
        });
    }

    private void initImageFile() {
        this.mImageFile = !this.mIsUseBackButton ? AppAssetsUtils.getAssetFile(this.getContext(), AppAssetsUtils.APP_ASSET_TYPE.EXIT_BUTTON) : AppAssetsUtils.getAssetFile(this.getContext(), AppAssetsUtils.APP_ASSET_TYPE.BACK_BUTTON);
    }

    private void loadImage() {
        if (this.mImageFile.exists() && this.getDrawable() == null) {
            PicassoOk.getPicasso(this.getContext()).load(this.mImageFile).into(this);
        }
    }

    private void initImageParameters() {
        this.mScaleFactor = ScreenUtils.getScaleFactor(this.getContext());
        this.mWidth = 178;
        this.mHeight = 128;
        this.mAnimationType = 1;
        if (this.mImageFile != null && this.mImageFile.exists()) {
            String width = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), "EXIT_BUTTON_WIDTH", "178", 0);
            String height = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), "EXIT_BUTTON_HEIGHT", "128", 0);
            String animationType = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), "EXIT_BUTTON_ANIMATION_TYPE", "1", 0);
            try {
                this.mWidth = Integer.parseInt(width);
                this.mHeight = Integer.parseInt(height);
                this.mAnimationType = Integer.parseInt(animationType);
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(this.TAG, "Error when trying to init image parameters: " + ex.getMessage());
            }
        }
        this.mWidth = (int)((float)this.mWidth * this.mScaleFactor);
        this.mHeight = (int)((float)this.mHeight * this.mScaleFactor);
    }

    private void initPaints() {
        this.mWhitePaint = new Paint(1);
        this.mWhitePaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mWhitePaint.setColor(Color.parseColor((String)"#ffffff"));
        this.mBluePaint = new Paint(1);
        this.mBluePaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mBluePaint.setColor(Color.parseColor((String)"#04a0e1"));
        this.setLayerType(1, this.mWhitePaint);
    }

    private void initRectF() {
        float left = 0.36516854f * (float)this.mWidth;
        float top = 0.4375f * (float)this.mHeight;
        float right = 0.6966292f * (float)this.mWidth;
        float bottom = 0.5625f * (float)this.mHeight;
        if (this.mIsUseBackButton) {
            left = 0.41011235f * (float)this.mWidth;
            top = 0.4609375f * (float)this.mHeight;
            right = 0.64044946f * (float)this.mWidth;
            bottom = 0.5390625f * (float)this.mHeight;
        }
        this.mRectF = new RectF(left, top, right, bottom);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.mWidth, this.mHeight);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.mImageFile.exists()) {
            float left = 0.18539326f * (float)this.mWidth;
            float top = 0.0f * (float)this.mHeight;
            float right = 0.19662921f * (float)this.mWidth;
            float bottom = 0.3828125f * (float)this.mHeight;
            canvas.drawRect(left, top, right, bottom, this.mWhitePaint);
            left = 0.9101124f * (float)this.mWidth;
            top = 0.0f * (float)this.mHeight;
            right = 0.92134833f * (float)this.mWidth;
            bottom = 0.640625f * (float)this.mHeight;
            canvas.drawRect(left, top, right, bottom, this.mWhitePaint);
            float radius = 0.328125f * (float)this.mHeight;
            float centerX = 0.23595506f * (float)this.mWidth;
            float centerY = 0.671875f * (float)this.mHeight;
            canvas.drawCircle(centerX, centerY, radius, this.mWhitePaint);
            radius = 0.203125f * (float)this.mHeight;
            centerX = 0.85393256f * (float)this.mWidth;
            centerY = 0.796875f * (float)this.mHeight;
            canvas.drawCircle(centerX, centerY, radius, this.mWhitePaint);
            radius = 0.3859375f * (float)this.mHeight;
            centerX = 0.56971914f * (float)this.mWidth;
            centerY = 0.520625f * (float)this.mHeight;
            canvas.drawCircle(centerX, centerY, radius, this.mWhitePaint);
            left = 0.23595506f * (float)this.mWidth;
            top = 0.7890625f * (float)this.mHeight;
            right = 0.85955054f * (float)this.mWidth;
            bottom = 1.0f * (float)this.mHeight;
            canvas.drawRect(left, top, right, bottom, this.mWhitePaint);
            this.mWhitePaint.setShadowLayer(2.0f, 0.0f, 3.0f, -8618884);
            radius = 0.328125f * (float)this.mHeight;
            centerX = 0.5224719f * (float)this.mWidth;
            centerY = 0.5f * (float)this.mHeight;
            canvas.save();
            canvas.rotate(45.0f, centerX, centerY);
            canvas.drawCircle(centerX, centerY, radius, this.mWhitePaint);
            this.mWhitePaint.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
            canvas.restore();
            if (!this.mIsUseBackButton) {
                radius = 0.039325844f * (float)this.mWidth;
                centerX = 0.5310112f * (float)this.mWidth;
                centerY = 0.5001562f * (float)this.mHeight;
                canvas.save();
                canvas.rotate(45.0f, centerX, centerY);
                canvas.drawRoundRect(this.mRectF, radius, radius, this.mBluePaint);
                canvas.restore();
                canvas.save();
                canvas.rotate(-45.0f, centerX, centerY);
                canvas.drawRoundRect(this.mRectF, radius, radius, this.mBluePaint);
                canvas.restore();
            } else {
                radius = 0.028089888f * (float)this.mWidth;
                centerX = 0.41011235f * (float)this.mWidth;
                centerY = 0.5f * (float)this.mHeight;
                canvas.rotate(30.0f, centerX, centerY);
                canvas.drawRoundRect(this.mRectF, radius, radius, this.mBluePaint);
                canvas.restore();
                canvas.save();
                canvas.rotate(-30.0f, centerX, centerY);
                canvas.drawRoundRect(this.mRectF, radius, radius, this.mBluePaint);
                canvas.restore();
                radius = 0.0390625f * (float)this.mHeight;
                centerX = 0.42696628f * (float)this.mWidth;
                centerY = 0.5f * (float)this.mHeight;
                canvas.drawCircle(centerX, centerY, radius, this.mBluePaint);
            }
        } else {
            this.loadImage();
        }
    }

    public static interface ExitButtonListener {
        public void onClickStarted();

        public void onClickEnd();
    }
}

