/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Point;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.custom_recycler_view.CustomGridLayoutManager;
import com.custom_recycler_view.CustomLinearLayoutManager;
import com.custom_recycler_view.CustomRecyclerView;
import com.custom_recycler_view.CustomStaggeredGridLayoutManager;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.AbstractContentPanel;
import com.kidoz.sdk.api.ui_views.ItemVerticalRecycleViewAdapter;
import com.kidoz.sdk.api.ui_views.RecycleEndlessScrollListener;
import java.util.ArrayList;

public class ContentPanelView
extends AbstractContentPanel {
    private CustomRecyclerView mCustomRecyclerView;
    private RecycleEndlessScrollListener endlesScollPaginghandler;
    private ItemVerticalRecycleViewAdapter mAdapter;
    private CustomStaggeredGridLayoutManager mStaggaredLayoutManager;
    private CustomGridLayoutManager mCustomGridLayoutManager;
    private CustomLinearLayoutManager mLinearLayoutManager;
    private LayoutViewType mLayoutViewType = LayoutViewType.STAGGERED;
    private ArrayList<ContentItem> mItemsList = new ArrayList();
    private int[] fPos = new int[3];
    private int[] lPos = new int[3];
    private int mCurrentVisiblePosition = 0;

    public ContentPanelView(Context context, LayoutViewType layoutViewType) {
        super(context);
        this.mLayoutViewType = layoutViewType;
        this.initPanelView(context);
    }

    public ContentPanelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initPanelView(context);
    }

    public ContentPanelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initPanelView(context);
    }

    @Override
    public void initPanelView(Context context) {
        this.initRecyclerView(context);
        this.initAdaper();
        this.initLaoutManager();
        RelativeLayout.LayoutParams relParams = new RelativeLayout.LayoutParams(-1, -1);
        this.addView((View)this.mCustomRecyclerView, (ViewGroup.LayoutParams)relParams);
    }

    private void initRecyclerView(Context context) {
        this.mCustomRecyclerView = new CustomRecyclerView(context);
        this.mCustomRecyclerView.setClipToPadding(false);
        Point point = Utils.getScreenSize(this.getContext());
        int paddingBottom = (int)((float)Math.max(point.x, point.y) * 0.061458334f);
        int paddingTop = (int)((float)Math.max(point.x, point.y) * 0.061458334f);
        this.mCustomRecyclerView.setPadding(0, paddingTop, 0, paddingBottom);
    }

    private void initLaoutManager() {
        this.setLayoutManagerView(this.mLayoutViewType);
    }

    private void initAdaper() {
        this.mAdapter = new ItemVerticalRecycleViewAdapter(this.getContext(), this.mItemsList, this.getCurrentSpanCount());
        this.endlesScollPaginghandler = new RecycleEndlessScrollListener(4){

            @Override
            public void onLoadMore(int page, int totalItemsCount) {
                if (totalItemsCount > 0) {
                    // empty if block
                }
            }
        };
        this.mCustomRecyclerView.setOnScrollListener(new CustomRecyclerView.OnScrollListener(){

            @Override
            public void onScrolled(CustomRecyclerView customRecyclerView, int dx, int dy) {
                super.onScrolled(customRecyclerView, dx, dy);
                ContentPanelView.this.mAdapter.setIsRegularAnimation(true);
                try {
                    if (ContentPanelView.this.mLayoutViewType == LayoutViewType.GRID || ContentPanelView.this.mLayoutViewType == LayoutViewType.LINEAR_HORIZONTAL || ContentPanelView.this.mLayoutViewType == LayoutViewType.LINEAR_VERTICAL) {
                        ((ContentPanelView)ContentPanelView.this).fPos[0] = ContentPanelView.this.mCustomGridLayoutManager.findFirstVisibleItemPosition();
                        ((ContentPanelView)ContentPanelView.this).lPos[0] = ContentPanelView.this.mCustomGridLayoutManager.findLastVisibleItemPosition();
                        ContentPanelView.this.endlesScollPaginghandler.onScroll(ContentPanelView.this.fPos[0], ContentPanelView.this.lPos[0] - ContentPanelView.this.fPos[0], ContentPanelView.this.mItemsList.size());
                    } else if (ContentPanelView.this.mLayoutViewType == LayoutViewType.STAGGERED) {
                        ContentPanelView.this.mStaggaredLayoutManager.findFirstVisibleItemPositions(ContentPanelView.this.fPos);
                        ContentPanelView.this.mStaggaredLayoutManager.findLastVisibleItemPositions(ContentPanelView.this.lPos);
                        ContentPanelView.this.endlesScollPaginghandler.onScroll(ContentPanelView.this.fPos[0], ContentPanelView.this.lPos[0] - ContentPanelView.this.fPos[0], ContentPanelView.this.mItemsList.size());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ContentPanelView.this.mCurrentVisiblePosition = ContentPanelView.this.fPos[0];
            }

            @Override
            public void onScrollStateChanged(CustomRecyclerView customRecyclerView, int newState) {
                try {
                    super.onScrollStateChanged(customRecyclerView, newState);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.mCustomRecyclerView.setAdapter(this.mAdapter);
        if (this.mCurrentVisiblePosition != 0) {
            this.mCustomRecyclerView.scrollToPosition(this.mCurrentVisiblePosition);
        }
    }

    private int getCurrentSpanCount() {
        return KidozSDK.getCreativeToolsData().getNumberOfColumns(this.getContext());
    }

    public void setLayoutManagerView(LayoutViewType viewType) {
        this.mLayoutViewType = viewType;
        switch (viewType) {
            case STAGGERED: {
                this.mStaggaredLayoutManager = new CustomStaggeredGridLayoutManager(this.getCurrentSpanCount(), 1);
                this.mCustomRecyclerView.setLayoutManager(this.mStaggaredLayoutManager);
                break;
            }
            case GRID: {
                this.mCustomGridLayoutManager = new CustomGridLayoutManager(this.getContext(), this.getCurrentSpanCount());
                this.mCustomRecyclerView.setLayoutManager(this.mCustomGridLayoutManager);
                break;
            }
            case LINEAR_HORIZONTAL: {
                this.mLinearLayoutManager = new CustomLinearLayoutManager(this.getContext(), 0, false);
                this.mCustomRecyclerView.setLayoutManager(this.mLinearLayoutManager);
                break;
            }
            case LINEAR_VERTICAL: {
                this.mLinearLayoutManager = new CustomLinearLayoutManager(this.getContext(), 1, false);
                this.mCustomRecyclerView.setLayoutManager(this.mLinearLayoutManager);
            }
        }
    }

    public void setRoundingCorenrsValue(int rounding) {
    }

    public void setOnContentItemClickListener(AbstractContentPanel.IOnContentItemClickListener listener) {
        if (this.mAdapter != null) {
            this.mAdapter.setOnItemClickListener(listener);
        }
    }

    public void clearDataFromView() {
        this.mItemsList.clear();
        this.mAdapter.clearContentDataWithNotify();
    }

    public void addDatandRefreshView(ArrayList<ContentItem> list) {
        if (list != null) {
            this.mItemsList.clear();
            this.mItemsList.addAll(list);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void screenStatusChanged(boolean screenOn) {
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        int spanCount = this.getCurrentSpanCount();
        this.mAdapter.setSpanCount(spanCount, newConfig.orientation);
        this.setLayoutManagerView(this.mLayoutViewType);
        this.mCustomRecyclerView.scrollToPosition(this.mCurrentVisiblePosition);
    }

    public static enum LayoutViewType {
        STAGGERED,
        GRID,
        LINEAR_VERTICAL,
        LINEAR_HORIZONTAL;

    }
}

