/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozCardView;
import com.kidoz.sdk.api.general.utils.Utils;

class ContentItemView
extends KidozCardView {
    public static final int DEFAULT_CORNER_RADIUS_PIXELS = 6;
    public static final int DEFAULT_SHADOW_ELEVATION_RADIUS_DP = 4;
    public static final int MAIN_THUMB_FADE_DURATION = 120;
    public static final int CARD_OUTER_MARGIN = 4;
    public static final int VIEW_CONTENT_PADDING = 2;
    private RelativeLayout mInnerContainer;
    private ImageView mMainIconThumb;
    private ImageView mSecondaryThumb;
    private TextView mNameView;
    private int mOuterMargin;

    public ContentItemView(Context context) {
        super(context);
        this.initCardViewGeneral(context);
        this.initView(context);
    }

    public ContentItemView(Context context, int roundingCorenrs) {
        super(context);
        this.initCardViewGeneral(context);
        this.initView(context);
    }

    private void initCardViewGeneral(Context context) {
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2);
        this.mOuterMargin = Utils.dpTOpx(context, 4);
        params.setMargins(this.mOuterMargin, this.mOuterMargin, this.mOuterMargin, this.mOuterMargin);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        int pad = Utils.dpTOpx(context, 2);
        this.setContentPadding(pad, pad, pad, pad);
        this.mInnerContainer = new RelativeLayout(context);
        this.setRadius(Utils.dpTOpx(context, 6));
        this.setCardElevation(Utils.dpTOpx(context, 4));
    }

    private void initView(Context context) {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        this.addView((View)this.mInnerContainer, (ViewGroup.LayoutParams)layoutParams);
        this.mMainIconThumb = new ImageView(context);
        this.mMainIconThumb.setId(Utils.generateViewId());
        this.mMainIconThumb.setScaleType(ImageView.ScaleType.FIT_XY);
        this.mInnerContainer.addView((View)this.mMainIconThumb, (ViewGroup.LayoutParams)layoutParams);
        this.mSecondaryThumb = new ImageView(context);
        this.mSecondaryThumb.setId(Utils.generateViewId());
        this.mSecondaryThumb.setScaleType(ImageView.ScaleType.FIT_CENTER);
        layoutParams = new RelativeLayout.LayoutParams(Utils.dpTOpx(context, 30), Utils.dpTOpx(context, 30));
        layoutParams.addRule(11);
        layoutParams.addRule(8, this.mMainIconThumb.getId());
        layoutParams.setMargins(0, 0, Utils.dpTOpx(context, 10), Utils.dpTOpx(context, -25));
        this.mInnerContainer.addView((View)this.mSecondaryThumb, (ViewGroup.LayoutParams)layoutParams);
        this.mNameView = new TextView(context);
        this.mNameView.setId(Utils.generateViewId());
        this.mNameView.setTextColor(Color.parseColor((String)"#484848"));
        this.mNameView.setTextSize(2, (float)ContentItemView.getNameTextSizeByScreenLayout(this.getContext()));
        this.mNameView.setLines(2);
        this.mNameView.setEllipsize(TextUtils.TruncateAt.END);
        this.mNameView.setGravity(16);
        this.mNameView.setPadding(0, Utils.dpTOpx(context, 4), 0, Utils.dpTOpx(context, 4));
        layoutParams = new RelativeLayout.LayoutParams(-1, -2);
        layoutParams.addRule(3, this.mMainIconThumb.getId());
        layoutParams.addRule(0, this.mSecondaryThumb.getId());
        layoutParams.setMargins(Utils.dpTOpx(context, 6), Utils.dpTOpx(context, 0), Utils.dpTOpx(context, 6), 0);
        this.mInnerContainer.addView((View)this.mNameView, (ViewGroup.LayoutParams)layoutParams);
    }

    public ImageView getMainThumbView() {
        return this.mMainIconThumb;
    }

    public ImageView getSecondaryThumbView() {
        return this.mSecondaryThumb;
    }

    public TextView getNameTextView() {
        return this.mNameView;
    }

    public void setItemBgColor(int color2) {
        this.setCardBackgroundColor(color2);
    }

    private static int getNameTextSizeByScreenLayout(Context context) {
        int size = 16;
        int screenLayout = context.getResources().getConfiguration().screenLayout;
        switch (screenLayout &= 0xF) {
            case 1: {
                size = 13;
                break;
            }
            case 2: {
                size = 15;
                break;
            }
            case 3: {
                size = 17;
                break;
            }
            case 4: {
                size = 21;
            }
        }
        return size;
    }

    public static int getViewMargin(Context context) {
        return Utils.dpTOpx(context, 4);
    }
}

