/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.view.View;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.Utils;

public class AboutKidozWebViewContainer
extends RelativeLayout {
    private final String TAG = AboutKidozWebViewContainer.class.getSimpleName();
    private int mHeight;
    private int mWidth;
    private int mMargin;
    private Paint mPaint;

    public AboutKidozWebViewContainer(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.setWillNotDraw(false);
        int screenMaxSize = Math.min(ScreenUtils.getScreenSize(this.getContext(), true), ScreenUtils.getScreenSize(this.getContext(), false));
        float MARGIN = 0.046296295f;
        this.mMargin = (int)((float)screenMaxSize * MARGIN);
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mPaint.setColor(Color.parseColor((String)"#ffffff"));
        this.initImageParameters();
    }

    private void initImageParameters() {
        this.mHeight = (int)(0.75f * (float)ScreenUtils.getScreenSize(this.getContext(), false));
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.initImageParameters();
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.mWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.setMeasuredDimension(this.mWidth, this.mHeight);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int left = 0;
        int top = 0;
        int right = this.mWidth;
        int bottom = this.mHeight;
        this.getChildAt(0).layout(left, top, right, bottom);
        int padding = Utils.dpTOpx(this.getContext(), 10);
        left = this.mWidth - padding * 3;
        top = padding;
        right = left + padding * 2;
        bottom = top + padding * 2;
        this.getChildAt(1).layout(left, top, right, bottom);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawRect(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight, this.mPaint);
    }
}

