/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.structure;

import android.graphics.Color;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.structure.ContentItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ContentData
implements Serializable {
    private static final String VIEW_ITEM_BG_COLOR_KEY = "viewItemBgColor";
    private static String VIEW_ITEM_CORENR_RADIUS_PX_KEY = "viewItemCorenrRadiusPx";
    private static String CONTAINER_VIEW_BG_COLOR_KEY = "containerViewBgColor";
    private static String HEADER_VIEW_BG_COLOR_KEY = "headerColor";
    private static String FOOTER_VIEW_BG_COLOR_KEY = "footerColor";
    private static String HEADER_TEXT_KEY = "headerText";
    private static String POWERED_BY_URL_KEY = "powerd_by_url";
    private static String DATA_KEY = "data";
    private static String CONTENT_ITEMS_KEY = "content_items";
    private ArrayList<ContentItem> mItems;
    public int mViewItemBgColor;
    public int mViewItemCorenrRadiusPx;
    public int mContainerViewBgColor;
    public int mHeaderViewBgColor;
    public int mFooterViewBgColor;
    public String mHeaderTextStr = "";
    public String mPowerByUrl = "";
    public String mBackgroundURL = "";

    public boolean isHasContentToShow() {
        return this.mItems != null && !this.mItems.isEmpty();
    }

    public ArrayList<ContentItem> getContentDataItems() {
        return this.mItems;
    }

    public void decodeResponse(String data) {
        try {
            JSONObject genDataObj;
            JSONObject contentData = new JSONObject(data);
            boolean isSuccess = contentData.optBoolean("success");
            if (isSuccess && contentData != null && (genDataObj = contentData.optJSONObject(DATA_KEY)) != null) {
                this.mViewItemBgColor = Color.parseColor((String)genDataObj.optString(VIEW_ITEM_BG_COLOR_KEY, "#ffffffff"));
                this.mViewItemCorenrRadiusPx = genDataObj.optInt(VIEW_ITEM_CORENR_RADIUS_PX_KEY, 20);
                this.mContainerViewBgColor = Color.parseColor((String)genDataObj.optString(CONTAINER_VIEW_BG_COLOR_KEY, "#ffffffff"));
                this.mHeaderViewBgColor = Color.parseColor((String)genDataObj.optString(HEADER_VIEW_BG_COLOR_KEY, "#ffffffff"));
                this.mFooterViewBgColor = Color.parseColor((String)genDataObj.optString(FOOTER_VIEW_BG_COLOR_KEY, "#ffffffff"));
                this.mHeaderTextStr = genDataObj.optString(HEADER_TEXT_KEY, "More Cool Stuff");
                this.mPowerByUrl = genDataObj.optString(POWERED_BY_URL_KEY, "");
                if (genDataObj.has(CONTENT_ITEMS_KEY)) {
                    this.mItems = new ArrayList();
                    JSONArray jsonArray = genDataObj.optJSONArray(CONTENT_ITEMS_KEY);
                    if (jsonArray != null && jsonArray.length() > 0) {
                        LinkedHashMap<String, Integer> keysMap = new LinkedHashMap<String, Integer>();
                        JSONArray keysArray = jsonArray.getJSONArray(0);
                        if (keysArray != null && keysArray.length() > 0) {
                            for (int i = 0; i < keysArray.length(); ++i) {
                                keysMap.put(keysArray.getString(i), i);
                            }
                        }
                        if (!keysMap.isEmpty()) {
                            for (int i = 1; i < jsonArray.length(); ++i) {
                                try {
                                    ContentItem item = new ContentItem(jsonArray.getJSONArray(i), keysMap);
                                    this.mItems.add(item);
                                    continue;
                                }
                                catch (JSONException e) {
                                    SDKLogger.printDebbugLog("[KIDOZ SDK] Error parsing Content data item!");
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            SDKLogger.printDebbugLog("[KIDOZ SDK] Error parsing Content data object!\n" + e.getMessage());
        }
    }

    public int getHeaderViewBgColor() {
        return this.mHeaderViewBgColor;
    }

    public int getContainerViewBgColor() {
        return this.mContainerViewBgColor;
    }

    public int getViewItemCorenrRadiusPx() {
        return this.mViewItemCorenrRadiusPx;
    }

    public int getViewItemBgColor() {
        return this.mViewItemBgColor;
    }

    public int getFooterViewBgColor() {
        return this.mFooterViewBgColor;
    }

    public String getHeaderTextStr() {
        return this.mHeaderTextStr;
    }

    public String getPowerByUrl() {
        return this.mPowerByUrl;
    }
}

