/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.server_connect;

import android.content.ContentValues;
import android.content.Context;
import com.kidoz.events.DeviceUtils;
import com.kidoz.events.EventBulk;
import com.kidoz.sdk.api.general.enums.UiStyleType;
import com.kidoz.sdk.api.general.utils.EncoderUtils;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.server_connect.ApiResultCallback;
import com.kidoz.sdk.api.server_connect.BaseAPIManager;
import com.kidoz.sdk.api.server_connect.BaseConnectionClient;
import com.kidoz.sdk.api.server_connect.ResultData;
import com.kidoz.sdk.api.server_connect.SdkRequestType;
import com.kidoz.sdk.api.server_connect.StreamToStringConverter;
import com.kidoz.sdk.api.structure.ContentData;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Response;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.json.JSONObject;

public class SdkAPIManager
extends BaseAPIManager {
    private static final String TAG = SdkAPIManager.class.getName();
    private String mPublicherId = null;
    private String mSecurityToken = null;
    private String mPackageName;
    private static final String JSON = "JSON";
    private static final String REQUEST_FORMAT = "resFormat";
    private static final String WEB_SERVICE_REQUEST_PARAMETERS = "request_parameters";
    private static final String GET_CONTENT = "getContent";
    private static final String VALIDATE_SDK_CONFIGURATION = "initConfig";
    private static final String SEND_KIDOZ_EVENTS_TO_SERVER = "SendKidozEventsToServer";
    private static final String GET_SDK_RESOURCES = "getResources";

    public SdkAPIManager(Context context, String pId, String sKey) {
        MAIN_SERVER_URL = "http://sdk.kidoz.net/api/sdk";
        KIDOZ_ANALITYCS_SERVER_URL = "http://54.197.245.43/parents/KidozRestMobile.php";
        SdkAPIManager.initConnectionClient(false);
        this.mPublicherId = pId;
        this.mSecurityToken = sKey;
        this.mPackageName = context.getPackageName();
    }

    public void loadContent(Context context, UiStyleType styleType, ApiResultCallback<ContentData> resultCallback) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("method_name", GET_CONTENT);
        contentValues.put("publisher_id", this.mPublicherId);
        contentValues.put("package_id", this.mPackageName);
        contentValues.put("device_lang", Locale.getDefault().getLanguage());
        contentValues.put("style_id", Integer.valueOf(styleType.getValue()));
        contentValues.put("device_hash", Utils.generateUniqeDeviceID(this.mPackageName, this.mPublicherId));
        String addId = DeviceUtils.getGoogleAdvertisingID(context);
        if (addId == null) {
            addId = "";
        }
        contentValues.put("google_id", addId);
        contentValues.put("version", "1");
        long ts = System.currentTimeMillis() / 1000L;
        contentValues.put("ts", Long.valueOf(ts));
        contentValues.put("hash", this.generateRequestHash(contentValues, ts, this.mSecurityToken));
        this.startServerConnection(context, BaseConnectionClient.CONNECTION_TYPE.POST, SdkRequestType.LOAD_SDK_CONTENT, contentValues, 2, resultCallback);
    }

    public void validateSDKConfiguration(Context context, ApiResultCallback<PropertiesObj> resultCallback) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("method_name", VALIDATE_SDK_CONFIGURATION);
        try {
            JSONObject requestParameters = new JSONObject();
            requestParameters.put("publisher_id", (Object)this.mPublicherId);
            requestParameters.put("package_id", (Object)this.mPackageName);
            requestParameters.put("device_hash", (Object)Utils.generateUniqeDeviceID(this.mPackageName, this.mPublicherId));
            requestParameters.put("version", (Object)"1");
            contentValues.put(WEB_SERVICE_REQUEST_PARAMETERS, requestParameters.toString());
            long ts = System.currentTimeMillis() / 1000L;
            contentValues.put("ts", String.valueOf(ts));
            contentValues.put("hash", this.generateRequestHash(contentValues, ts, this.mSecurityToken));
            this.startServerConnection(context, BaseConnectionClient.CONNECTION_TYPE.POST, SdkRequestType.VALIDATE_SDK, contentValues, 1, resultCallback);
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to validateSDK: " + ex.getMessage());
            resultCallback.onFailed();
        }
    }

    public void getSDKResources(Context context, ApiResultCallback<Boolean> resultCallback) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("method_name", GET_SDK_RESOURCES);
        try {
            JSONObject requestParameters = new JSONObject();
            requestParameters.put("publisher_id", (Object)this.mPublicherId);
            requestParameters.put("package_id", (Object)this.mPackageName);
            requestParameters.put("device_hash", (Object)Utils.generateUniqeDeviceID(this.mPackageName, this.mPublicherId));
            requestParameters.put("version", (Object)"1");
            contentValues.put(WEB_SERVICE_REQUEST_PARAMETERS, requestParameters.toString());
            long ts = System.currentTimeMillis() / 1000L;
            contentValues.put("ts", String.valueOf(ts));
            contentValues.put("hash", this.generateRequestHash(contentValues, ts, this.mSecurityToken));
            this.startServerConnection(context, BaseConnectionClient.CONNECTION_TYPE.POST, SdkRequestType.GET_SDK_RESOURCES, contentValues, 1, resultCallback);
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to validateSDK: " + ex.getMessage());
            resultCallback.onFailed();
        }
    }

    public ResultData<Boolean> sendKidozEventsToServerNotAsync(String eventsJsonBulk) {
        ResultData<Boolean> resultCallback;
        block6: {
            ContentValues contentValues = new ContentValues();
            contentValues.put("methodName", SEND_KIDOZ_EVENTS_TO_SERVER);
            contentValues.put("KidozEventsLogAsJson", eventsJsonBulk);
            contentValues.put(REQUEST_FORMAT, JSON);
            resultCallback = null;
            Call call = null;
            try {
                Response response;
                call = BaseConnectionClient.makePostConnection(KIDOZ_ANALITYCS_SERVER_URL, contentValues, "analyticsRequest");
                if (call == null || (response = call.execute()) == null) break block6;
                if (response.isSuccessful()) {
                    try {
                        String responce = StreamToStringConverter.readStream(new BufferedInputStream(response.body().byteStream()), null, false);
                        if (responce != null) {
                            resultCallback = EventBulk.parseResultSuccsesStatus(responce);
                        }
                        break block6;
                    }
                    catch (IOException e) {
                        SDKLogger.printErrorLog(" \n Unable to convertByte Stream to String! [ Kidoz Analytics Data Sent ]  : \n\n" + e.getMessage());
                    }
                    break block6;
                }
                SDKLogger.printErrorLog(" \n Server connectivity Error! [ Kidoz Analytics Data Sent ]  Code : " + response.code());
            }
            catch (IOException e) {
                SDKLogger.printErrorLog(" \n IO Exception On [ Kidoz Analytics Data Sent ] \n " + e.getMessage());
            }
        }
        return resultCallback;
    }

    private String generateRequestHash(ContentValues contentValues, long ts, String token) {
        Set set = contentValues.keySet();
        ArrayList list = new ArrayList();
        list.addAll(set);
        Collections.sort(list);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append(contentValues.getAsString((String)list.get(i)));
        }
        stringBuilder.append(ts);
        stringBuilder.append(token);
        return EncoderUtils.SHA1(stringBuilder.toString());
    }
}

