/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.server_connect;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Environment;
import com.kidoz.sdk.api.general.utils.AppAssetsUtils;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.UriUtil;
import com.kidoz.sdk.api.server_connect.ApiResultCallback;
import com.kidoz.sdk.api.server_connect.BaseConnectionClient;
import com.kidoz.sdk.api.server_connect.GifDrawableCallback;
import com.kidoz.sdk.api.server_connect.ResponseStatus;
import com.kidoz.sdk.api.server_connect.ResultData;
import com.kidoz.sdk.api.server_connect.SdkRequestType;
import com.kidoz.sdk.api.server_connect.StreamToStringConverter;
import com.kidoz.sdk.api.structure.ContentData;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Response;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;
import pl.droidsonroids.gif.GifDrawable;

@SuppressLint(value={"NewApi"})
class BaseAPIManager
extends BaseConnectionClient {
    private static final String TAG = BaseAPIManager.class.getSimpleName();
    private HashMap<SdkRequestType, RequestAsyncTask> runningTaskList = new HashMap();
    private HashMap<String, GifAsyncTaskLoader> mGifLoadingTasks = new HashMap();

    BaseAPIManager() {
    }

    @TargetApi(value=11)
    protected void startServerConnection(Context context, BaseConnectionClient.CONNECTION_TYPE type, SdkRequestType requestType, ContentValues contentValues, int numOfReconnecsOnFail, ApiResultCallback<?> resultCallback) {
        try {
            if (this.runningTaskList.containsKey((Object)requestType) && this.runningTaskList.get((Object)requestType) != null) {
                RequestAsyncTask task = this.runningTaskList.get((Object)requestType);
                if (task.getStatus() != AsyncTask.Status.FINISHED) {
                    task.cancel(true);
                    task.closeCurrentConnection();
                } else {
                    this.runningTaskList.remove((Object)requestType);
                }
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, " \n Unable to finish Running Request asyncTask ! \n\n " + ex.getMessage());
        }
        RequestAsyncTask requestAsyncTask = new RequestAsyncTask(context, type, requestType, contentValues, numOfReconnecsOnFail, resultCallback);
        this.runningTaskList.put(requestType, requestAsyncTask);
        if (Build.VERSION.SDK_INT < 11) {
            requestAsyncTask.execute(new Void[0]);
        } else {
            requestAsyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        }
    }

    public void cancelAllRunningRequests() {
        for (Map.Entry<SdkRequestType, RequestAsyncTask> entry : this.runningTaskList.entrySet()) {
            RequestAsyncTask asyncTask = entry.getValue();
            if (asyncTask == null || asyncTask.getStatus() != AsyncTask.Status.RUNNING || asyncTask.getStatus() != AsyncTask.Status.PENDING) continue;
            asyncTask.cancel(true);
            asyncTask.closeCurrentConnection();
        }
        this.runningTaskList.clear();
    }

    public void cancelRequest(SdkRequestType requestType) {
        if (this.runningTaskList.containsKey((Object)requestType) && this.runningTaskList.get((Object)requestType) != null && this.runningTaskList.get((Object)requestType).getStatus() != AsyncTask.Status.FINISHED) {
            this.runningTaskList.get((Object)requestType).cancel(true);
            this.runningTaskList.get((Object)requestType).closeCurrentConnection();
        }
    }

    @TargetApi(value=11)
    public void loadGifImage(Context context, Uri uri, String tag, GifDrawableCallback drawableCallback) {
        try {
            if (this.mGifLoadingTasks.containsKey(tag) && this.mGifLoadingTasks.get(tag) != null) {
                GifAsyncTaskLoader task = this.mGifLoadingTasks.get(tag);
                if (task.getStatus() != AsyncTask.Status.FINISHED) {
                    task.cancel(true);
                    task.closeCurrentConnection();
                } else {
                    this.mGifLoadingTasks.remove(tag);
                }
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, " \n Unable to finish gif image loading task asyncTask ! \n\n " + ex.getMessage());
        }
        GifAsyncTaskLoader requestAsyncTask = new GifAsyncTaskLoader(context, uri, tag, drawableCallback);
        this.mGifLoadingTasks.put(tag, requestAsyncTask);
        if (Build.VERSION.SDK_INT < 11) {
            requestAsyncTask.execute(new Void[0]);
        } else {
            requestAsyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        }
    }

    public void cancelGifLoadingRequest(String tag) {
        if (this.mGifLoadingTasks.containsKey(tag) && this.mGifLoadingTasks.get(tag) != null && this.mGifLoadingTasks.get(tag).getStatus() != AsyncTask.Status.FINISHED) {
            this.mGifLoadingTasks.get(tag).cancel(true);
            this.mGifLoadingTasks.get(tag).closeCurrentConnection();
        }
    }

    class GifAsyncTaskLoader
    extends AsyncTask<Void, Void, GifDrawable> {
        private static final String NEW_ANIMATION_TEMP_NAME = "temp_GifAnim.gif";
        private Call mCall;
        private Uri mUri;
        private GifDrawableCallback mGifDrawableCallback;
        private Context mContext;
        private File myAnimFile;
        private String mTag;

        public GifAsyncTaskLoader(Context context, Uri uri, String tag, GifDrawableCallback drawableCallback) {
            this.mUri = uri;
            this.mGifDrawableCallback = drawableCallback;
            this.mContext = context;
            this.mTag = tag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected GifDrawable doInBackground(Void ... params) {
            GifDrawable mGifDrawable = null;
            if (this.isCancelled()) return mGifDrawable;
            if (this.mUri == null) return mGifDrawable;
            if (UriUtil.isNetworkUri(this.mUri)) {
                final String url = this.mUri.toString();
                if (url == null || !url.contains(".gif")) {
                    if (!url.contains(".GIF")) return mGifDrawable;
                }
                int index1 = url.lastIndexOf("/");
                String name = url.substring(index1 + 1, url.length());
                File filePath = this.getSDfoldersPath();
                if (filePath == null) return mGifDrawable;
                this.myAnimFile = new File(filePath, name);
                if (this.myAnimFile != null) {
                    if (this.myAnimFile.exists() && this.myAnimFile.length() > 0L) {
                        File tempAnimFile = new File(filePath, NEW_ANIMATION_TEMP_NAME);
                        if (tempAnimFile != null && tempAnimFile.exists()) {
                            this.myAnimFile.delete();
                            tempAnimFile.renameTo(this.myAnimFile);
                        }
                        try {
                            mGifDrawable = new GifDrawable(this.myAnimFile);
                        }
                        catch (IOException e) {
                            if (this.myAnimFile != null && this.myAnimFile.exists()) {
                                this.myAnimFile.delete();
                            }
                            SDKLogger.printErrorLog(" \n Unable to create GidDrawable ! : \n\n" + e.getMessage());
                        }
                    }
                    if (this.isCancelled()) return mGifDrawable;
                    if (this.myAnimFile.exists()) {
                        Thread thread = new Thread(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                block17: {
                                    File tempAnimFile = new File(GifAsyncTaskLoader.this.getSDfoldersPath(), GifAsyncTaskLoader.NEW_ANIMATION_TEMP_NAME);
                                    if (tempAnimFile != null && tempAnimFile.exists()) {
                                        tempAnimFile.delete();
                                    }
                                    InputStream inputStream = null;
                                    try {
                                        Response response = null;
                                        GifAsyncTaskLoader.this.mCall = BaseConnectionClient.getImageStream(url, GifAsyncTaskLoader.this.mTag);
                                        response = GifAsyncTaskLoader.this.mCall.execute();
                                        inputStream = response.body().byteStream();
                                        if (!response.isSuccessful() || inputStream == null) break block17;
                                        long savedFileSize = GifAsyncTaskLoader.this.myAnimFile.length();
                                        long newFileSize = -1L;
                                        String fileSize = response.header("content-length");
                                        if (fileSize != null) {
                                            try {
                                                newFileSize = Long.parseLong(fileSize);
                                            }
                                            catch (NumberFormatException e) {
                                                newFileSize = -1L;
                                            }
                                        }
                                        if (newFileSize != -1L && newFileSize != savedFileSize) {
                                            tempAnimFile.createNewFile();
                                            GifAsyncTaskLoader.this.loadImageAndSaveToSd(inputStream, tempAnimFile);
                                        }
                                    }
                                    catch (IOException e) {
                                        SDKLogger.printErrorLog(" \n Failed to load gif image for the server ! : \n\n");
                                    }
                                    finally {
                                        if (inputStream != null) {
                                            try {
                                                inputStream.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                    }
                                }
                            }
                        });
                        thread.setPriority(1);
                        thread.start();
                        return mGifDrawable;
                    }
                    InputStream inputStream = null;
                    try {
                        Response response = null;
                        this.mCall = BaseConnectionClient.getImageStream(url, this.mTag);
                        response = this.mCall.execute();
                        inputStream = response.body().byteStream();
                        if (!response.isSuccessful()) return mGifDrawable;
                        if (inputStream == null) return mGifDrawable;
                        this.myAnimFile.createNewFile();
                        this.loadImageAndSaveToSd(inputStream, this.myAnimFile);
                        if (!this.myAnimFile.exists()) return mGifDrawable;
                        if (this.myAnimFile.length() <= 0L) return mGifDrawable;
                        try {
                            mGifDrawable = new GifDrawable(this.myAnimFile);
                            return mGifDrawable;
                        }
                        catch (IOException e) {
                            if (this.myAnimFile != null && this.myAnimFile.exists()) {
                                this.myAnimFile.delete();
                            }
                            SDKLogger.printErrorLog(" \n Unable to create GidDrawable ! : \n\n" + e.getMessage());
                        }
                        return mGifDrawable;
                    }
                    catch (IOException e) {
                        SDKLogger.printErrorLog(" \n Failed to load gif image for the server ! : \n\n");
                        return mGifDrawable;
                    }
                    finally {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                SDKLogger.printErrorLog(" \n Failed to create Gif image file path ! : \n\n");
                return mGifDrawable;
            }
            if (UriUtil.isLocalAssetUri(this.mUri)) {
                if (this.isCancelled()) return mGifDrawable;
                try {
                    InputStream inputStream = this.mContext.getAssets().open(this.mUri.getLastPathSegment());
                    return new GifDrawable(inputStream);
                }
                catch (IOException e) {
                    SDKLogger.printErrorLog(" \n Unable to create GidDrawable ! : \n\n" + e.getMessage());
                }
                return mGifDrawable;
            } else if (UriUtil.isLocalResourceUri(this.mUri)) {
                if (this.isCancelled()) return mGifDrawable;
                try {
                    int res = Integer.valueOf(this.mUri.getLastPathSegment());
                    return new GifDrawable(this.mContext.getResources(), res);
                }
                catch (IOException e) {
                    SDKLogger.printErrorLog(" \n Unable to create GidDrawable ! : \n\n" + e.getMessage());
                }
                return mGifDrawable;
            } else {
                if (!UriUtil.isLocalFileUri(this.mUri)) return mGifDrawable;
                if (this.isCancelled()) return mGifDrawable;
                this.myAnimFile = new File(this.mUri.toString());
                if (!this.myAnimFile.exists()) return mGifDrawable;
                if (this.myAnimFile.length() <= 0L) return mGifDrawable;
                try {
                    return new GifDrawable(this.myAnimFile);
                }
                catch (IOException e) {
                    SDKLogger.printErrorLog(" \n Unable to create GidDrawable ! : \n\n" + e.getMessage());
                }
            }
            return mGifDrawable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loadImageAndSaveToSd(InputStream inputStream, File filePath) {
            try (FileOutputStream output = new FileOutputStream(filePath);){
                byte[] buffer = new byte[4096];
                int bytesRead = 0;
                while ((bytesRead = inputStream.read(buffer, 0, buffer.length)) >= 0) {
                    ((OutputStream)output).write(buffer, 0, bytesRead);
                }
            }
            catch (IOException e) {
                SDKLogger.printErrorLog(" \n Failed to read Gif image input stream !: \n\n" + e.getMessage());
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        protected void onPostExecute(GifDrawable gifDrawable) {
            super.onPostExecute((Object)gifDrawable);
            if (this.mGifDrawableCallback != null && !this.isCancelled()) {
                this.mGifDrawableCallback.onGifDrawableLoaded(gifDrawable);
            }
        }

        protected void onCancelled() {
            super.onCancelled();
        }

        public void closeCurrentConnection() {
            if (this.mCall != null && !this.mCall.isCanceled()) {
                this.mCall.cancel();
            }
        }

        private File getSDfoldersPath() {
            File filePath = null;
            String state = Environment.getExternalStorageState();
            if ("mounted".equals(state)) {
                String path;
                if (this.mContext != null && !(filePath = this.mContext.getExternalFilesDir("KsdkTemp")).exists()) {
                    filePath.mkdirs();
                }
                if (filePath == null && !(filePath = new File(path = Environment.getExternalStorageDirectory() + File.separator + "KsdkTemp")).exists()) {
                    filePath.mkdirs();
                }
            }
            return filePath;
        }
    }

    class RequestAsyncTask
    extends AsyncTask<Void, Void, ResultData<?>> {
        private BaseConnectionClient.CONNECTION_TYPE restRequestType = BaseConnectionClient.CONNECTION_TYPE.POST;
        private ApiResultCallback<?> mResultCallback;
        private int numOfReconnectionsOnFail = 0;
        private SdkRequestType sdkRequestType;
        private ContentValues mContentValues;
        private Call mCall;
        private Context mContext;

        public RequestAsyncTask(Context context, BaseConnectionClient.CONNECTION_TYPE type, SdkRequestType requestType, ContentValues contentValues, int numOfReconnecsOnFail, ApiResultCallback<?> resultCallback) {
            this.mContext = context;
            this.restRequestType = type;
            this.sdkRequestType = requestType;
            this.mContentValues = contentValues;
            this.mResultCallback = resultCallback;
            this.restRequestType = type;
        }

        protected ResultData<?> doInBackground(Void ... params) {
            String dataResponce = null;
            ResultData<Object> webServiceResult = null;
            int mReconnectionTries = 0;
            if (!this.isCancelled()) {
                Response response = null;
                while (mReconnectionTries <= this.numOfReconnectionsOnFail) {
                    ++mReconnectionTries;
                    if (this.isCancelled()) break;
                    try {
                        if (this.restRequestType == BaseConnectionClient.CONNECTION_TYPE.POST) {
                            SDKLogger.printPostRequestDebugLog(BaseConnectionClient.MAIN_SERVER_URL, this.mContentValues, this.sdkRequestType.name());
                            this.mCall = BaseConnectionClient.makePostConnection(BaseConnectionClient.MAIN_SERVER_URL, this.mContentValues, this.sdkRequestType.name());
                            if (this.mCall != null) {
                                response = this.mCall.execute();
                            }
                        } else {
                            SDKLogger.printGetRequestDebugLog(BaseConnectionClient.MAIN_SERVER_URL, this.mContentValues, this.sdkRequestType.name());
                            this.mCall = BaseConnectionClient.makeGetConnection(BaseConnectionClient.MAIN_SERVER_URL, this.mContentValues, this.sdkRequestType.name());
                            if (this.mCall != null) {
                                response = this.mCall.execute();
                            }
                        }
                    }
                    catch (IOException e) {
                        SDKLogger.printErrorLog(" \n IO Exception On [" + this.sdkRequestType.name() + "] request! \n" + e.getMessage());
                    }
                    if (response != null) {
                        SDKLogger.printDebbugLog(" \n SDK Responce Message : " + response.message());
                        if (this.isCancelled()) break;
                        if (response.isSuccessful()) {
                            try {
                                SDKLogger.printDebbugLog(" \n Succesfull connection ! , Code :  " + response.code());
                                dataResponce = StreamToStringConverter.readStream(new BufferedInputStream(response.body().byteStream()), this, true);
                                break;
                            }
                            catch (IOException e) {
                                SDKLogger.printErrorLog(" \n Unable to convertByte Stream to String! : \n\n" + e.getMessage());
                            }
                        } else {
                            SDKLogger.printErrorLog(" \n Server connectivity Error!  Code : " + response.code());
                        }
                    }
                    try {
                        if (this.isCancelled()) break;
                        Thread.sleep(300 * mReconnectionTries * 2);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
            }
            SDKLogger.printResponce(dataResponce, this.sdkRequestType.name());
            if (this.isCancelled()) {
                return null;
            }
            if (dataResponce != null) {
                if (!this.isCancelled()) {
                    switch (this.sdkRequestType) {
                        case LOAD_SDK_CONTENT: {
                            ContentData contentData = new ContentData();
                            contentData.decodeResponse(dataResponce);
                            ResultData<Object> resultData = new ResultData();
                            resultData.setData(contentData);
                            webServiceResult = resultData;
                            break;
                        }
                        case VALIDATE_SDK: {
                            ResponseStatus responseStatus;
                            ResultData<Object> resultData;
                            try {
                                responseStatus = new ResponseStatus(dataResponce);
                                resultData = new ResultData<Object>();
                                resultData.setResponseStatus(responseStatus);
                                if (responseStatus.getIsSuccessful()) {
                                    JSONObject jSONObject = new JSONObject(dataResponce);
                                    PropertiesObj propertiesObj = new PropertiesObj(jSONObject.optJSONObject("data"));
                                    resultData.setData(propertiesObj);
                                }
                                webServiceResult = resultData;
                            }
                            catch (Exception ex) {
                                SDKLogger.printErrorLog(TAG, "Error when trying to parse validate SDK: " + ex.getMessage());
                            }
                            break;
                        }
                        case GET_SDK_RESOURCES: {
                            ResponseStatus responseStatus;
                            ResultData<Object> resultData;
                            try {
                                SDKLogger.printDebbugLog(TAG, ">>>>dataResponce = \n" + dataResponce);
                                responseStatus = new ResponseStatus(dataResponce);
                                resultData = new ResultData();
                                resultData.setResponseStatus(responseStatus);
                                if (responseStatus.getIsSuccessful()) {
                                    boolean isAssetsReady = AppAssetsUtils.parseAssets(this.mContext, dataResponce);
                                    boolean isLockIconsReady = AppAssetsUtils.parseLockIcons(this.mContext, dataResponce);
                                    resultData.setData(isAssetsReady || isLockIconsReady);
                                }
                                webServiceResult = resultData;
                                break;
                            }
                            catch (Exception ex) {
                                SDKLogger.printErrorLog(TAG, "Error when trying to parse get SDK resources: " + ex.getMessage());
                            }
                        }
                    }
                }
                return webServiceResult;
            }
            return null;
        }

        protected void onPostExecute(ResultData<?> result) {
            if (!this.isCancelled()) {
                if (result == null) {
                    if (this.mResultCallback != null) {
                        this.mResultCallback.onFailed();
                    }
                } else if (this.mResultCallback != null) {
                    this.mResultCallback.onServerResult(result);
                }
            }
            BaseAPIManager.this.runningTaskList.remove((Object)this.sdkRequestType);
        }

        protected void onCancelled() {
            super.onCancelled();
            if (this.sdkRequestType != null && BaseAPIManager.this.runningTaskList != null) {
                BaseAPIManager.this.runningTaskList.remove((Object)this.sdkRequestType);
            }
        }

        public void closeCurrentConnection() {
            if (this.mCall != null && !this.mCall.isCanceled()) {
                this.mCall.cancel();
            }
        }

        public String getRequestTag() {
            return this.sdkRequestType.name();
        }
    }
}

