/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players.web_player;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.Point;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.general.custom_views.KidozTopBar;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.players.web_player.KidozWebView;
import com.kidoz.sdk.api.players.web_player.WebPlayerType;

public class WebPlayerView
extends FrameLayout {
    private static final int DEFAULT_TOP_BAR_COLOR = Color.parseColor((String)"#36a7ec");
    private RelativeLayout mInnerContainer;
    private KidozTopBar mKidozTopBar;
    private KidozWebView mKidozWebView;
    private WebPlayerType mWebPlayerType;
    private View.OnClickListener mCloseBtnClickListener = null;
    private IOnRemoveViewRequestListener mRemoveViewRequestListener;

    public WebPlayerView(Context context, WebPlayerType webPlayerType) {
        super(context);
        if (webPlayerType != null && webPlayerType == WebPlayerType.EXTERNAL_LINK) {
            this.setAlpha(0.0f);
        } else {
            this.setAlpha(1.0f);
        }
        this.mWebPlayerType = webPlayerType;
        this.initiateView();
    }

    private void initiateView() {
        this.mInnerContainer = new RelativeLayout(this.getContext());
        this.mInnerContainer.setBackgroundColor(-1);
        this.addView((View)this.mInnerContainer, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.initWebView();
        this.initTopBar();
    }

    private void initTopBar() {
        Point point = Utils.getScreenSize(this.getContext());
        this.mKidozTopBar = new KidozTopBar(this.getContext(), true);
        this.mKidozTopBar.setId(Utils.generateViewId());
        this.mKidozTopBar.setTopBarBackgroundColor(DEFAULT_TOP_BAR_COLOR);
        this.mKidozTopBar.setKidozTopBarListener(new KidozTopBar.KidozTopBarListener(){

            @Override
            public void onExitClicked(View view) {
                if (WebPlayerView.this.mCloseBtnClickListener != null) {
                    WebPlayerView.this.mCloseBtnClickListener.onClick(view);
                }
            }
        });
        this.mKidozTopBar.showParentalLockIcon(false);
        this.mInnerContainer.addView((View)this.mKidozTopBar, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -2));
    }

    private void initWebView() {
        int paddingTop;
        this.mKidozWebView = new KidozWebView(this.getContext(), this.mWebPlayerType);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        Point point = Utils.getScreenSize(this.getContext());
        params.topMargin = paddingTop = (int)((float)Math.max(point.x, point.y) * 0.061458334f);
        this.mInnerContainer.addView((View)this.mKidozWebView, (ViewGroup.LayoutParams)params);
        this.mKidozWebView.setOnLounchExternalAppFromRedirect(new KidozWebView.IOnLounchExternalAppFromRedirectListener(){

            @Override
            public void onLounch() {
                if (WebPlayerView.this.mRemoveViewRequestListener != null) {
                    WebPlayerView.this.mRemoveViewRequestListener.onRemoveView();
                }
            }
        });
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    public void loadWebUrl(String url, String googlePlayAppId, String title) {
        this.mKidozWebView.loadWebUrl(url, googlePlayAppId);
        if (title != null) {
            this.mKidozTopBar.setTitle(title);
        } else {
            this.mKidozTopBar.setTitle("");
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mKidozWebView != null) {
            this.mKidozWebView.stopLoading();
        }
    }

    public void setOnCloseButtonClickListenr(View.OnClickListener clickListener) {
        this.mCloseBtnClickListener = clickListener;
    }

    public void setOnRemoveViewRequestListener(IOnRemoveViewRequestListener listener) {
        this.mRemoveViewRequestListener = listener;
    }

    public void releseAndcloseView() {
        if (this.mKidozWebView != null) {
            this.mKidozWebView.stopAndReleaseWebView();
        }
    }

    public static interface IOnRemoveViewRequestListener {
        public void onRemoveView();
    }
}

