/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players.web_player;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.players.web_player.WebPlayerType;
import com.kidoz.sdk.api.players.web_player.WebPlayerView;
import com.kidoz.sdk.api.structure.ContentItem;
import java.io.Serializable;

public class WebPlayerFragmentDialog
extends DialogFragment {
    private static final String TAG = WebPlayerFragmentDialog.class.getSimpleName();
    private static final int WEB_PLAYER_RESOURCE_ID = 1;
    private static final String CONTENT_ITEM_SAVE_STATE_KEY = "CONTENT_ITEM_SAVE_STATE_KEY";
    private static final String WEB_PLAYER_TYPE_SAVE_STATE_KEY = "WEB_PLAYER_TYPE_SAVE_STATE_KEY";
    private static final String ORIENTATION_STATE_SAVE_STATE_KEY = "ORIENTATION_STATE_SAVE_STATE_KEY";
    private static final String EVENT_ID_STATE_SAVE_STATE_KEY = "EVENT_ID_STATE_SAVE_STATE_KEY";
    private ContentItem mContentItem;
    private WebPlayerType mWebPlayerType;
    private WebPlayerView mWebPlayerView;
    private int mCurrentOrientationState = -1;
    private long mEventID;

    public static WebPlayerFragmentDialog newInstance(ContentItem contentItem, WebPlayerType webPlayerType) {
        WebPlayerFragmentDialog f = new WebPlayerFragmentDialog();
        f.mContentItem = contentItem;
        f.mWebPlayerType = webPlayerType;
        return f;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        int style2 = 2;
        int theme = 16973834;
        if (this.mWebPlayerType != null && this.mWebPlayerType == WebPlayerType.EXTERNAL_LINK) {
            theme = 0x1030011;
        }
        this.setStyle(style2, theme);
        if (savedInstanceState != null && savedInstanceState.containsKey(ORIENTATION_STATE_SAVE_STATE_KEY)) {
            this.mCurrentOrientationState = savedInstanceState.getInt(ORIENTATION_STATE_SAVE_STATE_KEY);
        } else {
            this.mCurrentOrientationState = this.getResources().getConfiguration().orientation;
            this.getActivity().setRequestedOrientation(4);
        }
        this.setCancelable(true);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.getWindow().requestFeature(2);
        return dialog;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            if (savedInstanceState.containsKey(CONTENT_ITEM_SAVE_STATE_KEY)) {
                this.mContentItem = (ContentItem)savedInstanceState.getSerializable(CONTENT_ITEM_SAVE_STATE_KEY);
            }
            this.mWebPlayerType = (WebPlayerType)((Object)savedInstanceState.getSerializable(WEB_PLAYER_TYPE_SAVE_STATE_KEY));
            this.mEventID = savedInstanceState.getLong(EVENT_ID_STATE_SAVE_STATE_KEY);
        }
        this.mWebPlayerView = new WebPlayerView((Context)this.getActivity(), this.mWebPlayerType);
        if (this.mContentItem != null) {
            this.mWebPlayerView.loadWebUrl(this.mContentItem.getData(), this.mContentItem.getId(), this.mContentItem.getName());
        }
        this.mWebPlayerView.setOnCloseButtonClickListenr(new View.OnClickListener(){

            public void onClick(View v) {
                WebPlayerFragmentDialog.this.closeDialog(WebPlayerFragmentDialog.this.getFragmentManager());
            }
        });
        this.mWebPlayerView.setOnRemoveViewRequestListener(new WebPlayerView.IOnRemoveViewRequestListener(){

            @Override
            public void onRemoveView() {
                WebPlayerFragmentDialog.this.closeDialog(WebPlayerFragmentDialog.this.getFragmentManager());
            }
        });
        return this.mWebPlayerView;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putSerializable(CONTENT_ITEM_SAVE_STATE_KEY, (Serializable)this.mContentItem);
        outState.putSerializable(WEB_PLAYER_TYPE_SAVE_STATE_KEY, (Serializable)((Object)this.mWebPlayerType));
        outState.putSerializable(ORIENTATION_STATE_SAVE_STATE_KEY, (Serializable)Integer.valueOf(this.mCurrentOrientationState));
        outState.putSerializable(EVENT_ID_STATE_SAVE_STATE_KEY, (Serializable)Long.valueOf(this.mEventID));
    }

    public void openDialog(final FragmentManager fragmentManager) {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                try {
                    FragmentTransaction ft = fragmentManager.beginTransaction();
                    ft.setTransition(4097);
                    Fragment prev = fragmentManager.findFragmentByTag(TAG);
                    if (prev != null) {
                        ft.remove(prev);
                    } else if (!WebPlayerFragmentDialog.this.isAdded()) {
                        ft.addToBackStack(null);
                        WebPlayerFragmentDialog.this.show(fragmentManager, TAG);
                    }
                }
                catch (Exception ex) {
                    SDKLogger.printDebbugLog(TAG, "Error when trying to open dialog: " + ex.getMessage());
                }
            }
        });
    }

    public void closeDialog(FragmentManager fragmentManager) {
        try {
            FragmentTransaction ft = fragmentManager.beginTransaction();
            ft.setTransition(8194);
            Fragment prev = fragmentManager.findFragmentByTag(TAG);
            if (prev != null) {
                ft.remove(prev);
            }
            this.restoreUserOriginalOrientation();
            if (this != null) {
                this.dismissAllowingStateLoss();
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to close web player: " + ex.getMessage());
        }
    }

    public void onDetach() {
        super.onDetach();
        if (this.mWebPlayerView != null) {
            try {
                this.mWebPlayerView.releseAndcloseView();
            }
            catch (Exception ex) {
                SDKLogger.printDebbugLog(TAG, "Error when trying to onDetach: " + ex.getMessage());
            }
        }
    }

    public void onResume() {
        super.onResume();
        String activityName = "";
        String action = "";
        switch (this.mWebPlayerType) {
            case EXTERNAL_LINK: {
                activityName = "Web Player External Link";
                action = "Web External Link View";
                break;
            }
            case ONLINE_GAME: {
                activityName = "Web Player Online Game";
                action = "Online Games Player View";
                break;
            }
            case WEB_BROWSER: {
                activityName = "Web Player Web Browser";
                action = "Website View";
            }
        }
        this.mEventID = EventManager.getInstance().activityStart((Context)this.getActivity(), EventManager.LOG_CRITICAL_LEVEL, activityName);
        EventManager.getInstance().logEventWithDuration((Context)this.getActivity(), EventManager.LOG_NORMAL_LEVEL, 1, EventManager.LOG_CLOSE_RESOURCE_LEVEL, "Web Player", action, this.mContentItem.getName(), this.mContentItem.getId());
    }

    public void onPause() {
        EventManager.getInstance().activityEnd((Context)this.getActivity(), EventManager.LOG_CRITICAL_LEVEL, this.mEventID);
        EventManager.getInstance().logEventWithDurationEnd((Context)this.getActivity(), 1);
        super.onPause();
    }

    private void restoreUserOriginalOrientation() {
        if (this.getActivity() != null && !this.getActivity().isFinishing()) {
            switch (this.mCurrentOrientationState) {
                case 2: {
                    this.getActivity().setRequestedOrientation(6);
                    break;
                }
                case 1: {
                    this.getActivity().setRequestedOrientation(7);
                    break;
                }
                case 0: {
                    this.getActivity().setRequestedOrientation(4);
                }
            }
        }
    }
}

