/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players.web_player;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.BaseDialog;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.players.web_player.WebPlayerType;
import com.kidoz.sdk.api.players.web_player.WebPlayerView;
import com.kidoz.sdk.api.structure.ContentItem;
import java.io.Serializable;

public class WebPlayerDialog
extends BaseDialog {
    private static final String TAG = WebPlayerDialog.class.getSimpleName();
    private static final String SAVE_DATA_INSTANCE_KEY = "SAVE_DATA_INSTANCE_KEY";
    private static final String SAVE_ORIGINAL_ORIENTATION_KEY = "SAVE_ORIGINAL_ORIENTATION_KEY";
    private static final int WEB_PLAYER_RESOURCE_ID = 1;
    private static final String CONTENT_ITEM_SAVE_STATE_KEY = "CONTENT_ITEM_SAVE_STATE_KEY";
    private static final String WEB_PLAYER_TYPE_SAVE_STATE_KEY = "WEB_PLAYER_TYPE_SAVE_STATE_KEY";
    private static final String ORIENTATION_STATE_SAVE_STATE_KEY = "ORIENTATION_STATE_SAVE_STATE_KEY";
    private static final String EVENT_ID_STATE_SAVE_STATE_KEY = "EVENT_ID_STATE_SAVE_STATE_KEY";
    private ContentItem mContentItem;
    private WebPlayerType mWebPlayerType;
    private WebPlayerView mWebPlayerView;
    private int mCurrentOrientationState = -1;
    private long mEventID;

    public WebPlayerDialog(Context context, ContentItem contentItem, WebPlayerType webPlayerType) {
        super(context, 16973834);
        this.setCancelable(true);
        this.mContentItem = contentItem;
        this.mWebPlayerType = webPlayerType;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null && savedInstanceState.containsKey(ORIENTATION_STATE_SAVE_STATE_KEY)) {
            this.mCurrentOrientationState = savedInstanceState.getInt(ORIENTATION_STATE_SAVE_STATE_KEY);
        } else if (this.mCallingActivity instanceof Activity && !this.mCallingActivity.isFinishing()) {
            this.mCurrentOrientationState = this.mCallingActivity.getResources().getConfiguration().orientation;
            this.mCallingActivity.setRequestedOrientation(4);
        }
        if (savedInstanceState != null) {
            if (savedInstanceState.containsKey(CONTENT_ITEM_SAVE_STATE_KEY)) {
                this.mContentItem = (ContentItem)savedInstanceState.getSerializable(CONTENT_ITEM_SAVE_STATE_KEY);
            }
            this.mWebPlayerType = (WebPlayerType)((Object)savedInstanceState.getSerializable(WEB_PLAYER_TYPE_SAVE_STATE_KEY));
            this.mEventID = savedInstanceState.getLong(EVENT_ID_STATE_SAVE_STATE_KEY);
        }
        this.mWebPlayerView = new WebPlayerView((Context)this.mCallingActivity, this.mWebPlayerType);
        if (this.mContentItem != null) {
            this.mWebPlayerView.loadWebUrl(this.mContentItem.getData(), this.mContentItem.getId(), this.mContentItem.getName());
        }
        this.mWebPlayerView.setOnCloseButtonClickListenr(new View.OnClickListener(){

            public void onClick(View v) {
                WebPlayerDialog.this.closeDialog();
            }
        });
        this.mWebPlayerView.setOnRemoveViewRequestListener(new WebPlayerView.IOnRemoveViewRequestListener(){

            @Override
            public void onRemoveView() {
                WebPlayerDialog.this.closeDialog();
            }
        });
        this.setContentView((View)this.mWebPlayerView);
    }

    protected void onStart() {
        super.onStart();
    }

    protected void onStop() {
        super.onStop();
    }

    public Bundle onSaveInstanceState() {
        Bundle bundle = super.onSaveInstanceState();
        if (bundle != null) {
            bundle.putSerializable(CONTENT_ITEM_SAVE_STATE_KEY, (Serializable)this.mContentItem);
            bundle.putSerializable(WEB_PLAYER_TYPE_SAVE_STATE_KEY, (Serializable)((Object)this.mWebPlayerType));
            bundle.putSerializable(ORIENTATION_STATE_SAVE_STATE_KEY, (Serializable)Integer.valueOf(this.mCurrentOrientationState));
            bundle.putSerializable(EVENT_ID_STATE_SAVE_STATE_KEY, (Serializable)Long.valueOf(this.mEventID));
        }
        return bundle;
    }

    @Override
    protected void closeDialog() {
        super.closeDialog();
        this.restoreUserOriginalOrientation();
        EventManager.getInstance().activityEnd(this.getContext(), EventManager.LOG_CRITICAL_LEVEL, this.mEventID);
        EventManager.getInstance().logEventWithDurationEnd(this.getContext(), 1);
    }

    @Override
    public void openDialog() {
        super.openDialog();
        String activityName = "";
        String action = "";
        switch (this.mWebPlayerType) {
            case EXTERNAL_LINK: {
                activityName = "Web Player External Link";
                action = "Web External Link View";
                break;
            }
            case ONLINE_GAME: {
                activityName = "Web Player Online Game";
                action = "Online Games Player View";
                break;
            }
            case WEB_BROWSER: {
                activityName = "Web Player Web Browser";
                action = "Website View";
            }
        }
        this.mEventID = EventManager.getInstance().activityStart(this.getContext(), EventManager.LOG_CRITICAL_LEVEL, activityName);
        EventManager.getInstance().logEventWithDuration(this.getContext(), EventManager.LOG_NORMAL_LEVEL, 1, EventManager.LOG_CLOSE_RESOURCE_LEVEL, "Web Player", action, this.mContentItem.getName(), this.mContentItem.getId());
    }

    private void restoreUserOriginalOrientation() {
        if (this.mCallingActivity != null && !this.mCallingActivity.isFinishing()) {
            switch (this.mCurrentOrientationState) {
                case 2: {
                    this.mCallingActivity.setRequestedOrientation(6);
                    break;
                }
                case 1: {
                    this.mCallingActivity.setRequestedOrientation(7);
                    break;
                }
                case 0: {
                    this.mCallingActivity.setRequestedOrientation(4);
                }
            }
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mWebPlayerView != null) {
            try {
                this.mWebPlayerView.releseAndcloseView();
            }
            catch (Exception ex) {
                SDKLogger.printDebbugLog(TAG, "Error when trying to onDetach: " + ex.getMessage());
            }
        }
    }
}

