/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players.web_player;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.players.web_player.WebPlayerType;
import com.kidoz.sdk.api.players.web_player.WebPlayerView;
import com.kidoz.sdk.api.structure.ContentItem;

public class WebPlayerActivity
extends FragmentActivity {
    private static final String TAG = WebPlayerActivity.class.getSimpleName();
    public static final String EXTRA_CONTENT_ITEM_KEY = "EXTRA_CONTENT_ITEM_KEY";
    public static final String EXTRA_WEB_PLAYER_TYPE_KEY = "EXTRA_WEB_PLAYER_TYPE_KEY";
    private ContentItem mContentItem;
    private WebPlayerType mWebPlayerType;
    private WebPlayerView mWebPlayerView;
    private int mCurrentOrientationState;
    private long mEventID;
    private static final int mWebPlayerResourceID = 1;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ScreenUtils.hideNavigationAndStatusBar(this.getWindow());
        this.mCurrentOrientationState = this.getResources().getConfiguration().orientation;
        this.setRequestedOrientation(4);
        Intent intent = this.getIntent();
        if (intent != null) {
            this.mContentItem = (ContentItem)intent.getSerializableExtra(EXTRA_CONTENT_ITEM_KEY);
            this.mWebPlayerType = (WebPlayerType)((Object)intent.getSerializableExtra(EXTRA_WEB_PLAYER_TYPE_KEY));
            if (this.mContentItem != null && this.mWebPlayerType != null) {
                this.initActivityView();
                this.setContentView((View)this.mWebPlayerView);
            } else {
                this.finish();
            }
        } else {
            this.finish();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.setRequestedOrientation(this.mCurrentOrientationState);
        if (this.mWebPlayerView != null) {
            try {
                this.mWebPlayerView.releseAndcloseView();
            }
            catch (Exception ex) {
                SDKLogger.printDebbugLog(TAG, "Error when trying to onDetach: " + ex.getMessage());
            }
        }
    }

    private void initActivityView() {
        this.mWebPlayerView = new WebPlayerView((Context)this, this.mWebPlayerType);
        this.mWebPlayerView.loadWebUrl(this.mContentItem.getData(), this.mContentItem.getId(), this.mContentItem.getName());
        this.mWebPlayerView.setOnCloseButtonClickListenr(new View.OnClickListener(){

            public void onClick(View v) {
                WebPlayerActivity.this.finish();
            }
        });
        this.mWebPlayerView.setOnRemoveViewRequestListener(new WebPlayerView.IOnRemoveViewRequestListener(){

            @Override
            public void onRemoveView() {
                WebPlayerActivity.this.finish();
            }
        });
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        ScreenUtils.hideNavigationAndStatusBar(this.getWindow());
    }

    public void onResume() {
        super.onResume();
        String activityName = "";
        String action = "";
        switch (this.mWebPlayerType) {
            case EXTERNAL_LINK: {
                activityName = "Web Player External Link";
                action = "Web External Link View";
                break;
            }
            case ONLINE_GAME: {
                activityName = "Web Player Online Game";
                action = "Online Games Player View";
                break;
            }
            case WEB_BROWSER: {
                activityName = "Web Player Web Browser";
                action = "Website View";
            }
        }
        this.mEventID = EventManager.getInstance().activityStart((Context)this, EventManager.LOG_CRITICAL_LEVEL, activityName);
        EventManager.getInstance().logEventWithDuration((Context)this, EventManager.LOG_NORMAL_LEVEL, 1, EventManager.LOG_CLOSE_RESOURCE_LEVEL, "Web Player", action, this.mContentItem.getName(), this.mContentItem.getId());
    }

    public void onPause() {
        EventManager.getInstance().activityEnd((Context)this, EventManager.LOG_CRITICAL_LEVEL, this.mEventID);
        EventManager.getInstance().logEventWithDurationEnd((Context)this, 1);
        super.onPause();
    }
}

