/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players.video_player;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentTransaction;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.google.android.youtube.player.YouTubeInitializationResult;
import com.google.android.youtube.player.YouTubePlayer;
import com.google.android.youtube.player.YouTubePlayerSupportFragment;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.custom_views.KidozTopBar;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.Utils;

public class YouTubePlayerActivity
extends FragmentActivity
implements YouTubePlayer.OnInitializedListener {
    private static final String TAG = YouTubePlayerActivity.class.getSimpleName();
    public static final String INTENT_EXTRA_VIDEO_ID = "INTENT_EXTRA_VIDEO_ID";
    public static final String INTENT_EXTRA_VIDEO_NAME = "INTENT_EXTRA_VIDEO_NAME";
    public static final String INTENT_EXTRA_CONTENT_ITEM_ID = "INTENT_EXTRA_CONTENT_ITEM_ID";
    public static final String INTENT_EXTRA_TOP_BAR_COLOR = "INTENT_EXTRA_TOP_BAR_COLOR";
    private static int VIDEO_FRAME_CONTAINER_LAYOUT_ID;
    private YouTubePlayerSupportFragment mYouTubePlayerSupportFragment;
    private YouTubePlayer mYouTubePlayer;
    private KidozTopBar mKidozTopBar;
    private String mVideoID;
    private String mVideoName;
    private long mEventID;
    private static final int mVideoPlayerResourceID = 1;

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        ScreenUtils.hideNavigationAndStatusBar(this.getWindow());
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(this.generateViewLayout());
        this.initActivity();
    }

    private void initActivity() {
        this.getVideoIDFromIntent();
        this.initVideoFragment();
        this.initTopBar();
    }

    private View generateViewLayout() {
        LinearLayout mRootView = new LinearLayout((Context)this);
        mRootView.setOrientation(1);
        mRootView.setBackgroundColor(-16777216);
        this.mKidozTopBar = new KidozTopBar((Context)this, true);
        mRootView.addView((View)this.mKidozTopBar, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        FrameLayout container = new FrameLayout((Context)this);
        VIDEO_FRAME_CONTAINER_LAYOUT_ID = Utils.generateViewId();
        container.setId(VIDEO_FRAME_CONTAINER_LAYOUT_ID);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1);
        params.weight = 1.0f;
        mRootView.addView((View)container, (ViewGroup.LayoutParams)params);
        return mRootView;
    }

    private void initTopBar() {
        this.mVideoName = null;
        if (this.mKidozTopBar != null) {
            Intent intent = this.getIntent();
            if (intent != null && intent.hasExtra(INTENT_EXTRA_VIDEO_NAME)) {
                this.mVideoName = intent.getStringExtra(INTENT_EXTRA_VIDEO_NAME);
            } else if (intent == null || intent.hasExtra(INTENT_EXTRA_TOP_BAR_COLOR)) {
                // empty if block
            }
            this.mKidozTopBar.setTitle(this.mVideoName);
            this.mKidozTopBar.showParentalLockIcon(false);
            this.mKidozTopBar.setKidozTopBarListener(new KidozTopBar.KidozTopBarListener(){

                @Override
                public void onExitClicked(View view) {
                    YouTubePlayerActivity.this.finish();
                }
            });
        }
    }

    private void getVideoIDFromIntent() {
        Intent intent = this.getIntent();
        if (intent != null && intent.hasExtra(INTENT_EXTRA_VIDEO_ID)) {
            this.mVideoID = intent.getStringExtra(INTENT_EXTRA_VIDEO_ID);
        }
    }

    private void initVideoFragment() {
        this.mYouTubePlayerSupportFragment = YouTubePlayerSupportFragment.newInstance();
        this.mYouTubePlayerSupportFragment.initialize("AIzaSyCO0ANo6o7l286UdA4LHBvzTZ6Aza79lTc", (YouTubePlayer.OnInitializedListener)this);
        FragmentTransaction fragmentTransaction = this.getSupportFragmentManager().beginTransaction();
        fragmentTransaction.replace(VIDEO_FRAME_CONTAINER_LAYOUT_ID, (Fragment)this.mYouTubePlayerSupportFragment, "YoutubeVideoPlayer");
        fragmentTransaction.commit();
    }

    public void onInitializationSuccess(YouTubePlayer.Provider provider, YouTubePlayer youTubePlayer, boolean restored) {
        this.mYouTubePlayer = youTubePlayer;
        this.mYouTubePlayer.setPlayerStyle(YouTubePlayer.PlayerStyle.DEFAULT);
        this.mYouTubePlayer.addFullscreenControlFlag(8);
        this.mYouTubePlayer.setOnFullscreenListener(new YouTubePlayer.OnFullscreenListener(){

            public void onFullscreen(boolean isFullScreen) {
                if (isFullScreen) {
                    YouTubePlayerActivity.this.setRequestedOrientation(0);
                } else {
                    YouTubePlayerActivity.this.setRequestedOrientation(1);
                }
            }
        });
        if (!restored && this.mVideoID != null) {
            this.mYouTubePlayer.loadVideo(this.mVideoID);
        }
    }

    public void onInitializationFailure(YouTubePlayer.Provider provider, YouTubeInitializationResult result) {
    }

    public void onResume() {
        super.onResume();
        ScreenUtils.hideNavigationAndStatusBar(this.getWindow());
        if (this.mYouTubePlayer != null) {
            this.mYouTubePlayer.play();
        }
        this.mEventID = EventManager.getInstance().activityStart((Context)this, EventManager.LOG_CRITICAL_LEVEL, "YouTube Player");
        EventManager.getInstance().logEventWithDuration((Context)this, EventManager.LOG_NORMAL_LEVEL, 1, EventManager.LOG_CLOSE_RESOURCE_LEVEL, "Video Player", "Video Player View", this.mVideoName, this.mVideoID);
    }

    public void onPause() {
        EventManager.getInstance().activityEnd((Context)this, EventManager.LOG_CRITICAL_LEVEL, this.mEventID);
        if (this.mYouTubePlayer != null) {
            this.mYouTubePlayer.pause();
            EventManager.getInstance().logEventWithDurationEnd((Context)this, 1);
        }
        super.onPause();
    }

    public void onDestroy() {
        if (this.mYouTubePlayer != null) {
            try {
                this.mYouTubePlayer.pause();
                this.mYouTubePlayer.release();
                this.mYouTubePlayer = null;
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(TAG, "Error when trying to release youtube player: " + ex.getMessage());
            }
        }
        super.onDestroy();
    }
}

