/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.utils;

import android.content.Context;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.picasso_related.PicassoOk;
import com.kidoz.sdk.api.server_connect.BaseConnectionClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class AppAssetsUtils {
    private static final String TAG = AppAssetsUtils.class.getSimpleName();
    private static final String DATA = "data";
    private static final String ASSETS = "assets";
    private static final String ASSET_NAME = "name";
    private static final String IMAGE_URL = "imageURL";
    private static final String IMAGE_WIDTH = "width";
    private static final String IMAGE_HEIGHT = "height";
    private static final String ANIMATION_TYPE = "animationType";
    private static final String LOCK_ICONS = "lock_icons";
    private static final String BACK_BUTTON = "backButton";
    public static final String BACK_BUTTON_WIDTH = "BACK_BUTTON_WIDTH";
    public static final String BACK_BUTTON_HEIGHT = "BACK_BUTTON_HEIGHT";
    public static final String BACK_BUTTON_ANIMATION_TYPE = "BACK_BUTTON_ANIMATION_TYPE";
    private static final String EXIT_BUTTON = "exitButton";
    public static final String EXIT_BUTTON_WIDTH = "EXIT_BUTTON_WIDTH";
    public static final String EXIT_BUTTON_HEIGHT = "EXIT_BUTTON_HEIGHT";
    public static final String EXIT_BUTTON_ANIMATION_TYPE = "EXIT_BUTTON_ANIMATION_TYPE";
    private static final String LOCK_ACTIVE_BUTTON = "lockActiveButton";
    public static final String LOCK_ACTIVE_BUTTON_WIDTH = "LOCK_ACTIVE_BUTTON_WIDTH";
    public static final String LOCK_ACTIVE_BUTTON_HEIGHT = "LOCK_ACTIVE_BUTTON_HEIGHT";
    public static final String LOCK_ACTIVE_BUTTON_ANIMATION_TYPE = "LOCK_ACTIVE_BUTTON_ANIMATION_TYPE";
    private static final String LOCK_NOT_ACTIVE_BUTTON = "lockNotActiveButton";
    public static final String LOCK_NOT_ACTIVE_BUTTON_WIDTH = "LOCK_NOT_ACTIVE_BUTTON_WIDTH";
    public static final String LOCK_NOT_ACTIVE_BUTTON_HEIGHT = "LOCK_NOT_ACTIVE_BUTTON_HEIGHT";
    public static final String LOCK_NOT_ACTIVE_BUTTON_ANIMATION_TYPE = "LOCK_NOT_ACTIVE_BUTTON_ANIMATION_TYPE";
    private static final String ON_BOARDING_BACKGROUND = "onBoardingBackground";
    public static final String ON_BOARDING_BACKGROUND_WIDTH = "ON_BOARDING_BACKGROUND_WIDTH";
    public static final String ON_BOARDING_BACKGROUND_HEIGHT = "ON_BOARDING_BACKGROUND_HEIGHT";
    public static final String ON_BOARDING_BACKGROUND_ANIMATION_TYPE = "LOCK_NOT_ACTIVE_BUTTON_ANIMATION_TYPE";
    private static final String TOP_BAR_TITLE = "topBarTitleBackground";
    public static final String TOP_BAR_TITLE_WIDTH = "TOP_BAR_TITLE_WIDTH";
    public static final String TOP_BAR_TITLE_HEIGHT = "TOP_BAR_TITLE_HEIGHT";
    private static final String BOTTOM_BAR = "bottomBarBackground";
    public static final String BOTTOM_BAR_WIDTH = "BOTTOM_BAR_WIDTH";
    public static final String BOTTOM_BAR_HEIGHT = "BOTTOM_BAR_HEIGHT";
    public static final String LOCK_ICON_PREFIX = "LockIcon_";
    private static final String PANEL_BUTTON = "panelButton";
    public static final String PANEL_BUTTON_WIDTH = "PANEL_BUTTON_WIDTH";
    public static final String PANEL_BUTTON_HEIGHT = "PANEL_BUTTON_HEIGHT";
    public static final String PANEL_BUTTON_ANIMATION = "PANEL_BUTTON_ANIMATION";

    public static boolean parseAssets(Context context, String dataResponse) {
        boolean result = false;
        if (dataResponse != null) {
            try {
                JSONArray assets;
                JSONObject rootObject = new JSONObject(dataResponse);
                JSONObject data = rootObject.optJSONObject(DATA);
                if (data != null && (assets = data.optJSONArray(ASSETS)) != null) {
                    HashMap<String, Integer> keysHashMap = new HashMap<String, Integer>();
                    JSONArray keysJSONArray = assets.getJSONArray(0);
                    for (int keyIndex = 0; keyIndex < keysJSONArray.length(); ++keyIndex) {
                        keysHashMap.put(keysJSONArray.getString(keyIndex), keyIndex);
                    }
                    for (int assetIndex = 1; assetIndex < assets.length(); ++assetIndex) {
                        result = false;
                        JSONArray nextJSONArray = assets.getJSONArray(assetIndex);
                        String assetName = nextJSONArray.getString(((Integer)keysHashMap.get(ASSET_NAME)).intValue());
                        String imageURL = nextJSONArray.getString(((Integer)keysHashMap.get(IMAGE_URL)).intValue());
                        String imageWidth = nextJSONArray.getString(((Integer)keysHashMap.get(IMAGE_WIDTH)).intValue());
                        String imageHeight = nextJSONArray.getString(((Integer)keysHashMap.get(IMAGE_HEIGHT)).intValue());
                        String animationType = nextJSONArray.getString(((Integer)keysHashMap.get(ANIMATION_TYPE)).intValue());
                        if (assetName.equals(BACK_BUTTON)) {
                            if (!BaseConnectionClient.downloadAndSaveFile(imageURL, AppAssetsUtils.getAssetFile(context, APP_ASSET_TYPE.BACK_BUTTON))) continue;
                            SharedPreferencesUtils.saveSharedPreferencesData(context, BACK_BUTTON_WIDTH, imageWidth, 0);
                            SharedPreferencesUtils.saveSharedPreferencesData(context, BACK_BUTTON_HEIGHT, imageHeight, 0);
                            SharedPreferencesUtils.saveSharedPreferencesData(context, BACK_BUTTON_ANIMATION_TYPE, animationType, 0);
                            result = true;
                            continue;
                        }
                        if (assetName.equals(EXIT_BUTTON)) {
                            if (!BaseConnectionClient.downloadAndSaveFile(imageURL, AppAssetsUtils.getAssetFile(context, APP_ASSET_TYPE.EXIT_BUTTON))) continue;
                            SharedPreferencesUtils.saveSharedPreferencesData(context, EXIT_BUTTON_WIDTH, imageWidth, 0);
                            SharedPreferencesUtils.saveSharedPreferencesData(context, EXIT_BUTTON_HEIGHT, imageHeight, 0);
                            SharedPreferencesUtils.saveSharedPreferencesData(context, EXIT_BUTTON_ANIMATION_TYPE, animationType, 0);
                            result = true;
                            continue;
                        }
                        if (assetName.equals(LOCK_ACTIVE_BUTTON)) {
                            if (!BaseConnectionClient.downloadAndSaveFile(imageURL, AppAssetsUtils.getAssetFile(context, APP_ASSET_TYPE.LOCK_ACTIVE_BUTTON))) continue;
                            SharedPreferencesUtils.saveSharedPreferencesData(context, LOCK_ACTIVE_BUTTON_WIDTH, imageWidth, 0);
                            SharedPreferencesUtils.saveSharedPreferencesData(context, LOCK_ACTIVE_BUTTON_HEIGHT, imageHeight, 0);
                            SharedPreferencesUtils.saveSharedPreferencesData(context, LOCK_ACTIVE_BUTTON_ANIMATION_TYPE, animationType, 0);
                            result = true;
                            continue;
                        }
                        if (assetName.equals(LOCK_NOT_ACTIVE_BUTTON)) {
                            if (!BaseConnectionClient.downloadAndSaveFile(imageURL, AppAssetsUtils.getAssetFile(context, APP_ASSET_TYPE.LOCK_NOT_ACTIVE_BUTTON))) continue;
                            SharedPreferencesUtils.saveSharedPreferencesData(context, LOCK_NOT_ACTIVE_BUTTON_WIDTH, imageWidth, 0);
                            SharedPreferencesUtils.saveSharedPreferencesData(context, LOCK_NOT_ACTIVE_BUTTON_HEIGHT, imageHeight, 0);
                            SharedPreferencesUtils.saveSharedPreferencesData(context, "LOCK_NOT_ACTIVE_BUTTON_ANIMATION_TYPE", animationType, 0);
                            result = true;
                            continue;
                        }
                        if (assetName.equals(ON_BOARDING_BACKGROUND)) {
                            if (!BaseConnectionClient.downloadAndSaveFile(imageURL, AppAssetsUtils.getAssetFile(context, APP_ASSET_TYPE.ON_BOARDING_BACKGROUND))) continue;
                            SharedPreferencesUtils.saveSharedPreferencesData(context, ON_BOARDING_BACKGROUND_WIDTH, imageWidth, 0);
                            SharedPreferencesUtils.saveSharedPreferencesData(context, ON_BOARDING_BACKGROUND_HEIGHT, imageHeight, 0);
                            SharedPreferencesUtils.saveSharedPreferencesData(context, "LOCK_NOT_ACTIVE_BUTTON_ANIMATION_TYPE", animationType, 0);
                            result = true;
                            continue;
                        }
                        if (assetName.equals(TOP_BAR_TITLE)) {
                            if (!BaseConnectionClient.downloadAndSaveFile(imageURL, AppAssetsUtils.getAssetFile(context, APP_ASSET_TYPE.TOP_BAR_TITLE))) continue;
                            SharedPreferencesUtils.saveSharedPreferencesData(context, TOP_BAR_TITLE_WIDTH, imageWidth, 0);
                            SharedPreferencesUtils.saveSharedPreferencesData(context, TOP_BAR_TITLE_HEIGHT, imageHeight, 0);
                            result = true;
                            continue;
                        }
                        if (!assetName.equals(BOTTOM_BAR) || !BaseConnectionClient.downloadAndSaveFile(imageURL, AppAssetsUtils.getAssetFile(context, APP_ASSET_TYPE.BOTTOM_BAR))) continue;
                        SharedPreferencesUtils.saveSharedPreferencesData(context, BOTTOM_BAR_WIDTH, imageWidth, 0);
                        SharedPreferencesUtils.saveSharedPreferencesData(context, BOTTOM_BAR_HEIGHT, imageHeight, 0);
                        result = true;
                    }
                }
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(TAG, "Error when trying to parse assets: " + ex.getMessage());
            }
        }
        return result;
    }

    public static boolean parseLockIcons(Context context, String dataResponse) {
        boolean result = false;
        if (dataResponse != null) {
            try {
                JSONArray lockIcons;
                JSONObject rootObject = new JSONObject(dataResponse);
                JSONObject data = rootObject.optJSONObject(DATA);
                if (data != null && (lockIcons = data.optJSONArray(LOCK_ICONS)) != null) {
                    HashMap<String, Integer> keysHashMap = new HashMap<String, Integer>();
                    JSONArray keysJSONArray = lockIcons.getJSONArray(0);
                    for (int keyIndex = 0; keyIndex < keysJSONArray.length(); ++keyIndex) {
                        keysHashMap.put(keysJSONArray.getString(keyIndex), keyIndex);
                    }
                    JSONArray parentalLockConfiguration = new JSONArray();
                    for (int lockIconIndex = 1; lockIconIndex < lockIcons.length(); ++lockIconIndex) {
                        File directory;
                        File nextIconFile;
                        result = false;
                        JSONArray nextJSONArray = lockIcons.getJSONArray(lockIconIndex);
                        String iconName = nextJSONArray.getString(((Integer)keysHashMap.get(ASSET_NAME)).intValue());
                        String imageURL = nextJSONArray.getString(((Integer)keysHashMap.get("icon")).intValue());
                        boolean isDownloaded = BaseConnectionClient.downloadAndSaveFile(imageURL, nextIconFile = new File(directory = context.getFilesDir(), LOCK_ICON_PREFIX + iconName + ".png"));
                        if (isDownloaded) {
                            result = true;
                            JSONObject nextJSONObject = new JSONObject();
                            nextJSONObject.put("LockIconURL", (Object)imageURL);
                            nextJSONObject.put("LockIconName", (Object)iconName);
                            nextJSONObject.put("LockIconOnFS", (Object)(LOCK_ICON_PREFIX + iconName + ".png"));
                            parentalLockConfiguration.put((Object)nextJSONObject);
                            PicassoOk.getPicasso(context).load(LOCK_ICON_PREFIX + iconName + ".png").fetch();
                        }
                        SDKLogger.printDebbugLog(TAG, "Download next lock icon: " + iconName + " = " + Boolean.toString(isDownloaded));
                    }
                    AppAssetsUtils.saveParentalLockConfigurationFile(context, parentalLockConfiguration);
                }
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(TAG, "Error when trying to parse lock icons: " + ex.getMessage());
            }
        }
        return result;
    }

    private static void saveParentalLockConfigurationFile(Context context, JSONArray jSONArray) {
        String configurationFileName = "ConfigurationFile";
        try {
            File dir = context.getFilesDir();
            File file = new File(dir, configurationFileName);
            if (file.exists()) {
                file.delete();
            }
            FileOutputStream fileOutputStream = context.openFileOutput(configurationFileName, 0);
            fileOutputStream.write(jSONArray.toString().getBytes());
            fileOutputStream.close();
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to create configuration file: " + ex.getMessage());
        }
    }

    public static File getAssetFile(Context context, APP_ASSET_TYPE appAssetType) {
        File result = null;
        if (appAssetType != null) {
            File directory = context.getFilesDir();
            switch (appAssetType) {
                case EXIT_BUTTON: {
                    result = new File(directory, "ExitButton.png");
                    break;
                }
                case BACK_BUTTON: {
                    result = new File(directory, "BackButton.png");
                    break;
                }
                case LOCK_ACTIVE_BUTTON: {
                    result = new File(directory, "LockActiveButton.png");
                    break;
                }
                case LOCK_NOT_ACTIVE_BUTTON: {
                    result = new File(directory, "LockNotActiveButton.png");
                    break;
                }
                case TOP_BAR_TITLE: {
                    result = new File(directory, "TitleBackground.png");
                    break;
                }
                case ON_BOARDING_BACKGROUND: {
                    result = new File(directory, "OnBoardingBackground.png");
                    break;
                }
                case BOTTOM_BAR: {
                    result = new File(directory, "BottomBar.png");
                    break;
                }
                case PANEL_BUTTON_PARENTAL_LOCK: {
                    result = new File(directory, "PanelButtonParentalLock.png");
                    break;
                }
                case PANEL_BUTTON_ABOUT_KIDOZ: {
                    result = new File(directory, "PanelButtonAboutKidoz.png");
                    break;
                }
                case PANEL_BUTTON_EXIT: {
                    result = new File(directory, "PanelButtonExit.png");
                    break;
                }
                case PANEL_BUTTON_HANDLE: {
                    result = new File(directory, "PanelButtonHandle.png");
                }
            }
        }
        return result;
    }

    public static JSONArray loadParentalLockConfigurationFile(Context context) {
        JSONArray result = null;
        String configurationFileName = "ConfigurationFile";
        StringBuffer stringBuffer = new StringBuffer();
        try {
            FileInputStream fileInputStream = context.openFileInput(configurationFileName);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String nextLine = bufferedReader.readLine();
            while (nextLine != null) {
                stringBuffer.append(nextLine);
                nextLine = bufferedReader.readLine();
            }
            inputStreamReader.close();
            result = new JSONArray(stringBuffer.toString());
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to load configuration file: " + ex.getMessage());
        }
        return result;
    }

    public static enum APP_ASSET_TYPE {
        PANEL_BUTTON_HANDLE,
        PANEL_BUTTON_PARENTAL_LOCK,
        PANEL_BUTTON_EXIT,
        PANEL_BUTTON_ABOUT_KIDOZ,
        EXIT_BUTTON,
        BACK_BUTTON,
        LOCK_ACTIVE_BUTTON,
        LOCK_NOT_ACTIVE_BUTTON,
        TOP_BAR_TITLE,
        ON_BOARDING_BACKGROUND,
        BOTTOM_BAR;

    }
}

