/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.utils;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;

public class AnimationsUtils {
    public static final int ENTER_ANIMATION_TIME = 100;
    public static final int EXIT_ANIMATION_TIME = 150;
    public static final int TOUCH_DELAY_ANIMATION_TIME = 2500;

    public static void animateClick(final View view, final Animator.AnimatorListener animatorListener) {
        if (view.getMeasuredHeight() == 0 || view.getMeasuredWidth() == 0) {
            int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)-1, (int)0);
            int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)-2, (int)0);
            view.measure(widthMeasureSpec, heightMeasureSpec);
        }
        AnimatorSet animatorSetScaleDown = new AnimatorSet();
        animatorSetScaleDown.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{1.0f, 0.85f}), ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{1.0f, 0.85f})});
        animatorSetScaleDown.setDuration(100L);
        animatorSetScaleDown.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animatorSetScaleDown.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                AnimatorSet animatorSetScaleUp = new AnimatorSet();
                animatorSetScaleUp.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{0.85f, 1.0f}), ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{0.85f, 1.0f})});
                animatorSetScaleUp.setDuration(150L);
                animatorSetScaleUp.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
                if (animatorListener != null) {
                    animatorSetScaleUp.addListener(animatorListener);
                }
                animatorSetScaleUp.start();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        animatorSetScaleDown.start();
    }

    public static void animateClick(final View view, final Animator.AnimatorListener animatorListener, int enterDuration, final int exitDuration) {
        if (view.getMeasuredHeight() == 0 || view.getMeasuredWidth() == 0) {
            int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)-1, (int)0);
            int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)-2, (int)0);
            view.measure(widthMeasureSpec, heightMeasureSpec);
        }
        AnimatorSet animatorSetScaleDown = new AnimatorSet();
        animatorSetScaleDown.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{1.0f, 0.85f}), ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{1.0f, 0.85f})});
        animatorSetScaleDown.setDuration((long)enterDuration);
        animatorSetScaleDown.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animatorSetScaleDown.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                AnimatorSet animatorSetScaleUp = new AnimatorSet();
                animatorSetScaleUp.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{0.85f, 1.0f}), ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{0.85f, 1.0f})});
                animatorSetScaleUp.setDuration((long)exitDuration);
                animatorSetScaleUp.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
                if (animatorListener != null) {
                    animatorSetScaleUp.addListener(animatorListener);
                }
                animatorSetScaleUp.start();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        animatorSetScaleDown.start();
    }

    public static void animateFade(View view, boolean isFadeIn, long duration, Animator.AnimatorListener animatorListener) {
        AnimatorSet animatorSet = new AnimatorSet();
        if (isFadeIn) {
            animatorSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{0.0f, 1.0f})});
            animatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            animatorSet.setDuration(duration);
            animatorSet.addListener(animatorListener);
            animatorSet.start();
        } else {
            animatorSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{1.0f, 0.0f})});
            animatorSet.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
            animatorSet.setDuration(duration);
            animatorSet.addListener(animatorListener);
            animatorSet.start();
        }
    }

    public static void animateTopBarSlideIn(View view) {
        view.animate().translationY(0.0f).setDuration(100L).setInterpolator((TimeInterpolator)new DecelerateInterpolator());
    }

    public static void animateTopBarSlideOut(View view) {
        view.animate().translationY((float)(-1 * view.getMeasuredHeight())).setDuration(150L).setInterpolator((TimeInterpolator)new AccelerateInterpolator());
    }

    public static void animateRelatedContainerLandscapeSlideIn(View view) {
        view.animate().translationY(0.0f).setDuration(100L).setInterpolator((TimeInterpolator)new DecelerateInterpolator());
    }

    public static void animateRelatedContainerLandscapeSlideOut(View view, int translateDistance) {
        view.animate().translationY((float)translateDistance).setDuration(150L).setInterpolator((TimeInterpolator)new AccelerateInterpolator());
    }

    public static void animateRotate(View view) {
        RotateAnimation rotateAnimation = new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f);
        rotateAnimation.setDuration(450L);
        rotateAnimation.setRepeatCount(-1);
        rotateAnimation.setInterpolator((Interpolator)new LinearInterpolator());
        view.startAnimation((Animation)rotateAnimation);
    }
}

