/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.database;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.kidoz.sdk.api.general.database.BaseTable;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.structure.IsEventRecord;

public class IsEventTable
extends BaseTable {
    private final String TAG = IsEventTable.class.getName();
    private static final String TABLE_NAME = "IsEventTable";
    private static final String COLUMN_APP_ID = "COLUMN_APP_ID";
    private static final String COLUMN_TIMESTAMP = "COLUMN_TIMESTAMP";
    private static final String COLUMN_ITEM_TYPE = "COLUMN_ITEM_TYPE";
    private static final String COLUMN_POSITION_INDEX = "COLUMN_POSITION_INDEX";
    private static final String COLUMN_APP_NAME = "COLUMN_APP_NAME";
    private static final String COLUMN_ADVERTISING_ID = "COLUMN_ADVERTISING_ID";

    public IsEventTable(DatabaseManager databaseManager, Object syncObject) {
        super(databaseManager, syncObject);
    }

    public static synchronized void onCreate(SQLiteDatabase database) {
        if (database != null) {
            String CREATE_TABLE_STATEMENT = "CREATE TABLE IsEventTable(COLUMN_APP_ID TEXT PRIMARY KEY,COLUMN_TIMESTAMP TEXT,COLUMN_ITEM_TYPE TEXT,COLUMN_POSITION_INDEX INTEGER,COLUMN_APP_NAME TEXT,COLUMN_ADVERTISING_ID TEXT)";
            database.execSQL(CREATE_TABLE_STATEMENT);
        }
    }

    public static synchronized void onUpgrade(SQLiteDatabase database, int oldVersion, int newVersion) {
        if (database == null || newVersion > oldVersion) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void insertRecord(IsEventRecord record) {
        if (this.mDBmanager != null && record != null) {
            Object object = this.mSyncObject;
            synchronized (object) {
                int rowsCount = 0;
                int rowID = -1;
                SQLiteDatabase database = this.mDBmanager.getWritableDatabase();
                try {
                    database.beginTransaction();
                    ContentValues values = new ContentValues();
                    values.put(COLUMN_APP_ID, record.getPackageName());
                    values.put(COLUMN_TIMESTAMP, record.getTimeStamp());
                    values.put(COLUMN_ITEM_TYPE, record.getContentType());
                    values.put(COLUMN_POSITION_INDEX, Integer.valueOf(record.getPositionIndex()));
                    values.put(COLUMN_APP_NAME, record.getName());
                    values.put(COLUMN_ADVERTISING_ID, record.getAdvertiserId());
                    rowID = (int)database.insertWithOnConflict(TABLE_NAME, null, values, 5);
                    if (rowID != -1) {
                        ++rowsCount;
                    }
                    database.setTransactionSuccessful();
                }
                catch (Exception ex) {
                    SDKLogger.printErrorLog(this.TAG, "Error when trying to insert sdk record data: " + ex.getMessage());
                }
                finally {
                    database.endTransaction();
                    this.mDBmanager.closeDatabase();
                }
                IsEventTable.printDBLog(BaseTable.DBactionType.INSERT, "insertRecord", TABLE_NAME, rowsCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IsEventRecord getRecord(String packageName) {
        IsEventRecord record = null;
        if (this.mDBmanager != null) {
            Object object = this.mSyncObject;
            synchronized (object) {
                int rowsCount = 0;
                SQLiteDatabase database = this.mDBmanager.getReadableDatabase();
                try {
                    Cursor cursor;
                    String selection = null;
                    String[] selectionArgs = null;
                    if (packageName != null) {
                        selection = "COLUMN_APP_ID=?";
                        selectionArgs = new String[]{packageName};
                    }
                    if ((cursor = database.query(TABLE_NAME, null, selection, selectionArgs, null, null, null)) != null && cursor.getCount() > 0) {
                        rowsCount = cursor.getCount();
                        cursor.moveToFirst();
                        record = new IsEventRecord();
                        record.setPackageName(cursor.getString(cursor.getColumnIndex(COLUMN_APP_ID)));
                        record.setTimeStamp(cursor.getString(cursor.getColumnIndex(COLUMN_TIMESTAMP)));
                        record.setContentType(cursor.getString(cursor.getColumnIndex(COLUMN_ITEM_TYPE)));
                        record.setPositionIndex(cursor.getInt(cursor.getColumnIndex(COLUMN_POSITION_INDEX)));
                        record.setName(cursor.getString(cursor.getColumnIndex(COLUMN_APP_NAME)));
                        record.setAdvertiserId(cursor.getString(cursor.getColumnIndex(COLUMN_ADVERTISING_ID)));
                        while (cursor.moveToNext()) {
                        }
                    }
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                catch (Exception e) {
                    SDKLogger.printErrorLog(this.TAG, "Error when trying to load install record: " + e.getMessage());
                }
                finally {
                    this.mDBmanager.closeDatabase();
                }
                IsEventTable.printDBLog(BaseTable.DBactionType.LOAD, "load sdk record", TABLE_NAME, rowsCount);
            }
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteRecord(String packageName) {
        if (this.mDBmanager != null) {
            Object object = this.mSyncObject;
            synchronized (object) {
                int rowsCount = 0;
                int rowID = -1;
                if (packageName == null) {
                    this.clearTable(TABLE_NAME);
                } else {
                    SQLiteDatabase database = this.mDBmanager.getWritableDatabase();
                    try {
                        database.beginTransaction();
                        String selection = "COLUMN_APP_ID=?";
                        String[] selectionArgs = new String[]{packageName};
                        rowID = database.delete(TABLE_NAME, selection, selectionArgs);
                        if (rowID != -1) {
                            rowsCount = rowID;
                        }
                        database.setTransactionSuccessful();
                        database.endTransaction();
                    }
                    catch (Exception e) {
                        SDKLogger.printErrorLog(this.TAG, "Error when trying to delete sdk record: " + e.getMessage());
                    }
                    finally {
                        this.mDBmanager.closeDatabase();
                    }
                    IsEventTable.printDBLog(BaseTable.DBactionType.DELETE, "Delete Install App sdk record", TABLE_NAME, rowsCount);
                }
            }
        }
    }
}

