/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.custom_views;

import android.animation.Animator;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.RelativeLayout;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.ExitButton;
import com.kidoz.sdk.api.ui_views.ParentalLockButton;
import com.kidoz.sdk.api.ui_views.TitleView;

public class KidozTopBar
extends RelativeLayout {
    public static final String BACKGROUND_COLOR = "BACKGROUND_COLOR";
    public static final float BACKGROUND_RATIO = 0.061458334f;
    private KidozTopBarListener mKidozTopBarListener;
    private boolean mIsParentalLockVisible;
    private boolean mIsClicksBlocked;
    private TitleView mTitleView;
    private ExitButton mExitButton;
    private ParentalLockButton mParentalLockButton;

    public KidozTopBar(Context context, boolean isUseBackButton) {
        super(context);
        this.initView(isUseBackButton);
    }

    public KidozTopBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(false);
    }

    private void initView(boolean isUseBackButton) {
        this.initRootView();
        this.addBackground();
        this.initExitButton(isUseBackButton);
        this.initLockButton();
        this.initTitle();
    }

    private void initRootView() {
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return KidozTopBar.this.mIsClicksBlocked;
            }
        });
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT < 16) {
                    KidozTopBar.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    KidozTopBar.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                KidozTopBar.this.mParentalLockButton.setVisibility(4);
                if (KidozTopBar.this.mIsParentalLockVisible) {
                    KidozTopBar.this.mParentalLockButton.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            GenAnimator.playDropAnimation((View)KidozTopBar.this.mParentalLockButton, new Animator.AnimatorListener(){

                                public void onAnimationStart(Animator animation) {
                                    KidozTopBar.this.mParentalLockButton.setVisibility(0);
                                }

                                public void onAnimationEnd(Animator animation) {
                                }

                                public void onAnimationCancel(Animator animation) {
                                }

                                public void onAnimationRepeat(Animator animation) {
                                }
                            });
                        }
                    }, 370L);
                }
                KidozTopBar.this.mExitButton.setVisibility(4);
                KidozTopBar.this.mExitButton.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        GenAnimator.playDropAnimation((View)KidozTopBar.this.mExitButton, new Animator.AnimatorListener(){

                            public void onAnimationStart(Animator animation) {
                                KidozTopBar.this.mExitButton.setVisibility(0);
                            }

                            public void onAnimationEnd(Animator animation) {
                            }

                            public void onAnimationCancel(Animator animation) {
                            }

                            public void onAnimationRepeat(Animator animation) {
                            }
                        });
                    }
                }, 290L);
            }
        });
    }

    private void addBackground() {
        float height = 118.0f;
        float scaleFactor = ScreenUtils.getScaleFactor(this.getContext());
        String color2 = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), BACKGROUND_COLOR, "#04a0e1", 0);
        View view = new View(this.getContext());
        view.setBackgroundColor(Color.parseColor((String)color2));
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, (int)(height * scaleFactor));
        this.addView(view, (ViewGroup.LayoutParams)params);
    }

    private void initTitle() {
        this.mTitleView = new TitleView(this.getContext());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        this.addView((View)this.mTitleView, (ViewGroup.LayoutParams)params);
    }

    private void initLockButton() {
        this.mIsParentalLockVisible = true;
        this.mParentalLockButton = new ParentalLockButton(this.getContext(), new ParentalLockButton.ParentalLockButtonListener(){

            @Override
            public void onClickStarted() {
            }

            @Override
            public void onClickEnd() {
                if (!KidozTopBar.this.mIsClicksBlocked) {
                    KidozTopBar.this.mIsClicksBlocked = true;
                    int lockStatus = SharedPreferencesUtils.loadSharedPreferencesData(KidozTopBar.this.getContext(), "PARENTAL_LOCK_ACTIVE_KEY") == null ? 0 : 1;
                    EventManager.getInstance().LogEventWithIntField(KidozTopBar.this.getContext(), EventManager.LOG_NORMAL_LEVEL, "Parental Lock", "Click", "Lock Button", lockStatus);
                    if (ParentalLockDialog.getIsCanShowDialog(KidozTopBar.this.getContext())) {
                        int[] popLocation = new int[]{(int)((float)ScreenUtils.getScreenSize(KidozTopBar.this.getContext(), true) * 0.722f), (int)((float)ScreenUtils.getScreenSize(KidozTopBar.this.getContext(), false) * 0.04f)};
                        ParentalLockDialog parentalLockDialog = new ParentalLockDialog(KidozTopBar.this.getContext(), false, popLocation);
                        parentalLockDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                            public void onDismiss(DialogInterface dialog) {
                                KidozTopBar.this.mIsClicksBlocked = false;
                                boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(KidozTopBar.this.getContext(), "PARENTAL_LOCK_ACTIVE_KEY") != null;
                                KidozTopBar.this.mParentalLockButton.setIsLockActive(isLockActive);
                            }
                        });
                        parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener(){

                            @Override
                            public void onPasswordEntered(boolean isPasswordCorrect) {
                                boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(KidozTopBar.this.getContext(), "PARENTAL_LOCK_ACTIVE_KEY") != null;
                                KidozTopBar.this.mParentalLockButton.setIsLockActive(isLockActive);
                            }
                        });
                        parentalLockDialog.show();
                    } else {
                        KidozTopBar.this.mIsClicksBlocked = false;
                    }
                }
            }
        });
        this.mParentalLockButton.setId(Utils.generateViewId());
        boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), "PARENTAL_LOCK_ACTIVE_KEY") != null;
        this.mParentalLockButton.setIsLockActive(isLockActive);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(0, this.mExitButton.getId());
        params.rightMargin = (int)(5.0f * ScreenUtils.getScaleFactor(this.getContext()));
        this.addView((View)this.mParentalLockButton, (ViewGroup.LayoutParams)params);
    }

    private void initExitButton(boolean isUseBackButton) {
        this.mExitButton = new ExitButton(this.getContext(), new ExitButton.ExitButtonListener(){

            @Override
            public void onClickStarted() {
            }

            @Override
            public void onClickEnd() {
                if (!KidozTopBar.this.mIsClicksBlocked) {
                    KidozTopBar.this.mIsClicksBlocked = true;
                    EventManager.getInstance().LogEvent(KidozTopBar.this.getContext(), EventManager.LOG_NORMAL_LEVEL, null, "SDK", "Click", "Back Button");
                    if (KidozTopBar.this.mKidozTopBarListener != null) {
                        KidozTopBar.this.mKidozTopBarListener.onExitClicked(null);
                    }
                }
            }
        }, isUseBackButton);
        this.mExitButton.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(11);
        params.rightMargin = (int)(5.0f * ScreenUtils.getScaleFactor(this.getContext()));
        this.addView((View)this.mExitButton, (ViewGroup.LayoutParams)params);
    }

    public void setKidozTopBarListener(KidozTopBarListener kidozTopBarListener) {
        this.mKidozTopBarListener = kidozTopBarListener;
    }

    public void setTitle(String title) {
        if (this.mTitleView != null) {
            this.mTitleView.setTitle(title);
            this.invalidate();
        }
    }

    public void setTopBarBackgroundColor(int color2) {
    }

    private static int getTitleTextSizeByScreenLayout(Context context) {
        int size = 20;
        int screenLayout = context.getResources().getConfiguration().screenLayout;
        switch (screenLayout &= 0xF) {
            case 1: {
                size = 18;
                break;
            }
            case 2: {
                size = 21;
                break;
            }
            case 3: {
                size = 26;
                break;
            }
            case 4: {
                size = 30;
            }
        }
        return size;
    }

    public void showParentalLockIcon(boolean show) {
        this.mIsParentalLockVisible = show;
        if (this.mIsParentalLockVisible) {
            this.mParentalLockButton.setVisibility(0);
        } else {
            this.mParentalLockButton.setVisibility(4);
        }
    }

    public static interface KidozTopBarListener {
        public void onExitClicked(View var1);
    }
}

