/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.custom_views;

import android.animation.Animator;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Color;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.custom_views.CloseButtonImageView;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.players.web_player.KidozWebView;
import com.kidoz.sdk.api.ui_views.AboutKidozView;
import com.kidoz.sdk.api.ui_views.AboutKidozWebViewContainer;
import com.kidoz.sdk.api.ui_views.BottomBarView;

public class KidozBottomBar
extends RelativeLayout {
    public static final float BACKGROUND_RATIO = 0.061458334f;
    private Utils.StaticHandler mStaticHandler = new Utils.StaticHandler();
    private AboutKidozWebViewContainer mAboutKidozContainer;
    private int[] mAboutKidozPivot;
    private boolean mIsOrientationPortrait;
    private KidozWebView mKidozWebView;
    private boolean mIsNeedToCloseWebViewOnClick = true;

    public KidozBottomBar(Context context) {
        super(context);
        this.initView();
    }

    public KidozBottomBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    private void initView() {
        this.mIsOrientationPortrait = this.getContext().getResources().getConfiguration().orientation == 1;
        this.initBackground();
        this.initAboutKidoz();
    }

    private void initAboutKidoz() {
        int screenMaxSize = Math.min(ScreenUtils.getScreenSize(this.getContext(), true), ScreenUtils.getScreenSize(this.getContext(), false));
        float MARGIN = 0.046296295f;
        AboutKidozView aboutKidozView = new AboutKidozView(this.getContext());
        aboutKidozView.setId(Utils.generateViewId());
        aboutKidozView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                KidozBottomBar.this.mIsNeedToCloseWebViewOnClick = true;
                KidozBottomBar.this.mAboutKidozContainer.setVisibility(0);
                GenAnimator.playPopInFromRightBottom((View)KidozBottomBar.this.mAboutKidozContainer, KidozBottomBar.this.mAboutKidozPivot, new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                        KidozBottomBar.this.mAboutKidozContainer.setVisibility(0);
                    }

                    public void onAnimationEnd(Animator animation) {
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
            }
        });
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.rightMargin = (int)((float)screenMaxSize * MARGIN);
        params.addRule(11);
        params.addRule(12);
        this.addView((View)aboutKidozView, (ViewGroup.LayoutParams)params);
        this.mAboutKidozPivot = new int[2];
        this.mAboutKidozPivot[0] = aboutKidozView.getLayoutParams().width / 2;
        this.mAboutKidozPivot[1] = aboutKidozView.getLayoutParams().height;
        this.mKidozWebView = new KidozWebView(this.getContext());
        this.mKidozWebView.getSettings().setUseWideViewPort(true);
        this.mKidozWebView.getSettings().setLoadWithOverviewMode(true);
        this.mKidozWebView.getSettings().setSupportZoom(false);
        this.mKidozWebView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                KidozBottomBar.this.mIsNeedToCloseWebViewOnClick = false;
                if (url.startsWith("mailto:")) {
                    Intent mailIntent = new Intent("android.intent.action.SENDTO", Uri.parse((String)url));
                    KidozBottomBar.this.getContext().startActivity(mailIntent);
                } else {
                    view.loadUrl(url);
                }
                return true;
            }
        });
        this.mKidozWebView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                boolean result = false;
                if (event.getAction() == 1) {
                    KidozBottomBar.this.mStaticHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (KidozBottomBar.this.mIsNeedToCloseWebViewOnClick && KidozBottomBar.this.mAboutKidozContainer.getVisibility() == 0) {
                                KidozBottomBar.this.hideAboutView();
                            }
                            KidozBottomBar.this.mIsNeedToCloseWebViewOnClick = true;
                        }
                    }, 150L);
                } else {
                    if (event.getAction() == 2) {
                        KidozBottomBar.this.mIsNeedToCloseWebViewOnClick = false;
                    }
                    if (KidozBottomBar.this.mIsOrientationPortrait) {
                        result = event.getAction() == 2;
                    }
                }
                return result;
            }
        });
        this.mKidozWebView.setLongClickable(true);
        this.mKidozWebView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return true;
            }
        });
        this.mKidozWebView.setVerticalScrollBarEnabled(false);
        this.mKidozWebView.setHorizontalScrollBarEnabled(false);
        this.mKidozWebView.loadUrl("http://kidoz.net/v3policy/");
        this.mAboutKidozContainer = new AboutKidozWebViewContainer(this.getContext());
        this.mAboutKidozContainer.setVisibility(4);
        this.mAboutKidozContainer.addView((View)this.mKidozWebView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        CloseButtonImageView closeButtonImageView = new CloseButtonImageView(this.getContext(), Color.parseColor((String)"#04a0e1"));
        closeButtonImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GenAnimator.clickItemAnimation(v, 100, new GenAnimator.ViewAnimationListener(){

                    @Override
                    public void onAnimationEnd() {
                        KidozBottomBar.this.hideAboutView();
                    }

                    @Override
                    public void onAnimationStart() {
                    }
                });
            }
        });
        int padding = Utils.dpTOpx(this.getContext(), 10);
        closeButtonImageView.setPadding(padding, padding, padding, padding);
        this.mAboutKidozContainer.addView((View)closeButtonImageView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
        RelativeLayout.LayoutParams webViewContainerParams = new RelativeLayout.LayoutParams(-2, -2);
        webViewContainerParams.addRule(7, aboutKidozView.getId());
        webViewContainerParams.addRule(8, aboutKidozView.getId());
        webViewContainerParams.leftMargin = (int)((float)screenMaxSize * MARGIN);
        this.addView((View)this.mAboutKidozContainer, (ViewGroup.LayoutParams)webViewContainerParams);
    }

    public void hideAboutView() {
        GenAnimator.playPopOutToRightBottom((View)this.mAboutKidozContainer, this.mAboutKidozPivot, new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                KidozBottomBar.this.mAboutKidozContainer.setVisibility(4);
                KidozBottomBar.this.mKidozWebView.goBack();
            }

            public void onAnimationCancel(Animator animation) {
                KidozBottomBar.this.mAboutKidozContainer.setVisibility(4);
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    public boolean isAboutViewVisible() {
        return this.mAboutKidozContainer.getVisibility() == 0;
    }

    private void initBackground() {
        BottomBarView bottomBarView = new BottomBarView(this.getContext());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(12);
        params.addRule(14);
        this.addView((View)bottomBarView, (ViewGroup.LayoutParams)params);
    }

    public void setBackgroundURI() {
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mIsOrientationPortrait = this.getContext().getResources().getConfiguration().orientation == 1;
        this.mKidozWebView.scrollTo(0, 0);
    }
}

